/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.tools.StateChangeLogMerger;
import kafka.tools.StateChangeLogMerger$dateBasedOrdering$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.PriorityQueue;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex;

public final class StateChangeLogMerger$
implements Logging {
    public static final StateChangeLogMerger$ MODULE$ = new StateChangeLogMerger$();
    private static final String dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
    private static final Regex topicPartitionRegex = new Regex("\\[([a-zA-Z0-9._-]+),( )*([0-9]+)\\]", (Seq)Nil$.MODULE$);
    private static final Regex dateRegex = new Regex("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3}", (Seq)Nil$.MODULE$);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat(MODULE$.dateFormatString());
    private static List<String> files = Nil$.MODULE$;
    private static String topic = null;
    private static List<Object> partitions = Nil$.MODULE$;
    private static Date startDate = null;
    private static Date endDate = null;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String dateFormatString() {
        return dateFormatString;
    }

    public Regex topicPartitionRegex() {
        return topicPartitionRegex;
    }

    public Regex dateRegex() {
        return dateRegex;
    }

    public SimpleDateFormat dateFormat() {
        return dateFormat;
    }

    public List<String> files() {
        return files;
    }

    public void files_$eq(List<String> x$1) {
        files = x$1;
    }

    public String topic() {
        return topic;
    }

    public void topic_$eq(String x$1) {
        topic = x$1;
    }

    public List<Object> partitions() {
        return partitions;
    }

    public void partitions_$eq(List<Object> x$1) {
        partitions = x$1;
    }

    public Date startDate() {
        return startDate;
    }

    public void startDate_$eq(Date x$1) {
        startDate = x$1;
    }

    public Date endDate() {
        return endDate;
    }

    public void endDate_$eq(Date x$1) {
        endDate = x$1;
    }

    public void main(String[] args) {
        Nil$ nil$;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec filesOpt = parser.accepts("logs", "Comma separated list of state change logs or a regex for the log file names").withRequiredArg().describedAs("file1,file2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec regexOpt = parser.accepts("logs-regex", "Regex to match the state change log files to be merged").withRequiredArg().describedAs("for example: /tmp/state-change.log*").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "The topic whose state change logs should be merged").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionsOpt = parser.accepts("partitions", "Comma separated list of partition ids whose state change logs should be merged").withRequiredArg().describedAs("0,1,2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec startTimeOpt = parser.accepts("start-time", "The earliest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder(30).append("start timestamp in the format ").append(this.dateFormat()).toString()).ofType(String.class).defaultsTo((Object)"0000-00-00 00:00:00,000", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec endTimeOpt = parser.accepts("end-time", "The latest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder(28).append("end timestamp in the format ").append(this.dateFormat()).toString()).ofType(String.class).defaultsTo((Object)"9999-12-31 23:59:59,999", (Object[])new String[0]);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "A tool for merging the log files from several brokers to reconnstruct a unified history of what happened.");
        }
        OptionSet options = parser.parse(args);
        if (!options.has((OptionSpec)filesOpt) && !options.has((OptionSpec)regexOpt) || options.has((OptionSpec)filesOpt) && options.has((OptionSpec)regexOpt)) {
            System.err.println(new StringBuilder(60).append("Provide arguments to exactly one of the two options \"").append(filesOpt).append("\" or \"").append(regexOpt).append("\"").toString());
            parser.printHelpOn((OutputStream)System.err);
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        if (options.has((OptionSpec)partitionsOpt) && !options.has((OptionSpec)topicOpt)) {
            System.err.println(new StringBuilder(76).append("The option \"").append(topicOpt).append("\" needs to be provided an argument when specifying partition ids").toString());
            parser.printHelpOn((OutputStream)System.err);
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        if (options.has((OptionSpec)filesOpt)) {
            ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray((Object[])((String)options.valueOf((OptionSpec)filesOpt)).split(","));
            if (ofRef2 == null) {
                throw null;
            }
            this.files_$eq((List<String>)this.files().$colon$colon$colon(IterableOnceOps.toList$((IterableOnceOps)ofRef2)));
        } else if (options.has((OptionSpec)regexOpt)) {
            Object var31_25;
            Object object;
            File[] fileArray;
            String regex = (String)options.valueOf((OptionSpec)regexOpt);
            int fileNameIndex = regex.lastIndexOf(47) + 1;
            String dirName = fileNameIndex == 0 ? "." : regex.substring(0, fileNameIndex - 1);
            Regex fileNameRegex = new Regex(regex.substring(fileNameIndex), (Seq)Nil$.MODULE$);
            List<String> list = this.files();
            File[] fileArray2 = fileArray = new File(dirName).listFiles();
            fileArray = null;
            File[] filter$extension_$this = fileArray2;
            ClassTag filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(filter$extension_$this.getClass().getComponentType());
            Class clazz = filter$extension_make_evidence$1.runtimeClass();
            Class<Byte> clazz2 = Byte.TYPE;
            if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
                object = new ArrayBuilder.ofByte();
            } else {
                Class<Short> clazz3 = Short.TYPE;
                if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                    object = new ArrayBuilder.ofShort();
                } else {
                    Class<Character> clazz4 = Character.TYPE;
                    if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofChar();
                    } else {
                        Class<Integer> clazz5 = Integer.TYPE;
                        if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofInt();
                        } else {
                            Class<Long> clazz6 = Long.TYPE;
                            if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofLong();
                            } else {
                                Class<Float> clazz7 = Float.TYPE;
                                if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofFloat();
                                } else {
                                    Class<Double> clazz8 = Double.TYPE;
                                    if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofDouble();
                                    } else {
                                        Class<Boolean> clazz9 = Boolean.TYPE;
                                        if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                            object = new ArrayBuilder.ofBoolean();
                                        } else {
                                            Class<Void> clazz10 = Void.TYPE;
                                            object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filter$extension_make_evidence$1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ArrayBuilder.ofByte ofByte2 = object;
            Object var27_16 = null;
            object = null;
            clazz = null;
            ArrayBuilder.ofByte filter$extension_res = ofByte2;
            for (int filter$extension_i = 0; filter$extension_i < filter$extension_$this.length; ++filter$extension_i) {
                File file;
                File file2 = file = filter$extension_$this[filter$extension_i];
                file = null;
                File filter$extension_x = file2;
                if (!StateChangeLogMerger$.$anonfun$main$1(fileNameRegex, filter$extension_x)) continue;
                filter$extension_res.addOne((Object)filter$extension_x);
            }
            Object var23_15 = null;
            Object var24_19 = null;
            Object var26_22 = null;
            Object[] map$extension_$this = (Object[])filter$extension_res.result();
            int n = map$extension_$this.length;
            String[] map$extension_ys = new String[n];
            if (n > 0) {
                for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                    String array_update_value;
                    File file = (File)map$extension_$this[map$extension_i];
                    map$extension_ys[map$extension_i] = array_update_value = StateChangeLogMerger$.$anonfun$main$2(dirName, file);
                    Object var51_28 = null;
                }
            }
            void v14 = var31_25;
            Object var30_23 = null;
            var31_25 = null;
            ArraySeq.ofRef ofRef3 = Predef$.MODULE$.wrapRefArray((Object[])v14);
            if (ofRef3 == null) {
                throw null;
            }
            this.files_$eq((List<String>)list.$colon$colon$colon(IterableOnceOps.toList$((IterableOnceOps)ofRef3)));
        }
        if (options.has((OptionSpec)topicOpt)) {
            this.topic_$eq((String)options.valueOf((OptionSpec)topicOpt));
        }
        if (options.has((OptionSpec)partitionsOpt)) {
            Nil$ nil$2;
            ArraySeq.ofRef ofRef4 = Predef$.MODULE$.wrapRefArray((Object[])((String)options.valueOf((OptionSpec)partitionsOpt)).split(","));
            if (ofRef4 == null) {
                throw null;
            }
            List list = IterableOnceOps.toList$((IterableOnceOps)ofRef4);
            if (list == null) {
                throw null;
            }
            List map_this = list;
            if (map_this == Nil$.MODULE$) {
                nil$2 = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)StateChangeLogMerger$.$anonfun$main$3((String)map_this.head()), (List)Nil$.MODULE$);
                for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)StateChangeLogMerger$.$anonfun$main$3((String)map_rest.head()), (List)Nil$.MODULE$);
                    map_t.next_$eq((List)map_nx);
                    map_t = map_nx;
                }
                Statics.releaseFence();
                nil$2 = map_h;
            }
            Nil$ nil$3 = nil$2;
            Object var34_29 = null;
            Object var35_31 = null;
            Object var36_32 = null;
            Object var37_33 = null;
            Object var38_34 = null;
            nil$2 = null;
            this.partitions_$eq((List<Object>)nil$3);
            Iterable<Object> duplicatePartitions = CoreUtils$.MODULE$.duplicates(this.partitions());
            if (duplicatePartitions.nonEmpty()) {
                Object[] objectArray = new Object[1];
                String mkString_sep = ",";
                Object var21_36 = null;
                objectArray[0] = duplicatePartitions.mkString("", mkString_sep, "");
                System.err.println(StringOps$.MODULE$.format$extension("The list of partitions contains repeated entries: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)));
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
        }
        this.startDate_$eq(this.dateFormat().parse(((String)options.valueOf((OptionSpec)startTimeOpt)).replace('\"', ' ').trim()));
        this.endDate_$eq(this.dateFormat().parse(((String)options.valueOf((OptionSpec)endTimeOpt)).replace('\"', ' ').trim()));
        PriorityQueue pqueue = new PriorityQueue((Ordering)StateChangeLogMerger$dateBasedOrdering$.MODULE$);
        BufferedOutputStream output = new BufferedOutputStream(System.out, 0x100000);
        List<String> list = this.files();
        if (list == null) {
            throw null;
        }
        List<String> map_this = list;
        if (map_this == Nil$.MODULE$) {
            nil$ = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            .colon.colon map_t = map_h = new .colon.colon((Object)StateChangeLogMerger$.$anonfun$main$4((String)map_this.head()), (List)Nil$.MODULE$);
            for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                .colon.colon map_nx = new .colon.colon((Object)StateChangeLogMerger$.$anonfun$main$4((String)map_rest.head()), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$ = map_h;
        }
        Nil$ nil$4 = nil$;
        Object var40_39 = null;
        Object var41_41 = null;
        Object var42_42 = null;
        Object var43_43 = null;
        Object var44_44 = null;
        nil$ = null;
        Nil$ lineIterators = nil$4;
        Nil$ nil$5 = Nil$.MODULE$;
        Nil$ foreach_these = lineIterators;
        while (!foreach_these.isEmpty()) {
            Object var50_50;
            Iterator iterator = (Iterator)foreach_these.head();
            StateChangeLogMerger.LineIterator $anonfun$main$5_lineItr = MODULE$.getNextLine((Iterator<String>)iterator);
            if (!$anonfun$main$5_lineItr.isEmpty()) {
                List $anonfun$main$5_$colon$colon_this = (List)nil$5;
                var50_50 = null;
                nil$5 = new .colon.colon((Object)$anonfun$main$5_lineItr, $anonfun$main$5_$colon$colon_this);
            }
            Object var49_49 = null;
            var50_50 = null;
            foreach_these = (List)foreach_these.tail();
        }
        Object var22_47 = null;
        if (((List)nil$5).nonEmpty()) {
            pqueue.enqueue((Seq)((List)nil$5));
        }
        while (pqueue.nonEmpty()) {
            StateChangeLogMerger.LineIterator lineItr = (StateChangeLogMerger.LineIterator)pqueue.dequeue();
            ((OutputStream)output).write(new StringBuilder(1).append(lineItr.line()).append("\n").toString().getBytes(StandardCharsets.UTF_8));
            StateChangeLogMerger.LineIterator nextLineItr = this.getNextLine(lineItr.itr());
            if (nextLineItr.isEmpty()) continue;
            pqueue.enqueue((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StateChangeLogMerger.LineIterator[]{nextLineItr}));
        }
        ((OutputStream)output).flush();
    }

    public StateChangeLogMerger.LineIterator getNextLine(Iterator<String> itr) {
        Object object = new Object();
        try {
            while (itr != null && itr.hasNext()) {
                Option foreach_this;
                String nextLine = (String)itr.next();
                if (this.dateRegex().findFirstIn((CharSequence)nextLine) == null) {
                    throw null;
                }
                if (!foreach_this.isEmpty()) {
                    String string = (String)foreach_this.get();
                    StateChangeLogMerger$.$anonfun$getNextLine$1(nextLine, object, itr, string);
                }
                Object var5_4 = null;
            }
            return new StateChangeLogMerger.LineIterator();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (StateChangeLogMerger.LineIterator)ex.value();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ boolean $anonfun$main$1(Regex fileNameRegex$1, File f) {
        return fileNameRegex$1.findFirstIn((CharSequence)f.getName()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$main$2(String dirName$1, File x$1) {
        return new StringBuilder(1).append(dirName$1).append("/").append(x$1.getName()).toString();
    }

    public static final /* synthetic */ int $anonfun$main$3(String x$2) {
        return Integer.parseInt(x$2);
    }

    public static final /* synthetic */ Iterator $anonfun$main$4(String x$3) {
        return Source$.MODULE$.fromFile(x$3, Codec$.MODULE$.fallbackSystemCodec()).getLines();
    }

    public static final /* synthetic */ void $anonfun$main$5(ObjectRef lines$1, Iterator itr) {
        StateChangeLogMerger.LineIterator lineItr = MODULE$.getNextLine((Iterator<String>)itr);
        if (!lineItr.isEmpty()) {
            List list = (List)lines$1.elem;
            if (list == null) {
                throw null;
            }
            List $colon$colon_this = list;
            lines$1.elem = new .colon.colon((Object)lineItr, $colon$colon_this);
        }
    }

    public static final /* synthetic */ void $anonfun$getNextLine$2(Object nonLocalReturnKey1$1, String nextLine$1, Iterator itr$1, Regex.Match matcher) {
        block8: {
            block6: {
                String string;
                String string2;
                block7: {
                    if (MODULE$.topic() == null) break block6;
                    string2 = MODULE$.topic();
                    string = matcher.group(1);
                    if (string2 != null) break block7;
                    if (string != null) {
                        return;
                    }
                    break block6;
                }
                if (!string2.equals(string)) break block8;
            }
            if (MODULE$.partitions().isEmpty() || MODULE$.partitions().contains((Object)Integer.parseInt(matcher.group(3)))) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new StateChangeLogMerger.LineIterator(nextLine$1, (Iterator<String>)itr$1));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$getNextLine$1(String nextLine$1, Object nonLocalReturnKey1$1, Iterator itr$1, String d) {
        Date date = MODULE$.dateFormat().parse(d);
        if ((date.equals(MODULE$.startDate()) || date.after(MODULE$.startDate())) && (date.equals(MODULE$.endDate()) || date.before(MODULE$.endDate()))) {
            Option option = MODULE$.topicPartitionRegex().findFirstMatchIn((CharSequence)nextLine$1);
            if (option == null) {
                throw null;
            }
            Option foreach_this = option;
            if (!foreach_this.isEmpty()) {
                Regex.Match match = (Regex.Match)foreach_this.get();
                StateChangeLogMerger$.$anonfun$getNextLine$2(nonLocalReturnKey1$1, nextLine$1, itr$1, match);
            }
        }
    }

    private StateChangeLogMerger$() {
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(Regex fileNameRegex$1, File f) {
        return BoxesRunTime.boxToBoolean((boolean)StateChangeLogMerger$.$anonfun$main$1(fileNameRegex$1, f));
    }

    public static final /* synthetic */ Object $anonfun$main$3$adapted(String x$2) {
        return BoxesRunTime.boxToInteger((int)StateChangeLogMerger$.$anonfun$main$3(x$2));
    }

    public static final /* synthetic */ Object $anonfun$main$5$adapted(ObjectRef lines$1, Iterator itr) {
        StateChangeLogMerger$.$anonfun$main$5(lines$1, itr);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$getNextLine$1$adapted(String nextLine$1, Object nonLocalReturnKey1$1, Iterator itr$1, String d) {
        StateChangeLogMerger$.$anonfun$getNextLine$1(nextLine$1, nonLocalReturnKey1$1, itr$1, d);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$getNextLine$2$adapted(Object nonLocalReturnKey1$1, String nextLine$1, Iterator itr$1, Regex.Match matcher) {
        StateChangeLogMerger$.$anonfun$getNextLine$2(nonLocalReturnKey1$1, nextLine$1, itr$1, matcher);
        return BoxedUnit.UNIT;
    }
}

