/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.token.delegation;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import kafka.network.RequestChannel;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.security.authorizer.AuthorizerUtils$;
import kafka.server.CreateTokenResult;
import kafka.server.Defaults$;
import kafka.server.DelegationTokenManager;
import kafka.server.DelegationTokenManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t]c\u0001\u0002\u0017.\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004Q\u0001\u0001\u0006Ia\u0011\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0011\u0019Q\u0006\u0001)A\u0005'\"91\f\u0001b\u0001\n\u0003a\u0006BB4\u0001A\u0003%Q\fC\u0004i\u0001\t\u0007I\u0011A5\t\rY\u0004\u0001\u0015!\u0003k\u0011\u001d9\bA1A\u0005\u0002aDq!a\u0001\u0001A\u0003%\u0011\u0010C\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001\u0002\b!A\u0011\u0011\u0003\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0001\u0002\b!A\u0011Q\u0003\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0001\u0002\u001a!I\u00111\u0006\u0001A\u0002\u0013\u0005\u0011Q\u0006\u0005\t\u0003s\u0001\u0001\u0015)\u0003\u0002\u001c!I\u00111\b\u0001A\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003\u0017\u0002\u0001\u0019!C\u0001\u0003\u001bB\u0001\"!\u0015\u0001A\u0003&\u0011q\b\u0005\f\u0003'\u0002\u0001\u0019!a\u0001\n\u0003\t)\u0006C\u0006\u0002^\u0001\u0001\r\u00111A\u0005\u0002\u0005}\u0003bCA2\u0001\u0001\u0007\t\u0011)Q\u0005\u0003/B\u0011\"!\u001a\u0001\u0001\u0004%\t!a\u001a\t\u0013\u0005U\u0004\u00011A\u0005\u0002\u0005]\u0004\u0002CA>\u0001\u0001\u0006K!!\u001b\t\u0013\u0005u\u0004\u00011A\u0005\u0002\u0005\u001d\u0001\"CA@\u0001\u0001\u0007I\u0011AAA\u0011!\t)\t\u0001Q!\n\u0005%\u0001bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u00033\u0003A\u0011IAE\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003\u0013Cq!!,\u0001\t\u0003\tI\tC\u0004\u00022\u0002!\t!!#\t\u000f\u0005U\u0006\u0001\"\u0001\u0002\n\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005%\u0005bBA_\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003\u0003\u0004A\u0011BAb\u0011\u001d\u0011y\u0002\u0001C\u0001\u0003\u0013CqAa\t\u0001\t\u0013\u0011)\u0003C\u0004\u0003,\u0001!IA!\f\t\u000f\tU\u0002\u0001\"\u0003\u00038\tQB)\u001a7fO\u0006$\u0018n\u001c8U_.,g.T1oC\u001e,'\u000fV3ti*\u0011afL\u0001\u000bI\u0016dWmZ1uS>t'B\u0001\u00192\u0003\u0015!xn[3o\u0015\t\u00114'\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005!\u0014!B6bM.\f7\u0001A\n\u0003\u0001]\u0002\"\u0001O\u001e\u000e\u0003eR!AO\u001a\u0002\u0005i\\\u0017B\u0001\u001f:\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012a\u0010\t\u0003\u0001\u0002i\u0011!L\u0001\u0005i&lW-F\u0001D!\t!e*D\u0001F\u0015\t1u)A\u0003vi&d7O\u0003\u0002I\u0013\u000611m\\7n_:T!\u0001\u000e&\u000b\u0005-c\u0015AB1qC\u000eDWMC\u0001N\u0003\ry'oZ\u0005\u0003\u001f\u0016\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0006_^tWM]\u000b\u0002'B\u0011A\u000bW\u0007\u0002+*\u0011akV\u0001\u0005CV$\bN\u0003\u00023\u000f&\u0011\u0011,\u0016\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003\u0019ywO\\3sA\u00059!/\u001a8fo\u0016\u0014X#A/\u0011\u0007y+7+D\u0001`\u0015\t\u0001\u0017-A\u0005j[6,H/\u00192mK*\u0011!mY\u0001\u000bG>dG.Z2uS>t'\"\u00013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019|&\u0001\u0002'jgR\f\u0001B]3oK^,'\u000fI\u0001\u000ei>\\WM\\'b]\u0006<WM]:\u0016\u0003)\u00042a\u001b8q\u001b\u0005a'BA7b\u0003\u001diW\u000f^1cY\u0016L!a\u001c7\u0003\r\t+hMZ3s!\t\tH/D\u0001s\u0015\t\u00198'\u0001\u0004tKJ4XM]\u0005\u0003kJ\u0014a\u0003R3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM]\u0001\u000fi>\\WM\\'b]\u0006<WM]:!\u0003%i\u0017m\u001d;fe.+\u00170F\u0001z!\tQx0D\u0001|\u0015\taX0\u0001\u0003mC:<'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003Y(AB*ue&tw-\u0001\u0006nCN$XM]&fs\u0002\nA#\\1y\u0019&4W\rV5nK6\u001bH)\u001a4bk2$XCAA\u0005!\u0011\tY!!\u0004\u000e\u0003\rL1!a\u0004d\u0005\u0011auN\\4\u0002+5\f\u0007\u0010T5gKRKW.Z't\t\u00164\u0017-\u001e7uA\u0005\u0011\"/\u001a8foRKW.Z't\t\u00164\u0017-\u001e7u\u0003M\u0011XM\\3x)&lW-T:EK\u001a\fW\u000f\u001c;!\u0003)!xn[3o\u0007\u0006\u001c\u0007.Z\u000b\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005j]R,'O\\1mg*\u0019a&!\n\u000b\u0005A:\u0016\u0002BA\u0015\u0003?\u0011A\u0003R3mK\u001e\fG/[8o)>\\WM\\\"bG\",\u0017A\u0004;pW\u0016t7)Y2iK~#S-\u001d\u000b\u0005\u0003_\t)\u0004\u0005\u0003\u0002\f\u0005E\u0012bAA\u001aG\n!QK\\5u\u0011%\t9$EA\u0001\u0002\u0004\tY\"A\u0002yIE\n1\u0002^8lK:\u001c\u0015m\u00195fA\u0005)\u0001O]8qgV\u0011\u0011q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI?\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0013\n\u0019E\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0002\u001d:paN|F%Z9\u0015\t\u0005=\u0012q\n\u0005\n\u0003o!\u0012\u0011!a\u0001\u0003\u007f\ta\u0001\u001d:paN\u0004\u0013!E2sK\u0006$X\rV8lK:\u0014Vm];miV\u0011\u0011q\u000b\t\u0004c\u0006e\u0013bAA.e\n\t2I]3bi\u0016$vn[3o%\u0016\u001cX\u000f\u001c;\u0002+\r\u0014X-\u0019;f)>\\WM\u001c*fgVdGo\u0018\u0013fcR!\u0011qFA1\u0011%\t9dFA\u0001\u0002\u0004\t9&\u0001\nde\u0016\fG/\u001a+pW\u0016t'+Z:vYR\u0004\u0013!B3se>\u0014XCAA5!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8\u000f\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002t\u00055$AB#se>\u00148/A\u0005feJ|'o\u0018\u0013fcR!\u0011qFA=\u0011%\t9DGA\u0001\u0002\u0004\tI'\u0001\u0004feJ|'\u000fI\u0001\u0010Kb\u0004\u0018N]=US6,7\u000b^1na\u0006\u0019R\r\u001f9jef$\u0016.\\3Ti\u0006l\u0007o\u0018\u0013fcR!\u0011qFAB\u0011%\t9$HA\u0001\u0002\u0004\tI!\u0001\tfqBL'/\u001f+j[\u0016\u001cF/Y7qA\u0005)1/\u001a;VaR\u0011\u0011q\u0006\u0015\u0004?\u00055\u0005\u0003BAH\u0003+k!!!%\u000b\u0007\u0005ME*A\u0003kk:LG/\u0003\u0003\u0002\u0018\u0006E%A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\r\u0001\u0013Q\u0014\t\u0005\u0003\u001f\u000by*\u0003\u0003\u0002\"\u0006E%!B!gi\u0016\u0014\u0018\u0001\f;fgR$vn[3o%\u0016\fX/Z:ug^KG\u000f\u001b#fY\u0016<\u0017\r^5p]R{7.\u001a8ESN\f'\r\\3eQ\r\t\u0013q\u0015\t\u0005\u0003\u001f\u000bI+\u0003\u0003\u0002,\u0006E%\u0001\u0002+fgR\fq\u0002^3ti\u000e\u0013X-\u0019;f)>\\WM\u001c\u0015\u0004E\u0005\u001d\u0016A\u0004;fgR\u0014VM\\3x)>\\WM\u001c\u0015\u0004G\u0005\u001d\u0016a\u0004;fgR,\u0005\u0010]5sKR{7.\u001a8)\u0007\u0011\n9+A\nuKN$(+Z7pm\u0016$vn[3o\u00116\f7\rK\u0002&\u0003O\u000b\u0011\u0003^3ti\u0012+7o\u0019:jE\u0016$vn[3oQ\r1\u0013qU\u0001\nO\u0016$Hk\\6f]N$B\"!2\u0002d\u0006\u001d\u0018q\u001fB\u000b\u00053\u0001b!a2\u0002X\u0006mg\u0002BAe\u0003'tA!a3\u0002R6\u0011\u0011Q\u001a\u0006\u0004\u0003\u001f,\u0014A\u0002\u001fs_>$h(C\u0001e\u0013\r\t)nY\u0001\ba\u0006\u001c7.Y4f\u0013\r1\u0017\u0011\u001c\u0006\u0004\u0003+\u001c\u0007\u0003BAo\u0003?l!!a\t\n\t\u0005\u0005\u00181\u0005\u0002\u0010\t\u0016dWmZ1uS>tGk\\6f]\"1\u0011Q]\u0014A\u0002A\fA\u0002^8lK:l\u0015M\\1hKJDq!!;(\u0001\u0004\tY/A\u0007bG2\fU\u000f\u001e5pe&TXM\u001d\t\u0005\u0003[\f\u00190\u0004\u0002\u0002p*\u0019\u0011\u0011_\u0019\u0002\u0015\u0005,H\u000f[8sSj,'/\u0003\u0003\u0002v\u0006=(!D!dY\u0006+H\u000f[8sSj,'\u000fC\u0004\u0002z\u001e\u0002\r!a?\u0002\u0017!|7\u000f^*fgNLwN\u001c\t\u0005\u0003{\u0014yA\u0004\u0003\u0002\u0000\n%a\u0002\u0002B\u0001\u0005\u000bqA!a3\u0003\u0004%\tA'C\u0002\u0003\bM\nqA\\3uo>\u00148.\u0003\u0003\u0003\f\t5\u0011A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0006\u0004\u0005\u000f\u0019\u0014\u0002\u0002B\t\u0005'\u0011qaU3tg&|gN\u0003\u0003\u0003\f\t5\u0001B\u0002B\fO\u0001\u00071+\u0001\tsKF,Xm\u001d;Qe&t7-\u001b9bY\"9!1D\u0014A\u0002\tu\u0011a\u0004:fcV,7\u000f^3e\u001f^tWM]:\u0011\u000b\u0005\u001d\u0017q[*\u0002/Q,7\u000f\u001e)fe&|G-[2U_.,g.\u0012=qSJL\bf\u0001\u0015\u0002(\u0006I2M]3bi\u0016$vn[3o%\u0016\u001cX\u000f\u001c;DC2d')Y2l)\u0011\tyCa\n\t\u000f\t%\u0012\u00061\u0001\u0002X\u0005\u0019!/\u001a;\u0002+I,g.Z<SKN\u0004xN\\:f\u0007\u0006dGNY1dWR1\u0011q\u0006B\u0018\u0005cAqA!\u000b+\u0001\u0004\tI\u0007C\u0004\u00034)\u0002\r!!\u0003\u0002\u0013QLW.Z*uC6\u0004\u0018\u0001H2sK\u0006$X\rR3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM\u001d\u000b\na\ne\"1\tB#\u0005\u001bBqAa\u000f,\u0001\u0004\u0011i$\u0001\u0004d_:4\u0017n\u001a\t\u0004c\n}\u0012b\u0001B!e\nY1*\u00194lC\u000e{gNZ5h\u0011\u001d\t9b\u000ba\u0001\u00037Aa!Q\u0016A\u0002\t\u001d\u0003c\u0001#\u0003J%\u0019!1J#\u0003\tQKW.\u001a\u0005\b\u0005\u001fZ\u0003\u0019\u0001B)\u0003!Q8n\u00117jK:$\bc\u0001\u001d\u0003T%\u0019!QK\u001d\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0001")
public class DelegationTokenManagerTest
extends ZooKeeperTestHarness {
    private final MockTime time = new MockTime();
    private final KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:owner");
    private final List<KafkaPrincipal> renewer = new .colon.colon((Object)SecurityUtils.parseKafkaPrincipal((String)"User:renewer1"), (List)Nil$.MODULE$);
    private final Buffer<DelegationTokenManager> tokenManagers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final String masterKey;
    private final long maxLifeTimeMsDefault = Defaults$.MODULE$.DelegationTokenMaxLifeTimeMsDefault();
    private final long renewTimeMsDefault = Defaults$.MODULE$.DelegationTokenExpiryTimeMsDefault();
    private DelegationTokenCache tokenCache = null;
    private Properties props = null;
    private CreateTokenResult createTokenResult;
    private Errors error = Errors.NONE;
    private long expiryTimeStamp = 0L;

    public MockTime time() {
        return this.time;
    }

    public KafkaPrincipal owner() {
        return this.owner;
    }

    public List<KafkaPrincipal> renewer() {
        return this.renewer;
    }

    public Buffer<DelegationTokenManager> tokenManagers() {
        return this.tokenManagers;
    }

    public String masterKey() {
        return this.masterKey;
    }

    public long maxLifeTimeMsDefault() {
        return this.maxLifeTimeMsDefault;
    }

    public long renewTimeMsDefault() {
        return this.renewTimeMsDefault;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public Properties props() {
        return this.props;
    }

    public void props_$eq(Properties x$1) {
        this.props = x$1;
    }

    public CreateTokenResult createTokenResult() {
        return this.createTokenResult;
    }

    public void createTokenResult_$eq(CreateTokenResult x$1) {
        this.createTokenResult = x$1;
    }

    public Errors error() {
        return this.error;
    }

    public void error_$eq(Errors x$1) {
        this.error = x$1;
    }

    public long expiryTimeStamp() {
        return this.expiryTimeStamp;
    }

    public void expiryTimeStamp_$eq(long x$1) {
        this.expiryTimeStamp = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Before
    public void setUp() {
        void mkString_sep;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        super.setUp();
        String x$2 = this.zkConnect();
        boolean bl = true;
        boolean bl2 = true;
        int n = TestUtils$.MODULE$.RandomPort();
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$7 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$9 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n4 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$17 = none$8;
        int n5 = 1;
        int n6 = 1;
        short s = 1;
        this.props_$eq(TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, n, (Option<SecurityProtocol>)x$7, (Option<File>)x$8, (Option<Properties>)x$9, bl3, bl4, n2, bl5, n3, bl6, n4, (Option<String>)x$17, n5, true, n6, s));
        Iterable iterable = AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)ScramMechanism.mechanismNames()).asScala();
        String string = ",";
        if (iterable == null) {
            throw null;
        }
        string = null;
        this.props().put(KafkaConfig$.MODULE$.SaslEnabledMechanismsProp(), iterable.mkString("", (String)mkString_sep, ""));
        this.props().put(KafkaConfig$.MODULE$.DelegationTokenMasterKeyProp(), this.masterKey());
        this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
    }

    @Override
    @After
    public void tearDown() {
        this.tokenManagers().foreach((Function1 & Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTokenRequestsWithDelegationTokenDisabled() {
        void sameElements_that;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.createTokenResult().error());
        ArraySeq.ofByte ofByte2 = Predef$.MODULE$.wrapByteArray((byte[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()));
        ArraySeq.ofByte ofByte3 = Predef$.MODULE$.wrapByteArray(this.createTokenResult().hmac());
        if (ofByte2 == null) {
            throw null;
        }
        ofByte3 = null;
        Predef$.MODULE$.assert(SeqOps.sameElements$((SeqOps)ofByte2, (IterableOnce)sameElements_that));
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap("test".getBytes()), 1000000L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.error());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap("test".getBytes()), 1000000L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.error());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateToken() {
        void sameElements_that;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        Option token = tokenManager.getToken(tokenId);
        Assert.assertTrue((!token.isEmpty() ? 1 : 0) != 0);
        ArraySeq.ofByte ofByte2 = Predef$.MODULE$.wrapByteArray(password);
        ArraySeq.ofByte ofByte3 = Predef$.MODULE$.wrapByteArray(((DelegationToken)token.get()).hmac());
        if (ofByte2 == null) {
            throw null;
        }
        ofByte3 = null;
        Assert.assertTrue((boolean)SeqOps.sameElements$((SeqOps)ofByte2, (IterableOnce)sameElements_that));
    }

    @Test
    public void testRenewToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        long maxLifeTime = issueTime + this.maxLifeTimeMsDefault();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), maxLifeTime, tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap("test".getBytes()), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)this.error());
        KafkaPrincipal unknownOwner = SecurityUtils.parseKafkaPrincipal((String)"User:Unknown");
        tokenManager.renewToken(unknownOwner, ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)this.error());
        this.time().sleep(86400000L);
        long expectedExpiryStamp = this.time().milliseconds() + this.renewTimeMsDefault();
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(86400000L);
        expectedExpiryStamp = this.time().milliseconds() + 3600000L;
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), 3600000L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(3600000L);
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), 691200000L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)maxLifeTime, (long)this.expiryTimeStamp());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(691200000L);
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)this.error());
    }

    @Test
    public void testExpireToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap("test".getBytes()), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)this.error());
        KafkaPrincipal unknownOwner = SecurityUtils.parseKafkaPrincipal((String)"User:Unknown");
        tokenManager.expireToken(unknownOwner, ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)this.error());
        this.time().sleep(86400000L);
        long expectedExpiryStamp = this.time().milliseconds() + 0x6DDD00L;
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), 0x6DDD00L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        this.time().sleep(3600000L);
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(tokenManager.getToken(tokenId).isEmpty());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        Assert.assertEquals((long)this.time().milliseconds(), (long)this.expiryTimeStamp());
    }

    @Test
    public void testRemoveTokenHmac() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        String encodedHmac = Base64.getEncoder().encodeToString(password);
        Assert.assertNull((Object)tokenManager.tokenCache().tokenIdForHmac(encodedHmac));
        Predef$.MODULE$.assert(tokenManager.getToken(tokenId).isEmpty());
    }

    @Test
    public void testDescribeToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        KafkaPrincipal owner1 = SecurityUtils.parseKafkaPrincipal((String)"User:owner1");
        KafkaPrincipal owner2 = SecurityUtils.parseKafkaPrincipal((String)"User:owner2");
        KafkaPrincipal owner3 = SecurityUtils.parseKafkaPrincipal((String)"User:owner3");
        KafkaPrincipal owner4 = SecurityUtils.parseKafkaPrincipal((String)"User:owner4");
        KafkaPrincipal renewer1 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer1");
        KafkaPrincipal renewer2 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer2");
        KafkaPrincipal renewer3 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer3");
        KafkaPrincipal renewer4 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer4");
        AclAuthorizer aclAuthorizer = new AclAuthorizer();
        aclAuthorizer.configure(config.originals());
        RequestChannel.Session hostSession = new RequestChannel.Session(owner1, InetAddress.getByName("192.168.1.1"));
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(owner1, (List)new .colon.colon((Object)renewer1, (List)new .colon.colon((Object)renewer2, (List)Nil$.MODULE$)), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(owner2, (List)new .colon.colon((Object)renewer3, (List)Nil$.MODULE$), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        String tokenId2 = this.createTokenResult().tokenId();
        tokenManager.createToken(owner3, (List)new .colon.colon((Object)renewer4, (List)Nil$.MODULE$), 0x6DDD00L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        String tokenId3 = this.createTokenResult().tokenId();
        tokenManager.createToken(owner4, (List)new .colon.colon((Object)owner1, (List)new .colon.colon((Object)renewer4, (List)Nil$.MODULE$)), 0x6DDD00L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        List list = tokenManager.getAllTokenInformation();
        if (list == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$((SeqOps)list) == 4);
        List<DelegationToken> tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)new .colon.colon((Object)SecurityUtils.parseKafkaPrincipal((String)"User:unknown"), (List)Nil$.MODULE$));
        if (tokens == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$(tokens) == 0);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)Nil$.MODULE$);
        if (tokens == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$(tokens) == 0);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)new .colon.colon((Object)owner1, (List)Nil$.MODULE$));
        if (tokens == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$(tokens) == 2);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, null);
        if (tokens == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$(tokens) == 2);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, SecurityUtils.parseKafkaPrincipal((String)"User:unknown"), null);
        if (tokens == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$(tokens) == 0);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)new .colon.colon((Object)owner1, (List)new .colon.colon((Object)renewer4, (List)Nil$.MODULE$)));
        if (tokens == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$(tokens) == 2);
        DelegationTokenManagerTest.createAcl$1(new AclBinding(new ResourcePattern(ResourceType.DELEGATION_TOKEN, tokenId3, PatternType.LITERAL), new AccessControlEntry(owner1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW)), aclAuthorizer);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)new .colon.colon((Object)owner1, (List)new .colon.colon((Object)renewer4, (List)Nil$.MODULE$)));
        if (tokens == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$(tokens) == 3);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, renewer4, (List<KafkaPrincipal>)new .colon.colon((Object)renewer4, (List)Nil$.MODULE$));
        if (tokens == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$(tokens) == 2);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, renewer2, (List<KafkaPrincipal>)new .colon.colon((Object)renewer2, (List)new .colon.colon((Object)renewer3, (List)Nil$.MODULE$)));
        if (tokens == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$(tokens) == 1);
        hostSession = new RequestChannel.Session(renewer2, InetAddress.getByName("192.168.1.1"));
        DelegationTokenManagerTest.createAcl$1(new AclBinding(new ResourcePattern(ResourceType.DELEGATION_TOKEN, tokenId2, PatternType.LITERAL), new AccessControlEntry(renewer2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW)), aclAuthorizer);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, renewer2, (List<KafkaPrincipal>)new .colon.colon((Object)renewer2, (List)new .colon.colon((Object)renewer3, (List)Nil$.MODULE$)));
        if (tokens == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$(tokens) == 2);
        aclAuthorizer.close();
    }

    private List<DelegationToken> getTokens(DelegationTokenManager tokenManager, AclAuthorizer aclAuthorizer, RequestChannel.Session hostSession, KafkaPrincipal requestPrincipal, List<KafkaPrincipal> requestedOwners) {
        if (requestedOwners != null && requestedOwners.isEmpty()) {
            return Nil$.MODULE$;
        }
        return tokenManager.getTokens((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenManagerTest.eligible$1(token, requestPrincipal, requestedOwners, hostSession, aclAuthorizer)));
    }

    @Test
    public void testPeriodicTokenExpiry() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(this.owner(), this.renewer(), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(this.owner(), this.renewer(), 0x6DDD00L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(this.owner(), this.renewer(), 0x6DDD00L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        List list = tokenManager.getAllTokenInformation();
        if (list == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$((SeqOps)list) == 4);
        this.time().sleep(0x6DDD00L);
        tokenManager.expireTokens();
        List list2 = tokenManager.getAllTokenInformation();
        if (list2 == null) {
            throw null;
        }
        Predef$.MODULE$.assert(SeqOps.size$((SeqOps)list2) == 2);
    }

    private void createTokenResultCallBack(CreateTokenResult ret) {
        this.createTokenResult_$eq(ret);
    }

    private void renewResponseCallback(Errors ret, long timeStamp) {
        this.error_$eq(ret);
        this.expiryTimeStamp_$eq(timeStamp);
    }

    private DelegationTokenManager createDelegationTokenManager(KafkaConfig config, DelegationTokenCache tokenCache, Time time, KafkaZkClient zkClient) {
        DelegationTokenManager tokenManager = new DelegationTokenManager(config, tokenCache, time, zkClient);
        Buffer<DelegationTokenManager> buffer = this.tokenManagers();
        if (buffer == null) {
            throw null;
        }
        buffer.addOne((Object)tokenManager);
        return tokenManager;
    }

    private static final void createAcl$1(AclBinding aclBinding, AclAuthorizer aclAuthorizer$1) {
        ((AclCreateResult)((CompletionStage)aclAuthorizer$1.createAcls(null, AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)aclBinding, (List)Nil$.MODULE$)).asJava()).get(0)).toCompletableFuture().get()).exception().ifPresent(e -> {
            throw e;
        });
    }

    private static final boolean authorizeToken$1(String tokenId, RequestChannel.Session hostSession$1, AclAuthorizer aclAuthorizer$2) {
        AuthorizerUtils$.anon.1 var6_3;
        AuthorizerUtils$.anon.1 v0 = var6_3 = new /* Unavailable Anonymous Inner Class!! */;
        var6_3 = null;
        AuthorizerUtils$.anon.1 requestContext = v0;
        Action action = new Action(AclOperation.DESCRIBE, new ResourcePattern(ResourceType.DELEGATION_TOKEN, tokenId, PatternType.LITERAL), 1, true, true);
        Object object = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)aclAuthorizer$2.authorize((AuthorizableRequestContext)requestContext, AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)action, (List)Nil$.MODULE$)).asJava())).asScala().head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean eligible$1(TokenInformation token, KafkaPrincipal requestPrincipal$1, List requestedOwners$1, RequestChannel.Session hostSession$1, AclAuthorizer aclAuthorizer$2) {
        Option filterToken_owners = Option$.MODULE$.apply((Object)requestedOwners$1);
        if (!filterToken_owners.isEmpty()) {
            block6: {
                List list = (List)filterToken_owners.get();
                if (list == null) {
                    throw null;
                }
                List filterToken_exists_these = list;
                while (!filterToken_exists_these.isEmpty()) {
                    KafkaPrincipal kafkaPrincipal = (KafkaPrincipal)filterToken_exists_these.head();
                    if (!token.ownerOrRenewer(kafkaPrincipal)) {
                        filterToken_exists_these = (List)filterToken_exists_these.tail();
                        continue;
                    }
                    break block6;
                }
                return false;
            }
            boolean bl = true;
            Object var6_6 = null;
            if (!bl) {
                return false;
            }
        }
        if (token.ownerOrRenewer(requestPrincipal$1)) {
            return true;
        }
        if (!DelegationTokenManagerTest.authorizeToken$1(token.tokenId(), hostSession$1, aclAuthorizer$2)) return false;
        return true;
    }

    public DelegationTokenManagerTest() {
        this.masterKey = "masterKey";
    }

    public static final /* synthetic */ Object $anonfun$getTokens$1$adapted(RequestChannel.Session hostSession$1, AclAuthorizer aclAuthorizer$2, String tokenId) {
        return BoxesRunTime.boxToBoolean((boolean)DelegationTokenManagerTest.authorizeToken$1(tokenId, hostSession$1, aclAuthorizer$2));
    }
}

