/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class ExpireDelegationTokenRequestData
implements ApiMessage {
    byte[] hmac;
    long expiryTimePeriodMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public ExpireDelegationTokenRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ExpireDelegationTokenRequestData() {
        this.hmac = Bytes.EMPTY;
        this.expiryTimePeriodMs = 0L;
    }

    @Override
    public short apiKey() {
        return 40;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
        if (length < 0) {
            throw new RuntimeException("non-nullable field hmac was serialized as null");
        }
        byte[] newBytes = new byte[length];
        _readable.readArray(newBytes);
        this.hmac = newBytes;
        this.expiryTimePeriodMs = _readable.readLong();
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.hmac.length + 1);
        } else {
            _writable.writeInt(this.hmac.length);
        }
        _writable.writeByteArray(this.hmac);
        _writable.writeLong(this.expiryTimePeriodMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(this.hmac.length);
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.hmac.length + 1));
        } else {
            _size.addBytes(4);
        }
        _size.addBytes(8);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExpireDelegationTokenRequestData)) {
            return false;
        }
        ExpireDelegationTokenRequestData other = (ExpireDelegationTokenRequestData)obj;
        if (!Arrays.equals(this.hmac, other.hmac)) {
            return false;
        }
        if (this.expiryTimePeriodMs != other.expiryTimePeriodMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + Arrays.hashCode(this.hmac);
        hashCode = 31 * hashCode + ((int)(this.expiryTimePeriodMs >> 32) ^ (int)this.expiryTimePeriodMs);
        return hashCode;
    }

    @Override
    public ExpireDelegationTokenRequestData duplicate() {
        ExpireDelegationTokenRequestData _duplicate = new ExpireDelegationTokenRequestData();
        _duplicate.hmac = MessageUtil.duplicate(this.hmac);
        _duplicate.expiryTimePeriodMs = this.expiryTimePeriodMs;
        return _duplicate;
    }

    public String toString() {
        return "ExpireDelegationTokenRequestData(hmac=" + Arrays.toString(this.hmac) + ", expiryTimePeriodMs=" + this.expiryTimePeriodMs + ")";
    }

    public byte[] hmac() {
        return this.hmac;
    }

    public long expiryTimePeriodMs() {
        return this.expiryTimePeriodMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ExpireDelegationTokenRequestData setHmac(byte[] v) {
        this.hmac = v;
        return this;
    }

    public ExpireDelegationTokenRequestData setExpiryTimePeriodMs(long v) {
        this.expiryTimePeriodMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("hmac", Type.BYTES, "The HMAC of the delegation token to be expired."), new Field("expiry_time_period_ms", Type.INT64, "The expiry time period in milliseconds."));
        SCHEMA_2 = new Schema(new Field("hmac", Type.COMPACT_BYTES, "The HMAC of the delegation token to be expired."), new Field("expiry_time_period_ms", Type.INT64, "The expiry time period in milliseconds."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }
}

