/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.kafka.clients.ApiVersion;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.junit.Assert;
import org.junit.Test;

public class NodeApiVersionsTest {
    @Test
    public void testUnsupportedVersionsToString() {
        NodeApiVersions versions = new NodeApiVersions(new ApiVersionsResponseData.ApiVersionsResponseKeyCollection());
        StringBuilder bld = new StringBuilder();
        String prefix = "(";
        for (ApiKeys apiKey : ApiKeys.enabledApis()) {
            bld.append(prefix).append(apiKey.name).append("(").append(apiKey.id).append("): UNSUPPORTED");
            prefix = ", ";
        }
        bld.append(")");
        Assert.assertEquals((Object)bld.toString(), (Object)versions.toString());
    }

    @Test
    public void testUnknownApiVersionsToString() {
        NodeApiVersions versions = NodeApiVersions.create((short)337, (short)0, (short)1);
        Assert.assertTrue((boolean)versions.toString().endsWith("UNKNOWN(337): 0 to 1)"));
    }

    @Test
    public void testVersionsToString() {
        ArrayList<ApiVersion> versionList = new ArrayList<ApiVersion>();
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (apiKey == ApiKeys.DELETE_TOPICS) {
                versionList.add(new ApiVersion(apiKey.id, 10000, 10001));
                continue;
            }
            versionList.add(new ApiVersion(apiKey));
        }
        NodeApiVersions versions = new NodeApiVersions(versionList);
        StringBuilder bld = new StringBuilder();
        String prefix = "(";
        for (ApiKeys apiKey : ApiKeys.values()) {
            bld.append(prefix);
            if (apiKey == ApiKeys.DELETE_TOPICS) {
                bld.append("DeleteTopics(20): 10000 to 10001 [unusable: node too new]");
            } else {
                bld.append(apiKey.name).append("(").append(apiKey.id).append("): ");
                if (apiKey.oldestVersion() == apiKey.latestVersion()) {
                    bld.append(apiKey.oldestVersion());
                } else {
                    bld.append(apiKey.oldestVersion()).append(" to ").append(apiKey.latestVersion());
                }
                bld.append(" [usable: ").append(apiKey.latestVersion()).append("]");
            }
            prefix = ", ";
        }
        bld.append(")");
        Assert.assertEquals((Object)bld.toString(), (Object)versions.toString());
    }

    @Test
    public void testLatestUsableVersion() {
        NodeApiVersions apiVersions = NodeApiVersions.create((short)ApiKeys.PRODUCE.id, (short)1, (short)3);
        Assert.assertEquals((long)3L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE));
        Assert.assertEquals((long)1L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)0, (short)1));
        Assert.assertEquals((long)1L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)1, (short)1));
        Assert.assertEquals((long)2L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)1, (short)2));
        Assert.assertEquals((long)3L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)1, (short)3));
        Assert.assertEquals((long)2L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)2, (short)2));
        Assert.assertEquals((long)3L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)2, (short)3));
        Assert.assertEquals((long)3L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)3, (short)3));
        Assert.assertEquals((long)3L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)3, (short)4));
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testLatestUsableVersionOutOfRangeLow() {
        NodeApiVersions apiVersions = NodeApiVersions.create((short)ApiKeys.PRODUCE.id, (short)1, (short)2);
        apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)3, (short)4);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testLatestUsableVersionOutOfRangeHigh() {
        NodeApiVersions apiVersions = NodeApiVersions.create((short)ApiKeys.PRODUCE.id, (short)2, (short)3);
        apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)0, (short)1);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testUsableVersionCalculationNoKnownVersions() {
        NodeApiVersions versions = new NodeApiVersions(new ApiVersionsResponseData.ApiVersionsResponseKeyCollection());
        versions.latestUsableVersion(ApiKeys.FETCH);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testLatestUsableVersionOutOfRange() {
        NodeApiVersions apiVersions = NodeApiVersions.create((short)ApiKeys.PRODUCE.id, (short)300, (short)300);
        apiVersions.latestUsableVersion(ApiKeys.PRODUCE);
    }

    @Test
    public void testUsableVersionLatestVersions() {
        LinkedList<ApiVersion> versionList = new LinkedList<ApiVersion>();
        Iterator iterator = ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE.data.apiKeys().iterator();
        while (iterator.hasNext()) {
            ApiVersionsResponseData.ApiVersionsResponseKey apiVersion = (ApiVersionsResponseData.ApiVersionsResponseKey)iterator.next();
            versionList.add(new ApiVersion(apiVersion));
        }
        versionList.add(new ApiVersion(100, 0, 1));
        NodeApiVersions versions = new NodeApiVersions(versionList);
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (apiKey.isEnabled) {
                Assert.assertEquals((long)apiKey.latestVersion(), (long)versions.latestUsableVersion(apiKey));
                continue;
            }
            Assert.assertNull((Object)versions.apiVersion(apiKey));
        }
    }

    @Test
    public void testConstructionFromApiVersionsResponse() {
        ApiVersionsResponse apiVersionsResponse = ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE;
        NodeApiVersions versions = new NodeApiVersions(apiVersionsResponse.data.apiKeys());
        Iterator iterator = apiVersionsResponse.data.apiKeys().iterator();
        while (iterator.hasNext()) {
            ApiVersionsResponseData.ApiVersionsResponseKey apiVersionKey = (ApiVersionsResponseData.ApiVersionsResponseKey)iterator.next();
            ApiVersion apiVersion = versions.apiVersion(ApiKeys.forId((int)apiVersionKey.apiKey()));
            Assert.assertEquals((long)apiVersionKey.apiKey(), (long)apiVersion.apiKey);
            Assert.assertEquals((long)apiVersionKey.minVersion(), (long)apiVersion.minVersion);
            Assert.assertEquals((long)apiVersionKey.maxVersion(), (long)apiVersion.maxVersion);
        }
    }
}

