/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Map;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.query.h2.twostep.GridReduceQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.util.typedef.C2;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.h2.util.IntArray;

public class ReducePartitionsSpecializer
implements C2<ClusterNode, Message, Message> {
    private final Map<ClusterNode, IntArray> partsMap;

    public ReducePartitionsSpecializer(Map<ClusterNode, IntArray> partsMap) {
        this.partsMap = partsMap;
    }

    public Message apply(ClusterNode node, Message msg) {
        if (msg instanceof GridH2QueryRequest) {
            GridH2QueryRequest rq = new GridH2QueryRequest((GridH2QueryRequest)msg);
            rq.queryPartitions(GridReduceQueryExecutor.toArray(this.partsMap.get(node)));
            return rq;
        }
        if (msg instanceof GridH2DmlRequest) {
            GridH2DmlRequest rq = new GridH2DmlRequest((GridH2DmlRequest)msg);
            rq.queryPartitions(GridReduceQueryExecutor.toArray(this.partsMap.get(node)));
            return rq;
        }
        return msg;
    }
}

