/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.jetbrains.annotations.Nullable;

public class PartitionReservation {
    private final List<GridReservable> reserved;
    private final String err;
    private final AtomicBoolean releaseGuard = new AtomicBoolean();

    public PartitionReservation(List<GridReservable> reserved) {
        this(reserved, null);
    }

    public PartitionReservation(@Nullable List<GridReservable> reserved, @Nullable String err) {
        this.reserved = reserved;
        this.err = err;
    }

    @Nullable
    public String error() {
        return this.err;
    }

    public boolean failed() {
        return this.err != null;
    }

    public void release() {
        if (!this.releaseGuard.compareAndSet(false, true)) {
            return;
        }
        if (this.reserved != null) {
            for (int i = 0; i < this.reserved.size(); ++i) {
                this.reserved.get(i).release();
            }
        }
    }
}

