/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueFloat;

public class FloatInlineIndexColumn
extends AbstractInlineIndexColumn {
    FloatInlineIndexColumn(Column col) {
        super(col, 8, (short)4);
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        if (this.type() != type) {
            return Integer.MIN_VALUE;
        }
        float val1 = Float.intBitsToFloat(PageUtils.getInt((long)pageAddr, (int)(off + 1)));
        float val2 = v.getFloat();
        return Integer.signum(Float.compare(val1, val2));
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getType());
        PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
        PageUtils.putInt((long)pageAddr, (int)(off + 1), (int)Float.floatToIntBits(val.getFloat()));
        return this.size() + 1;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        return ValueFloat.get((float)Float.intBitsToFloat(PageUtils.getInt((long)pageAddr, (int)(off + 1))));
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType() == this.type());
        return this.size() + 1;
    }
}

