/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

public class QueryDescriptor {
    private final String schemaName;
    private final String sql;
    private final boolean collocated;
    private final boolean distributedJoins;
    private final boolean enforceJoinOrder;
    private final boolean loc;
    private final boolean skipReducerOnUpdate;
    private final boolean batched;

    QueryDescriptor(String schemaName, String sql, boolean collocated, boolean distributedJoins, boolean enforceJoinOrder, boolean loc, boolean skipReducerOnUpdate, boolean batched) {
        this.schemaName = schemaName;
        this.sql = sql;
        this.collocated = collocated;
        this.distributedJoins = distributedJoins;
        this.enforceJoinOrder = enforceJoinOrder;
        this.loc = loc;
        this.skipReducerOnUpdate = skipReducerOnUpdate;
        this.batched = batched;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String sql() {
        return this.sql;
    }

    public boolean collocated() {
        return this.collocated;
    }

    public boolean distributedJoins() {
        return this.distributedJoins;
    }

    public boolean enforceJoinOrder() {
        return this.enforceJoinOrder;
    }

    public boolean local() {
        return this.loc;
    }

    public boolean skipReducerOnUpdate() {
        return this.skipReducerOnUpdate;
    }

    public boolean batched() {
        return this.batched;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryDescriptor that = (QueryDescriptor)o;
        if (this.collocated != that.collocated) {
            return false;
        }
        if (this.distributedJoins != that.distributedJoins) {
            return false;
        }
        if (this.enforceJoinOrder != that.enforceJoinOrder) {
            return false;
        }
        if (this.skipReducerOnUpdate != that.skipReducerOnUpdate) {
            return false;
        }
        if (this.batched != that.batched) {
            return false;
        }
        if (this.schemaName != null ? !this.schemaName.equals(that.schemaName) : that.schemaName != null) {
            return false;
        }
        return this.loc == that.loc && this.sql.equals(that.sql);
    }

    public int hashCode() {
        int res = this.schemaName != null ? this.schemaName.hashCode() : 0;
        res = 31 * res + this.sql.hashCode();
        res = 31 * res + (this.collocated ? 1 : 0);
        res += this.distributedJoins ? 2 : 0;
        res += this.enforceJoinOrder ? 4 : 0;
        res += this.loc ? 8 : 0;
        res += this.skipReducerOnUpdate ? 16 : 0;
        return res += this.batched ? 32 : 0;
    }
}

