/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.RunningQueryManager;

public class RegisteredQueryCursor<T>
extends QueryCursorImpl<T> {
    private final AtomicBoolean unregistered = new AtomicBoolean(false);
    private RunningQueryManager runningQryMgr;
    private Long qryId;
    private Exception failReason;

    public RegisteredQueryCursor(Iterable<T> iterExec, GridQueryCancel cancel, RunningQueryManager runningQryMgr, boolean lazy, Long qryId) {
        super(iterExec, cancel, true, lazy);
        assert (runningQryMgr != null);
        assert (qryId != null);
        this.runningQryMgr = runningQryMgr;
        this.qryId = qryId;
    }

    protected Iterator<T> iter() {
        try {
            if (this.lazy()) {
                return new RegisteredIterator(super.iter());
            }
            return super.iter();
        }
        catch (Exception e) {
            this.failReason = e;
            if (QueryUtils.wasCancelled((Throwable)this.failReason)) {
                this.unregisterQuery();
            }
            throw e;
        }
    }

    public void close() {
        super.close();
        this.unregisterQuery();
    }

    public void cancel() {
        if (this.failReason == null) {
            this.failReason = new QueryCancelledException();
        }
        this.close();
    }

    private void unregisterQuery() {
        if (this.unregistered.compareAndSet(false, true)) {
            this.runningQryMgr.unregister(this.qryId, (Throwable)this.failReason);
        }
    }

    private class RegisteredIterator
    implements Iterator<T> {
        final Iterator<T> delegateIt;

        private RegisteredIterator(Iterator<T> it) {
            this.delegateIt = it;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegateIt.hasNext();
            }
            catch (Exception e) {
                RegisteredQueryCursor.this.failReason = e;
                if (QueryUtils.wasCancelled((Throwable)RegisteredQueryCursor.this.failReason)) {
                    RegisteredQueryCursor.this.unregisterQuery();
                }
                throw e;
            }
        }

        @Override
        public T next() {
            try {
                return this.delegateIt.next();
            }
            catch (Exception e) {
                RegisteredQueryCursor.this.failReason = e;
                if (QueryUtils.wasCancelled((Throwable)RegisteredQueryCursor.this.failReason)) {
                    RegisteredQueryCursor.this.unregisterQuery();
                }
                throw e;
            }
        }
    }
}

