/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.util.Preconditions;

public class LoadModuleOperation
implements Operation {
    private final String moduleName;
    private final Map<String, String> properties;

    public LoadModuleOperation(String moduleName, Map<String, String> properties) {
        this.moduleName = (String)Preconditions.checkNotNull((Object)moduleName);
        this.properties = (Map)Preconditions.checkNotNull(properties);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("moduleName", this.moduleName);
        params.put("properties", this.properties);
        return OperationUtils.formatWithChildren("LOAD MODULE", params, Collections.emptyList(), Operation::asSummaryString);
    }
}

