/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.ModifyOperationVisitor;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.DataType;

@Internal
public final class ExternalModifyOperation
implements ModifyOperation {
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private final ObjectIdentifier tableIdentifier;
    private final QueryOperation child;
    private final ResolvedSchema resolvedSchema;
    @Nullable
    private final ChangelogMode changelogMode;
    private final DataType physicalDataType;

    public ExternalModifyOperation(ObjectIdentifier tableIdentifier, QueryOperation child, ResolvedSchema resolvedSchema, ChangelogMode changelogMode, DataType physicalDataType) {
        this.tableIdentifier = tableIdentifier;
        this.child = child;
        this.resolvedSchema = resolvedSchema;
        this.changelogMode = changelogMode;
        this.physicalDataType = physicalDataType;
    }

    public static int getUniqueId() {
        return uniqueId.incrementAndGet();
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    @Override
    public QueryOperation getChild() {
        return this.child;
    }

    public DataType getPhysicalDataType() {
        return this.physicalDataType;
    }

    public Optional<ChangelogMode> getChangelogMode() {
        return Optional.ofNullable(this.changelogMode);
    }

    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public <T> T accept(ModifyOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("identifier", this.tableIdentifier);
        args.put("changelogMode", this.changelogMode);
        args.put("type", this.physicalDataType);
        return OperationUtils.formatWithChildren("DataStreamOutput", args, Collections.singletonList(this.child), Operation::asSummaryString);
    }
}

