/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import org.apache.flink.annotation.Internal;

@Internal
public enum RocksDBProperty {
    NumImmutableMemTable("num-immutable-mem-table"),
    MemTableFlushPending("mem-table-flush-pending"),
    CompactionPending("compaction-pending"),
    BackgroundErrors("background-errors"),
    CurSizeActiveMemTable("cur-size-active-mem-table"),
    CurSizeAllMemTables("cur-size-all-mem-tables"),
    SizeAllMemTables("size-all-mem-tables"),
    NumEntriesActiveMemTable("num-entries-active-mem-table"),
    NumEntriesImmMemTables("num-entries-imm-mem-tables"),
    NumDeletesActiveMemTable("num-deletes-active-mem-table"),
    NumDeletesImmMemTables("num-deletes-imm-mem-tables"),
    EstimateNumKeys("estimate-num-keys"),
    EstimateTableReadersMem("estimate-table-readers-mem"),
    NumSnapshots("num-snapshots"),
    NumLiveVersions("num-live-versions"),
    EstimateLiveDataSize("estimate-live-data-size"),
    TotalSstFilesSize("total-sst-files-size"),
    LiveSstFilesSize("live-sst-files-size"),
    EstimatePendingCompactionBytes("estimate-pending-compaction-bytes"),
    NumRunningCompactions("num-running-compactions"),
    NumRunningFlushes("num-running-flushes"),
    ActualDelayedWriteRate("actual-delayed-write-rate"),
    IsWriteStopped("is-write-stopped"),
    BlockCacheCapacity("block-cache-capacity"),
    BlockCacheUsage("block-cache-usage"),
    BlockCachePinnedUsage("block-cache-pinned-usage");

    private static final String ROCKS_DB_PROPERTY_FORMAT = "rocksdb.%s";
    private static final String CONFIG_KEY_FORMAT = "state.backend.rocksdb.metrics.%s";
    private final String property;

    private RocksDBProperty(String property) {
        this.property = property;
    }

    public String getRocksDBProperty() {
        return String.format(ROCKS_DB_PROPERTY_FORMAT, this.property);
    }

    public String getConfigKey() {
        return String.format(CONFIG_KEY_FORMAT, this.property);
    }
}

