/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.Closeable;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.Internal;
import org.apache.flink.contrib.streaming.state.RocksDBNativeMetricOptions;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.View;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class RocksDBNativeMetricMonitor
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBNativeMetricMonitor.class);
    private final RocksDBNativeMetricOptions options;
    private final MetricGroup metricGroup;
    private final Object lock;
    static final String COLUMN_FAMILY_KEY = "column_family";
    @GuardedBy(value="lock")
    private RocksDB rocksDB;

    public RocksDBNativeMetricMonitor(@Nonnull RocksDBNativeMetricOptions options, @Nonnull MetricGroup metricGroup, @Nonnull RocksDB rocksDB) {
        this.options = options;
        this.metricGroup = metricGroup;
        this.rocksDB = rocksDB;
        this.lock = new Object();
    }

    void registerColumnFamily(String columnFamilyName, ColumnFamilyHandle handle) {
        boolean columnFamilyAsVariable = this.options.isColumnFamilyAsVariable();
        MetricGroup group = columnFamilyAsVariable ? this.metricGroup.addGroup(COLUMN_FAMILY_KEY, columnFamilyName) : this.metricGroup.addGroup(columnFamilyName);
        for (String property : this.options.getProperties()) {
            RocksDBNativeMetricView gauge = new RocksDBNativeMetricView(handle, property);
            group.gauge(property, (Gauge)gauge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperty(ColumnFamilyHandle handle, String property, RocksDBNativeMetricView metricView) {
        if (metricView.isClosed()) {
            return;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.rocksDB != null) {
                    long value = this.rocksDB.getLongProperty(handle, property);
                    metricView.setValue(value);
                }
            }
        }
        catch (RocksDBException e) {
            metricView.close();
            LOG.warn("Failed to read native metric {} from RocksDB.", (Object)property, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.rocksDB = null;
        }
    }

    class RocksDBNativeMetricView
    implements Gauge<BigInteger>,
    View {
        private final String property;
        private final ColumnFamilyHandle handle;
        private BigInteger bigInteger;
        private boolean closed;

        private RocksDBNativeMetricView(@Nonnull ColumnFamilyHandle handle, String property) {
            this.handle = handle;
            this.property = property;
            this.bigInteger = BigInteger.ZERO;
            this.closed = false;
        }

        public void setValue(long value) {
            if (value >= 0L) {
                this.bigInteger = BigInteger.valueOf(value);
            } else {
                int upper = (int)(value >>> 32);
                int lower = (int)value;
                this.bigInteger = BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
            }
        }

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public BigInteger getValue() {
            return this.bigInteger;
        }

        public void update() {
            RocksDBNativeMetricMonitor.this.setProperty(this.handle, this.property, this);
        }
    }
}

