/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.csv.CsvRowDeserializationSchema;
import org.apache.flink.formats.csv.CsvRowSerializationSchema;
import org.apache.flink.table.descriptors.CsvValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.DeserializationSchemaFactory;
import org.apache.flink.table.factories.SerializationSchemaFactory;
import org.apache.flink.table.factories.TableFormatFactoryBase;
import org.apache.flink.types.Row;

public final class CsvRowFormatFactory
extends TableFormatFactoryBase<Row>
implements SerializationSchemaFactory<Row>,
DeserializationSchemaFactory<Row> {
    public CsvRowFormatFactory() {
        super("csv", 1, true);
    }

    public List<String> supportedFormatProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("format.field-delimiter");
        properties.add("format.line-delimiter");
        properties.add("format.disable-quote-character");
        properties.add("format.quote-character");
        properties.add("format.allow-comments");
        properties.add("format.ignore-parse-errors");
        properties.add("format.array-element-delimiter");
        properties.add("format.escape-character");
        properties.add("format.null-literal");
        properties.add("format.schema");
        return properties;
    }

    public DeserializationSchema<Row> createDeserializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = CsvRowFormatFactory.getValidatedProperties(properties);
        CsvRowDeserializationSchema.Builder schemaBuilder = new CsvRowDeserializationSchema.Builder(CsvRowFormatFactory.createTypeInformation(descriptorProperties));
        descriptorProperties.getOptionalCharacter("format.field-delimiter").ifPresent(schemaBuilder::setFieldDelimiter);
        descriptorProperties.getOptionalCharacter("format.quote-character").ifPresent(schemaBuilder::setQuoteCharacter);
        descriptorProperties.getOptionalBoolean("format.allow-comments").ifPresent(schemaBuilder::setAllowComments);
        descriptorProperties.getOptionalBoolean("format.ignore-parse-errors").ifPresent(schemaBuilder::setIgnoreParseErrors);
        descriptorProperties.getOptionalString("format.array-element-delimiter").ifPresent(schemaBuilder::setArrayElementDelimiter);
        descriptorProperties.getOptionalCharacter("format.escape-character").ifPresent(schemaBuilder::setEscapeCharacter);
        descriptorProperties.getOptionalString("format.null-literal").ifPresent(schemaBuilder::setNullLiteral);
        return schemaBuilder.build();
    }

    public SerializationSchema<Row> createSerializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = CsvRowFormatFactory.getValidatedProperties(properties);
        CsvRowSerializationSchema.Builder schemaBuilder = new CsvRowSerializationSchema.Builder(CsvRowFormatFactory.createTypeInformation(descriptorProperties));
        descriptorProperties.getOptionalCharacter("format.field-delimiter").ifPresent(schemaBuilder::setFieldDelimiter);
        descriptorProperties.getOptionalString("format.line-delimiter").ifPresent(schemaBuilder::setLineDelimiter);
        if (descriptorProperties.getOptionalBoolean("format.disable-quote-character").orElse(false).booleanValue()) {
            schemaBuilder.disableQuoteCharacter();
        } else {
            descriptorProperties.getOptionalCharacter("format.quote-character").ifPresent(schemaBuilder::setQuoteCharacter);
        }
        descriptorProperties.getOptionalString("format.array-element-delimiter").ifPresent(schemaBuilder::setArrayElementDelimiter);
        descriptorProperties.getOptionalCharacter("format.escape-character").ifPresent(schemaBuilder::setEscapeCharacter);
        descriptorProperties.getOptionalString("format.null-literal").ifPresent(schemaBuilder::setNullLiteral);
        return schemaBuilder.build();
    }

    private static DescriptorProperties getValidatedProperties(Map<String, String> propertiesMap) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(propertiesMap);
        new CsvValidator().validate(descriptorProperties);
        return descriptorProperties;
    }

    private static TypeInformation<Row> createTypeInformation(DescriptorProperties descriptorProperties) {
        if (descriptorProperties.containsKey("format.schema")) {
            return (RowTypeInfo)descriptorProperties.getType("format.schema");
        }
        return CsvRowFormatFactory.deriveSchema((Map)descriptorProperties.asMap()).toRowType();
    }
}

