/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.csv.AbstractCsvInputFormat;
import org.apache.flink.formats.csv.CsvFormatFactory;
import org.apache.flink.formats.csv.CsvOptions;
import org.apache.flink.formats.csv.CsvRowSchemaConverter;
import org.apache.flink.formats.csv.CsvToRowDataConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.FormatSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.MappingIterator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.FileSystemFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.PartitionPathUtils;

public class CsvFileSystemFormatFactory
implements FileSystemFormatFactory {
    public static final String IDENTIFIER = "csv";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(CsvOptions.FIELD_DELIMITER);
        options.add(CsvOptions.DISABLE_QUOTE_CHARACTER);
        options.add(CsvOptions.QUOTE_CHARACTER);
        options.add(CsvOptions.ALLOW_COMMENTS);
        options.add(CsvOptions.IGNORE_PARSE_ERRORS);
        options.add(CsvOptions.ARRAY_ELEMENT_DELIMITER);
        options.add(CsvOptions.ESCAPE_CHARACTER);
        options.add(CsvOptions.NULL_LITERAL);
        return options;
    }

    public InputFormat<RowData, ?> createReader(FileSystemFormatFactory.ReaderContext context) {
        ReadableConfig options = context.getFormatOptions();
        CsvFormatFactory.validateFormatOptions(options);
        RowType formatRowType = context.getFormatRowType();
        String[] fieldNames = context.getSchema().getFieldNames();
        List projectFields = Arrays.stream(context.getProjectFields()).mapToObj(idx -> fieldNames[idx]).collect(Collectors.toList());
        List csvFields = Arrays.stream(fieldNames).filter(field -> !context.getPartitionKeys().contains(field)).collect(Collectors.toList());
        int[] csvSelectFieldToProjectFieldMapping = context.getFormatProjectFields().stream().mapToInt(projectFields::indexOf).toArray();
        int[] csvSelectFieldToCsvFieldMapping = context.getFormatProjectFields().stream().mapToInt(csvFields::indexOf).toArray();
        CsvSchema csvSchema = this.buildCsvSchema(formatRowType, options);
        boolean ignoreParseErrors = (Boolean)options.get(CsvOptions.IGNORE_PARSE_ERRORS);
        return new CsvInputFormat(context.getPaths(), context.getSchema().getFieldDataTypes(), context.getSchema().getFieldNames(), csvSchema, formatRowType, context.getProjectFields(), context.getPartitionKeys(), context.getDefaultPartName(), context.getPushedDownLimit(), csvSelectFieldToProjectFieldMapping, csvSelectFieldToCsvFieldMapping, ignoreParseErrors);
    }

    private CsvSchema buildCsvSchema(RowType rowType, ReadableConfig options) {
        CsvSchema csvSchema = CsvRowSchemaConverter.convert(rowType);
        CsvSchema.Builder csvBuilder = csvSchema.rebuild();
        options.getOptional(CsvOptions.FIELD_DELIMITER).map(s -> Character.valueOf(StringEscapeUtils.unescapeJava((String)s).charAt(0))).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setColumnSeparator(arg_0));
        options.getOptional(CsvOptions.QUOTE_CHARACTER).map(s -> Character.valueOf(s.charAt(0))).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setQuoteChar(arg_0));
        options.getOptional(CsvOptions.ALLOW_COMMENTS).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setAllowComments(arg_0));
        options.getOptional(CsvOptions.ARRAY_ELEMENT_DELIMITER).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setArrayElementSeparator(arg_0));
        options.getOptional(CsvOptions.ARRAY_ELEMENT_DELIMITER).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setArrayElementSeparator(arg_0));
        options.getOptional(CsvOptions.ESCAPE_CHARACTER).map(s -> Character.valueOf(s.charAt(0))).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setEscapeChar(arg_0));
        options.getOptional(CsvOptions.NULL_LITERAL).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setNullValue(arg_0));
        return csvBuilder.build();
    }

    public static class CsvInputFormat
    extends AbstractCsvInputFormat<RowData> {
        private static final long serialVersionUID = 1L;
        private final RowType formatRowType;
        private final DataType[] fieldTypes;
        private final String[] fieldNames;
        private final int[] selectFields;
        private final List<String> partitionKeys;
        private final String defaultPartValue;
        private final long limit;
        private final int[] csvSelectFieldToProjectFieldMapping;
        private final int[] csvSelectFieldToCsvFieldMapping;
        private final boolean ignoreParseErrors;
        private transient InputStreamReader inputStreamReader;
        private transient BufferedReader reader;
        private transient boolean end;
        private transient long emitted;
        private transient GenericRowData rowData;
        private transient CsvToRowDataConverters.CsvToRowDataConverter runtimeConverter;
        private transient MappingIterator<JsonNode> iterator;

        public CsvInputFormat(Path[] filePaths, DataType[] fieldTypes, String[] fieldNames, CsvSchema csvSchema, RowType formatRowType, int[] selectFields, List<String> partitionKeys, String defaultPartValue, long limit, int[] csvSelectFieldToProjectFieldMapping, int[] csvSelectFieldToCsvFieldMapping, boolean ignoreParseErrors) {
            super(filePaths, csvSchema);
            this.fieldTypes = fieldTypes;
            this.fieldNames = fieldNames;
            this.formatRowType = formatRowType;
            this.partitionKeys = partitionKeys;
            this.defaultPartValue = defaultPartValue;
            this.selectFields = selectFields;
            this.limit = limit;
            this.emitted = 0L;
            this.csvSelectFieldToProjectFieldMapping = csvSelectFieldToProjectFieldMapping;
            this.csvSelectFieldToCsvFieldMapping = csvSelectFieldToCsvFieldMapping;
            this.ignoreParseErrors = ignoreParseErrors;
        }

        @Override
        public void open(FileInputSplit split) throws IOException {
            super.open(split);
            this.end = false;
            this.inputStreamReader = new InputStreamReader(this.csvInputStream);
            this.reader = new BufferedReader(this.inputStreamReader);
            this.rowData = PartitionPathUtils.fillPartitionValueForRecord((String[])this.fieldNames, (DataType[])this.fieldTypes, (int[])this.selectFields, this.partitionKeys, (Path)this.currentSplit.getPath(), (String)this.defaultPartValue);
            this.iterator = new CsvMapper().readerFor(JsonNode.class).with((FormatSchema)this.csvSchema).readValues(this.csvInputStream);
            this.prepareRuntimeConverter();
        }

        private void prepareRuntimeConverter() {
            this.runtimeConverter = new CsvToRowDataConverters(this.ignoreParseErrors).createRowConverter(this.formatRowType, true);
        }

        public boolean reachedEnd() throws IOException {
            return this.emitted >= this.limit || this.end;
        }

        public RowData nextRecord(RowData reuse) throws IOException {
            GenericRowData csvRow = null;
            while (csvRow == null) {
                try {
                    JsonNode root = (JsonNode)this.iterator.nextValue();
                    csvRow = (GenericRowData)this.runtimeConverter.convert(root);
                }
                catch (NoSuchElementException e) {
                    this.end = true;
                    return null;
                }
                catch (Throwable t) {
                    if (this.ignoreParseErrors) continue;
                    throw new IOException("Failed to deserialize CSV row.", t);
                }
            }
            GenericRowData returnRecord = this.rowData;
            for (int i = 0; i < this.csvSelectFieldToCsvFieldMapping.length; ++i) {
                returnRecord.setField(this.csvSelectFieldToProjectFieldMapping[i], csvRow.getField(this.csvSelectFieldToCsvFieldMapping[i]));
            }
            ++this.emitted;
            return returnRecord;
        }

        public void close() throws IOException {
            super.close();
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.inputStreamReader != null) {
                this.inputStreamReader.close();
                this.inputStreamReader = null;
            }
        }
    }
}

