/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.observability.autoconfigure.brave;

import brave.CurrentSpanCustomizer;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.TracingCustomizer;
import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import brave.baggage.BaggagePropagationCustomizer;
import brave.baggage.CorrelationScopeConfig;
import brave.baggage.CorrelationScopeCustomizer;
import brave.baggage.CorrelationScopeDecorator;
import brave.context.slf4j.MDCScopeDecorator;
import brave.handler.SpanHandler;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.CurrentTraceContextCustomizer;
import brave.propagation.Propagation;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.sampler.Sampler;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.brave.bridge.BraveBaggageManager;
import io.micrometer.tracing.brave.bridge.BraveCurrentTraceContext;
import io.micrometer.tracing.brave.bridge.BravePropagator;
import io.micrometer.tracing.brave.bridge.BraveSpanCustomizer;
import io.micrometer.tracing.brave.bridge.BraveTracer;
import io.micrometer.tracing.brave.bridge.CompositeSpanHandler;
import io.micrometer.tracing.brave.bridge.W3CPropagation;
import io.micrometer.tracing.exporter.SpanExportingPredicate;
import io.micrometer.tracing.exporter.SpanFilter;
import io.micrometer.tracing.exporter.SpanReporter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.spring.boot.autoconfigure.DubboConfigurationProperties;
import org.apache.dubbo.spring.boot.observability.autoconfigure.DubboMicrometerTracingAutoConfiguration;
import org.apache.dubbo.spring.boot.observability.autoconfigure.annotation.ConditionalOnDubboTracingEnable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@ConditionalOnProperty(prefix="dubbo", name={"enabled"}, matchIfMissing=true)
@AutoConfiguration(before={DubboMicrometerTracingAutoConfiguration.class}, afterName={"org.springframework.boot.actuate.autoconfigure.tracing.BraveAutoConfiguration"})
@ConditionalOnClass(name={"io.micrometer.tracing.Tracer", "io.micrometer.tracing.brave.bridge.BraveTracer", "io.micrometer.tracing.brave.bridge.BraveBaggageManager", "brave.Tracing"})
@EnableConfigurationProperties(value={DubboConfigurationProperties.class})
@ConditionalOnDubboTracingEnable
public class BraveAutoConfiguration {
    private static final BraveBaggageManager BRAVE_BAGGAGE_MANAGER = new BraveBaggageManager();
    private static final String DEFAULT_APPLICATION_NAME = "application";
    private final ModuleModel moduleModel;

    public BraveAutoConfiguration(ModuleModel moduleModel) {
        this.moduleModel = moduleModel;
    }

    @Bean
    @ConditionalOnMissingBean
    @Order(value=-2147483648)
    CompositeSpanHandler compositeSpanHandler(ObjectProvider<SpanExportingPredicate> predicates, ObjectProvider<SpanReporter> reporters, ObjectProvider<SpanFilter> filters) {
        return new CompositeSpanHandler(predicates.orderedStream().collect(Collectors.toList()), reporters.orderedStream().collect(Collectors.toList()), filters.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    @ConditionalOnMissingBean
    public Tracing braveTracing(List<SpanHandler> spanHandlers, List<TracingCustomizer> tracingCustomizers, brave.propagation.CurrentTraceContext currentTraceContext, Propagation.Factory propagationFactory, Sampler sampler) {
        String applicationName = this.moduleModel.getApplicationModel().getApplicationConfigManager().getApplication().map(ApplicationConfig::getName).orElse(DEFAULT_APPLICATION_NAME);
        Tracing.Builder builder = Tracing.newBuilder().currentTraceContext(currentTraceContext).traceId128Bit(true).supportsJoin(false).propagationFactory(propagationFactory).sampler(sampler).localServiceName(applicationName);
        spanHandlers.forEach(arg_0 -> ((Tracing.Builder)builder).addSpanHandler(arg_0));
        for (TracingCustomizer tracingCustomizer : tracingCustomizers) {
            tracingCustomizer.customize(builder);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Tracer braveTracer(Tracing tracing) {
        return tracing.tracer();
    }

    @Bean
    @ConditionalOnMissingBean
    public brave.propagation.CurrentTraceContext braveCurrentTraceContext(List<CurrentTraceContext.ScopeDecorator> scopeDecorators, List<CurrentTraceContextCustomizer> currentTraceContextCustomizers) {
        ThreadLocalCurrentTraceContext.Builder builder = ThreadLocalCurrentTraceContext.newBuilder();
        scopeDecorators.forEach(arg_0 -> ((ThreadLocalCurrentTraceContext.Builder)builder).addScopeDecorator(arg_0));
        for (CurrentTraceContextCustomizer currentTraceContextCustomizer : currentTraceContextCustomizers) {
            currentTraceContextCustomizer.customize((CurrentTraceContext.Builder)builder);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Sampler braveSampler(DubboConfigurationProperties properties) {
        return Sampler.create((float)properties.getTracing().getSampling().getProbability());
    }

    @Bean
    @ConditionalOnMissingBean(value={io.micrometer.tracing.Tracer.class})
    BraveTracer braveTracerBridge(Tracer tracer, brave.propagation.CurrentTraceContext currentTraceContext) {
        return new BraveTracer(tracer, (CurrentTraceContext)new BraveCurrentTraceContext(currentTraceContext), (BaggageManager)BRAVE_BAGGAGE_MANAGER);
    }

    @Bean
    @ConditionalOnMissingBean
    BravePropagator bravePropagator(Tracing tracing) {
        return new BravePropagator(tracing);
    }

    @Bean
    @ConditionalOnMissingBean(value={SpanCustomizer.class})
    CurrentSpanCustomizer currentSpanCustomizer(Tracing tracing) {
        return CurrentSpanCustomizer.create((Tracing)tracing);
    }

    @Bean
    @ConditionalOnMissingBean(value={io.micrometer.tracing.SpanCustomizer.class})
    BraveSpanCustomizer braveSpanCustomizer(SpanCustomizer spanCustomizer) {
        return new BraveSpanCustomizer(spanCustomizer);
    }

    @ConditionalOnProperty(value={"dubbo.tracing.baggage.enabled"}, matchIfMissing=true)
    @Configuration(proxyBeanMethods=false)
    static class BraveBaggageConfiguration {
        private final DubboConfigurationProperties dubboConfigProperties;

        public BraveBaggageConfiguration(DubboConfigurationProperties dubboConfigProperties) {
            this.dubboConfigProperties = dubboConfigProperties;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="dubbo.tracing.propagation", value={"type"}, havingValue="B3")
        BaggagePropagation.FactoryBuilder b3PropagationFactoryBuilder(ObjectProvider<BaggagePropagationCustomizer> baggagePropagationCustomizers) {
            Propagation.Factory delegate = B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE_NO_PARENT).build();
            BaggagePropagation.FactoryBuilder builder = BaggagePropagation.newFactoryBuilder((Propagation.Factory)delegate);
            baggagePropagationCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="dubbo.tracing.propagation", value={"type"}, havingValue="W3C", matchIfMissing=true)
        BaggagePropagation.FactoryBuilder w3cPropagationFactoryBuilder(ObjectProvider<BaggagePropagationCustomizer> baggagePropagationCustomizers) {
            W3CPropagation delegate = new W3CPropagation((BaggageManager)BRAVE_BAGGAGE_MANAGER, Collections.emptyList());
            BaggagePropagation.FactoryBuilder builder = BaggagePropagation.newFactoryBuilder((Propagation.Factory)delegate);
            baggagePropagationCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder;
        }

        @Bean
        @ConditionalOnMissingBean
        @Order(value=0)
        BaggagePropagationCustomizer remoteFieldsBaggagePropagationCustomizer() {
            return builder -> {
                List remoteFields = this.dubboConfigProperties.getTracing().getBaggage().getRemoteFields();
                for (String fieldName : remoteFields) {
                    builder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.remote((BaggageField)BaggageField.create((String)fieldName)));
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean
        Propagation.Factory propagationFactory(BaggagePropagation.FactoryBuilder factoryBuilder) {
            return factoryBuilder.build();
        }

        @Bean
        @ConditionalOnMissingBean
        CorrelationScopeDecorator.Builder mdcCorrelationScopeDecoratorBuilder(ObjectProvider<CorrelationScopeCustomizer> correlationScopeCustomizers) {
            CorrelationScopeDecorator.Builder builder = MDCScopeDecorator.newBuilder();
            correlationScopeCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder;
        }

        @Bean
        @Order(value=0)
        @ConditionalOnProperty(prefix="dubbo.tracing.baggage.correlation", name={"enabled"}, matchIfMissing=true)
        CorrelationScopeCustomizer correlationFieldsCorrelationScopeCustomizer() {
            return builder -> {
                List correlationFields = this.dubboConfigProperties.getTracing().getBaggage().getCorrelation().getFields();
                for (String field : correlationFields) {
                    builder.add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.newBuilder((BaggageField)BaggageField.create((String)field)).flushOnUpdate().build());
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean(value={CurrentTraceContext.ScopeDecorator.class})
        CurrentTraceContext.ScopeDecorator correlationScopeDecorator(CorrelationScopeDecorator.Builder builder) {
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"dubbo.tracing.baggage.enabled"}, havingValue="false")
    static class BraveNoBaggageConfiguration {
        BraveNoBaggageConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        Propagation.Factory propagationFactory(DubboConfigurationProperties tracing) {
            String type;
            switch (type = tracing.getTracing().getPropagation().getType()) {
                case "B3": {
                    return B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE_NO_PARENT).build();
                }
                case "W3C": {
                    return new W3CPropagation();
                }
            }
            throw new IllegalArgumentException("UnSupport propagation type");
        }
    }
}

