/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.Connection;
import org.apache.dubbo.remoting.api.ConnectionManager;

public class MultiplexProtocolConnectionManager
implements ConnectionManager {
    private final ConcurrentMap<String, ConnectionManager> protocols = new ConcurrentHashMap<String, ConnectionManager>();

    @Override
    public Connection connect(URL url) throws RemotingException {
        ConnectionManager manager = this.protocols.computeIfAbsent(url.getProtocol(), this::createSingleProtocolConnectionManager);
        return manager.connect(url);
    }

    @Override
    public void forEachConnection(Consumer<Connection> connectionConsumer) {
        this.protocols.values().forEach(p -> p.forEachConnection(connectionConsumer));
    }

    private ConnectionManager createSingleProtocolConnectionManager(String protocol) {
        return (ConnectionManager)ExtensionLoader.getExtensionLoader(ConnectionManager.class).getExtension("single");
    }
}

