/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.AbstractServiceDiscoveryFactory;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.nacos.NacosServiceDiscovery;

public class NacosServiceDiscoveryFactory
extends AbstractServiceDiscoveryFactory {
    protected String createRegistryCacheKey(URL url) {
        String namespace = url.getParameter("namespace");
        url = URL.valueOf((String)url.toServiceStringWithoutResolving());
        if (StringUtils.isNotEmpty((String)namespace)) {
            url = url.addParameter("namespace", namespace);
        }
        return url.toFullString();
    }

    protected ServiceDiscovery createDiscovery(URL registryURL) {
        return new NacosServiceDiscovery(this.applicationModel, registryURL);
    }
}

