/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.event;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.exception.MetricsNeverHappenException;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.TypeWrapper;
import org.apache.dubbo.metrics.registry.collector.RegistryMetricsCollector;
import org.apache.dubbo.metrics.registry.event.type.ApplicationType;
import org.apache.dubbo.metrics.registry.event.type.ServiceType;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class RegistryEvent
extends TimeCounterEvent {
    private final RegistryMetricsCollector collector;
    private final Map<String, Object> attachment = new HashMap<String, Object>(8);

    public RegistryEvent(ApplicationModel applicationModel, TypeWrapper typeWrapper) {
        super(applicationModel);
        this.typeWrapper = typeWrapper;
        ScopeBeanFactory beanFactory = this.getSource().getBeanFactory();
        if (beanFactory.isDestroyed()) {
            this.collector = null;
        } else {
            this.collector = (RegistryMetricsCollector)beanFactory.getBean(RegistryMetricsCollector.class);
            super.setAvailable(this.collector != null && this.collector.isCollectEnabled());
        }
    }

    public ApplicationModel getSource() {
        return this.source;
    }

    public RegistryMetricsCollector getCollector() {
        return this.collector;
    }

    public <T> T getAttachmentValue(String key) {
        if (!this.attachment.containsKey(key)) {
            throw new MetricsNeverHappenException("Attachment key [" + key + "] not found");
        }
        return (T)this.attachment.get(key);
    }

    public void putAttachment(String key, Object value) {
        this.attachment.put(key, value);
    }

    public void setLastNum(ServiceType type) {
        this.getCollector().setNum(type, this.getSource().getApplicationName(), (Map)this.getAttachmentValue("lastNumMap"));
    }

    public void addApplicationRT(String opType) {
        this.getCollector().addApplicationRT(this.getSource().getApplicationName(), opType, this.getTimePair().calc());
    }

    public void setNum(ApplicationType type, String attachmentKey) {
        this.getCollector().setNum(type, this.getSource().getApplicationName(), (Integer)this.getAttachmentValue(attachmentKey));
    }

    public void incrementServiceKey(ServiceType type, String attServiceKey, String attSize) {
        this.incrementServiceKey(type, attServiceKey, (Integer)this.getAttachmentValue(attSize));
    }

    public void incrementServiceKey(ServiceType type, String attServiceKey, int size) {
        this.getCollector().incrementServiceKey(this.getSource().getApplicationName(), (String)this.getAttachmentValue(attServiceKey), type, size);
    }

    public void addServiceKeyRT(String attServiceKey, String attSize) {
        this.getCollector().addServiceKeyRT(this.getSource().getApplicationName(), (String)this.getAttachmentValue(attServiceKey), attSize, this.getTimePair().calc());
    }

    public void increment(ApplicationType type) {
        this.getCollector().increment(this.getSource().getApplicationName(), type);
    }

    public static RegistryEvent toRegisterEvent(ApplicationModel applicationModel) {
        return new RegistryEvent(applicationModel, new TypeWrapper(MetricsLevel.APP, (Object)ApplicationType.R_TOTAL, (Object)ApplicationType.R_SUCCEED, (Object)ApplicationType.R_FAILED));
    }

    public static RegistryEvent toSubscribeEvent(ApplicationModel applicationModel) {
        return new RegistryEvent(applicationModel, new TypeWrapper(MetricsLevel.APP, (Object)ApplicationType.S_TOTAL, (Object)ApplicationType.S_SUCCEED, (Object)ApplicationType.S_FAILED));
    }

    public static RegistryEvent toNotifyEvent(ApplicationModel applicationModel) {
        return new RegistryEvent(applicationModel, new TypeWrapper(MetricsLevel.APP, (Object)ApplicationType.N_TOTAL, (Object)ServiceType.N_LAST_NUM, null)){

            public void customAfterPost(Object postResult) {
                super.putAttachment("lastNumMap", postResult);
            }
        };
    }

    public static RegistryEvent toRsEvent(ApplicationModel applicationModel, String serviceKey, int size) {
        RegistryEvent ddEvent = new RegistryEvent(applicationModel, new TypeWrapper(MetricsLevel.SERVICE, (Object)ServiceType.R_SERVICE_TOTAL, (Object)ServiceType.R_SERVICE_SUCCEED, (Object)ServiceType.R_SERVICE_FAILED));
        ddEvent.putAttachment("serviceKey", serviceKey);
        ddEvent.putAttachment("size", size);
        return ddEvent;
    }

    public static RegistryEvent toSsEvent(ApplicationModel applicationModel, String serviceKey) {
        RegistryEvent ddEvent = new RegistryEvent(applicationModel, new TypeWrapper(MetricsLevel.SERVICE, (Object)ServiceType.S_SERVICE_TOTAL, (Object)ServiceType.S_SERVICE_SUCCEED, (Object)ServiceType.S_SERVICE_FAILED));
        ddEvent.putAttachment("serviceKey", serviceKey);
        return ddEvent;
    }

    public static RegistryEvent refreshDirectoryEvent(ApplicationModel applicationModel, Map<ServiceType, Map<String, Integer>> summaryMap) {
        RegistryEvent registryEvent = new RegistryEvent(applicationModel, new TypeWrapper(MetricsLevel.APP, (Object)ServiceType.D_VALID, null, null));
        registryEvent.putAttachment("dirNum", summaryMap);
        return registryEvent;
    }
}

