/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.sample;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.Function;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampleConfigurer;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampler;
import org.apache.dubbo.metrics.model.Metric;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.MetricSample;

public abstract class SimpleMetricsCountSampler<S, K, M extends Metric>
implements MetricsCountSampler<S, K, M> {
    private final ConcurrentMap<M, AtomicLong> EMPTY_COUNT = new ConcurrentHashMap<M, AtomicLong>();
    private final Map<K, ConcurrentMap<M, AtomicLong>> metricCounter = new ConcurrentHashMap<K, ConcurrentMap<M, AtomicLong>>();
    private final ConcurrentMap<M, AtomicLongArray> rtSample = new ConcurrentHashMap<M, AtomicLongArray>();
    private final ConcurrentMap<M, LongAccumulator> minRT = new ConcurrentHashMap<M, LongAccumulator>();
    private final ConcurrentMap<M, LongAccumulator> maxRT = new ConcurrentHashMap<M, LongAccumulator>();
    private final ConcurrentMap<K, ConcurrentMap<M, AtomicLongArray>> rtGroupSample = new ConcurrentHashMap<K, ConcurrentMap<M, AtomicLongArray>>();
    private final ConcurrentMap<K, ConcurrentMap<M, LongAccumulator>> groupMinRT = new ConcurrentHashMap<K, ConcurrentMap<M, LongAccumulator>>();
    private final ConcurrentMap<K, ConcurrentMap<M, LongAccumulator>> groupMaxRT = new ConcurrentHashMap<K, ConcurrentMap<M, LongAccumulator>>();

    @Override
    public void inc(S source, K metricName) {
        this.doExecute(source, metricName, counter -> {
            counter.incrementAndGet();
            return false;
        });
    }

    @Override
    public void dec(S source, K metricName) {
        this.doExecute(source, metricName, counter -> {
            counter.decrementAndGet();
            return false;
        });
    }

    @Override
    public void incOnEvent(S source, K metricName) {
        this.doExecute(source, metricName, counter -> {
            counter.incrementAndGet();
            return true;
        });
    }

    @Override
    public void decOnEvent(S source, K metricName) {
        this.doExecute(source, metricName, counter -> {
            counter.decrementAndGet();
            return true;
        });
    }

    @Override
    public void addRT(S source, Long rt) {
        MetricsCountSampleConfigurer sampleConfigure = new MetricsCountSampleConfigurer();
        sampleConfigure.setSource(source);
        this.rtConfigure(sampleConfigure);
        Object metric = sampleConfigure.getMetric();
        AtomicLongArray rtCalculator = (AtomicLongArray)ConcurrentHashMapUtils.computeIfAbsent(this.rtSample, metric, k -> new AtomicLongArray(4));
        rtCalculator.set(0, rt);
        rtCalculator.addAndGet(1, rt);
        rtCalculator.incrementAndGet(2);
        LongAccumulator min = (LongAccumulator)ConcurrentHashMapUtils.computeIfAbsent(this.minRT, metric, k -> new LongAccumulator(Long::min, Long.MAX_VALUE));
        min.accumulate(rt);
        LongAccumulator max = (LongAccumulator)ConcurrentHashMapUtils.computeIfAbsent(this.maxRT, metric, k -> new LongAccumulator(Long::max, Long.MIN_VALUE));
        max.accumulate(rt);
        sampleConfigure.setRt(rt);
        sampleConfigure.getFireEventHandler().accept(sampleConfigure);
    }

    @Override
    public void addRT(S source, K metricName, Long rt) {
        Serializable calculator;
        MetricsCountSampleConfigurer sampleConfigure = new MetricsCountSampleConfigurer();
        sampleConfigure.setSource(source);
        sampleConfigure.setMetricsName(metricName);
        this.rtConfigure(sampleConfigure);
        Object metric = sampleConfigure.getMetric();
        ConcurrentMap nameToCalculator = (ConcurrentMap)this.rtGroupSample.get(metricName);
        if (nameToCalculator == null) {
            calculator = new ConcurrentHashMap();
            ((ConcurrentHashMap)calculator).put(metric, new AtomicLongArray(4));
            this.rtGroupSample.put(metricName, (ConcurrentMap<M, AtomicLongArray>)((Object)calculator));
            nameToCalculator = (ConcurrentMap)this.rtGroupSample.get(metricName);
        }
        calculator = (AtomicLongArray)nameToCalculator.get(metric);
        ((AtomicLongArray)calculator).set(0, rt);
        ((AtomicLongArray)calculator).addAndGet(1, rt);
        ((AtomicLongArray)calculator).incrementAndGet(2);
        ConcurrentMap minRT = (ConcurrentMap)ConcurrentHashMapUtils.computeIfAbsent(this.groupMinRT, metricName, k -> new ConcurrentHashMap());
        LongAccumulator min = (LongAccumulator)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)minRT, metric, k -> new LongAccumulator(Long::min, Long.MAX_VALUE));
        min.accumulate(rt);
        ConcurrentMap maxRT = (ConcurrentMap)ConcurrentHashMapUtils.computeIfAbsent(this.groupMaxRT, metricName, k -> new ConcurrentHashMap());
        LongAccumulator max = (LongAccumulator)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)maxRT, metric, k -> new LongAccumulator(Long::max, Long.MIN_VALUE));
        max.accumulate(rt);
        sampleConfigure.setRt(rt);
        sampleConfigure.getFireEventHandler().accept(sampleConfigure);
    }

    @Override
    public Optional<ConcurrentMap<M, AtomicLong>> getCount(K metricName) {
        return Optional.ofNullable(this.metricCounter.get(metricName) == null ? this.EMPTY_COUNT : this.metricCounter.get(metricName));
    }

    @Override
    public <R extends MetricSample> List<R> collectRT(MetricsCountSampler.MetricSampleFactory<M, R> factory) {
        return this.collect(factory, this.rtSample, this.minRT, this.maxRT);
    }

    @Override
    public <R extends MetricSample> List<R> collectRT(MetricsCountSampler.MetricSampleFactory<M, R> factory, K metricName) {
        return this.collect(factory, (ConcurrentMap)this.rtGroupSample.get(metricName), (ConcurrentMap)this.groupMinRT.get(metricName), (ConcurrentMap)this.groupMaxRT.get(metricName));
    }

    private <R extends MetricSample> List<R> collect(MetricsCountSampler.MetricSampleFactory<M, R> factory, ConcurrentMap<M, AtomicLongArray> rtSample, ConcurrentMap<M, LongAccumulator> min, ConcurrentMap<M, LongAccumulator> max) {
        ArrayList result = new ArrayList();
        rtSample.forEach((k, v) -> {
            result.add(factory.newInstance(MetricsKey.METRIC_RT_LAST, k, v, value -> value.get(0)));
            result.add(factory.newInstance(MetricsKey.METRIC_RT_SUM, k, v, value -> value.get(1)));
            result.add(factory.newInstance(MetricsKey.METRIC_RT_AVG, k, v, value -> Math.floorDiv(value.get(1), value.get(2))));
        });
        min.forEach((k, v) -> result.add(factory.newInstance(MetricsKey.METRIC_RT_MIN, k, v, LongAccumulator::get)));
        max.forEach((k, v) -> result.add(factory.newInstance(MetricsKey.METRIC_RT_MAX, k, v, LongAccumulator::get)));
        return result;
    }

    protected void rtConfigure(MetricsCountSampleConfigurer<S, K, M> configure) {
    }

    protected abstract void countConfigure(MetricsCountSampleConfigurer<S, K, M> var1);

    private void doExecute(S source, K metricsName, Function<AtomicLong, Boolean> counter) {
        Boolean isEvent;
        MetricsCountSampleConfigurer sampleConfigure = new MetricsCountSampleConfigurer();
        sampleConfigure.setSource(source);
        sampleConfigure.setMetricsName(metricsName);
        this.countConfigure(sampleConfigure);
        Map metricAtomic = this.metricCounter.get(metricsName);
        if (metricAtomic == null) {
            metricAtomic = this.metricCounter.computeIfAbsent(metricsName, k -> new ConcurrentHashMap());
        }
        Assert.notNull(sampleConfigure.getMetric(), (String)"metrics is null");
        AtomicLong atomicCounter = (AtomicLong)metricAtomic.get(sampleConfigure.getMetric());
        if (atomicCounter == null) {
            atomicCounter = metricAtomic.computeIfAbsent(sampleConfigure.getMetric(), k -> new AtomicLong());
        }
        if ((isEvent = counter.apply(atomicCounter)).booleanValue()) {
            sampleConfigure.getFireEventHandler().accept(sampleConfigure);
        }
    }
}

