/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.event;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.metrics.event.MetricsDispatcher;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetricsEventBus {
    public static void publish(MetricsEvent event) {
        if (event.getSource() == null) {
            return;
        }
        ApplicationModel applicationModel = event.getSource();
        if (applicationModel.isDestroyed()) {
            return;
        }
        ScopeBeanFactory beanFactory = applicationModel.getBeanFactory();
        if (beanFactory.isDestroyed()) {
            return;
        }
        MetricsDispatcher dispatcher = (MetricsDispatcher)beanFactory.getBean(MetricsDispatcher.class);
        Optional.ofNullable(dispatcher).ifPresent(d -> d.publishEvent(event));
    }

    public static <T> T post(MetricsEvent event, Supplier<T> targetSupplier) {
        return MetricsEventBus.post(event, targetSupplier, null);
    }

    public static <T> T post(MetricsEvent event, Supplier<T> targetSupplier, Function<T, Boolean> trFunction) {
        T result;
        if (event.getSource() == null) {
            return targetSupplier.get();
        }
        ApplicationModel applicationModel = event.getSource();
        if (applicationModel.isDestroyed()) {
            return targetSupplier.get();
        }
        ScopeBeanFactory beanFactory = applicationModel.getBeanFactory();
        if (beanFactory.isDestroyed()) {
            return targetSupplier.get();
        }
        MetricsDispatcher dispatcher = (MetricsDispatcher)beanFactory.getBean(MetricsDispatcher.class);
        if (dispatcher == null) {
            return targetSupplier.get();
        }
        dispatcher.publishEvent(event);
        if (trFunction == null) {
            try {
                result = targetSupplier.get();
            }
            catch (Throwable e) {
                dispatcher.publishErrorEvent(event);
                throw e;
            }
            event.customAfterPost(result);
            dispatcher.publishFinishEvent(event);
        } else {
            result = targetSupplier.get();
            if (trFunction.apply(result).booleanValue()) {
                event.customAfterPost(result);
                dispatcher.publishFinishEvent(event);
            } else {
                dispatcher.publishErrorEvent(event);
            }
        }
        return result;
    }
}

