/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.spring.boot.autoconfigure;

import java.util.Map;
import javax.servlet.Servlet;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.spring.SpringComponentScanServer;
import org.apache.cxf.jaxrs.spring.SpringJaxrsClassesScanServer;
import org.apache.cxf.spring.boot.autoconfigure.CxfProperties;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={SpringBus.class, CXFServlet.class})
@EnableConfigurationProperties(value={CxfProperties.class})
@AutoConfigureAfter(name={"org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration", "org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration"})
public class CxfAutoConfiguration {
    @Autowired
    private CxfProperties properties;

    @Bean
    @ConditionalOnMissingBean(name={"cxfServletRegistration"})
    public ServletRegistrationBean cxfServletRegistration() {
        String path = this.properties.getPath();
        String urlMapping = path.endsWith("/") ? path + "*" : path + "/*";
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new CXFServlet(), new String[]{urlMapping});
        CxfProperties.Servlet servletProperties = this.properties.getServlet();
        registration.setLoadOnStartup(servletProperties.getLoadOnStartup());
        for (Map.Entry<String, String> entry : servletProperties.getInit().entrySet()) {
            registration.addInitParameter(entry.getKey(), entry.getValue());
        }
        return registration;
    }

    @Configuration
    @ConditionalOnClass(value={JAXRSServerFactoryBean.class})
    @ConditionalOnExpression(value="'${cxf.jaxrs.classes-scan}'=='true' && '${cxf.jaxrs.component-scan}'!='true'")
    @ConditionalOnMissingBean(value={Server.class})
    @Import(value={SpringJaxrsClassesScanServer.class})
    protected static class JaxRsClassesConfiguration {
        protected JaxRsClassesConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={JAXRSServerFactoryBean.class})
    @ConditionalOnExpression(value="'${cxf.jaxrs.component-scan}'=='true' && '${cxf.jaxrs.classes-scan}'!='true'")
    @ConditionalOnMissingBean(value={Server.class})
    @Import(value={SpringComponentScanServer.class})
    protected static class JaxRsComponentConfiguration {
        protected JaxRsComponentConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={SpringBus.class})
    @ImportResource(value={"classpath:META-INF/cxf/cxf.xml"})
    protected static class SpringBusConfiguration {
        protected SpringBusConfiguration() {
        }
    }
}

