/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.internal.Closure;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.InterpreterBase;
import org.apache.commons.jexl3.internal.Operators;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.internal.TemplateEngine;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.parser.ASTAddNode;
import org.apache.commons.jexl3.parser.ASTAndNode;
import org.apache.commons.jexl3.parser.ASTAnnotatedStatement;
import org.apache.commons.jexl3.parser.ASTAnnotation;
import org.apache.commons.jexl3.parser.ASTArguments;
import org.apache.commons.jexl3.parser.ASTArrayAccess;
import org.apache.commons.jexl3.parser.ASTArrayLiteral;
import org.apache.commons.jexl3.parser.ASTAssignment;
import org.apache.commons.jexl3.parser.ASTBitwiseAndNode;
import org.apache.commons.jexl3.parser.ASTBitwiseComplNode;
import org.apache.commons.jexl3.parser.ASTBitwiseOrNode;
import org.apache.commons.jexl3.parser.ASTBitwiseXorNode;
import org.apache.commons.jexl3.parser.ASTBlock;
import org.apache.commons.jexl3.parser.ASTBreak;
import org.apache.commons.jexl3.parser.ASTConstructorNode;
import org.apache.commons.jexl3.parser.ASTContinue;
import org.apache.commons.jexl3.parser.ASTDivNode;
import org.apache.commons.jexl3.parser.ASTEQNode;
import org.apache.commons.jexl3.parser.ASTERNode;
import org.apache.commons.jexl3.parser.ASTEWNode;
import org.apache.commons.jexl3.parser.ASTEmptyFunction;
import org.apache.commons.jexl3.parser.ASTEmptyMethod;
import org.apache.commons.jexl3.parser.ASTExtendedLiteral;
import org.apache.commons.jexl3.parser.ASTFalseNode;
import org.apache.commons.jexl3.parser.ASTForeachStatement;
import org.apache.commons.jexl3.parser.ASTFunctionNode;
import org.apache.commons.jexl3.parser.ASTGENode;
import org.apache.commons.jexl3.parser.ASTGTNode;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTIdentifierAccess;
import org.apache.commons.jexl3.parser.ASTIfStatement;
import org.apache.commons.jexl3.parser.ASTJexlLambda;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.ASTJxltLiteral;
import org.apache.commons.jexl3.parser.ASTLENode;
import org.apache.commons.jexl3.parser.ASTLTNode;
import org.apache.commons.jexl3.parser.ASTMapEntry;
import org.apache.commons.jexl3.parser.ASTMapLiteral;
import org.apache.commons.jexl3.parser.ASTMethodNode;
import org.apache.commons.jexl3.parser.ASTModNode;
import org.apache.commons.jexl3.parser.ASTMulNode;
import org.apache.commons.jexl3.parser.ASTNENode;
import org.apache.commons.jexl3.parser.ASTNEWNode;
import org.apache.commons.jexl3.parser.ASTNRNode;
import org.apache.commons.jexl3.parser.ASTNSWNode;
import org.apache.commons.jexl3.parser.ASTNotNode;
import org.apache.commons.jexl3.parser.ASTNullLiteral;
import org.apache.commons.jexl3.parser.ASTNumberLiteral;
import org.apache.commons.jexl3.parser.ASTOrNode;
import org.apache.commons.jexl3.parser.ASTRangeNode;
import org.apache.commons.jexl3.parser.ASTReference;
import org.apache.commons.jexl3.parser.ASTReferenceExpression;
import org.apache.commons.jexl3.parser.ASTReturnStatement;
import org.apache.commons.jexl3.parser.ASTSWNode;
import org.apache.commons.jexl3.parser.ASTSetAddNode;
import org.apache.commons.jexl3.parser.ASTSetAndNode;
import org.apache.commons.jexl3.parser.ASTSetDivNode;
import org.apache.commons.jexl3.parser.ASTSetLiteral;
import org.apache.commons.jexl3.parser.ASTSetModNode;
import org.apache.commons.jexl3.parser.ASTSetMultNode;
import org.apache.commons.jexl3.parser.ASTSetOrNode;
import org.apache.commons.jexl3.parser.ASTSetSubNode;
import org.apache.commons.jexl3.parser.ASTSetXorNode;
import org.apache.commons.jexl3.parser.ASTSizeFunction;
import org.apache.commons.jexl3.parser.ASTSizeMethod;
import org.apache.commons.jexl3.parser.ASTStringLiteral;
import org.apache.commons.jexl3.parser.ASTSubNode;
import org.apache.commons.jexl3.parser.ASTTernaryNode;
import org.apache.commons.jexl3.parser.ASTTrueNode;
import org.apache.commons.jexl3.parser.ASTUnaryMinusNode;
import org.apache.commons.jexl3.parser.ASTVar;
import org.apache.commons.jexl3.parser.ASTWhileStatement;
import org.apache.commons.jexl3.parser.JexlNode;

public class Interpreter
extends InterpreterBase {
    protected final Operators operators;
    protected final boolean cache;
    protected final Scope.Frame frame;
    protected final JexlContext.NamespaceResolver ns;
    protected final Map<String, Object> functions;
    protected Map<String, Object> functors;

    protected Interpreter(Engine engine, JexlContext aContext, Scope.Frame eFrame) {
        super(engine, aContext);
        this.operators = new Operators(this);
        this.cache = this.jexl.cache != null;
        this.frame = eFrame;
        this.ns = this.context instanceof JexlContext.NamespaceResolver ? (JexlContext.NamespaceResolver)((Object)this.context) : Engine.EMPTY_NS;
        this.functions = this.jexl.functions;
        this.functors = null;
    }

    protected Interpreter(Interpreter ii, JexlArithmetic jexla) {
        super(ii, jexla);
        this.operators = ii.operators;
        this.cache = ii.cache;
        this.frame = ii.frame;
        this.ns = ii.ns;
        this.functions = ii.functions;
        this.functors = ii.functors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object interpret(JexlNode node) {
        JexlContext.ThreadLocal local = null;
        try {
            if (this.isCancelled()) {
                throw new JexlException.Cancel(node);
            }
            if (this.context instanceof JexlContext.ThreadLocal) {
                local = this.jexl.putThreadLocal((JexlContext.ThreadLocal)this.context);
            }
            Object object = node.jjtAccept(this, null);
            return object;
        }
        catch (JexlException.Return xreturn) {
            Object object = xreturn.getValue();
            return object;
        }
        catch (JexlException.Cancel xcancel) {
            this.cancelled |= Thread.interrupted();
            if (this.isCancellable()) {
                throw xcancel.clean();
            }
        }
        catch (JexlException xjexl) {
            if (!this.isSilent()) {
                throw xjexl.clean();
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)xjexl.getMessage(), xjexl.getCause());
            }
        }
        finally {
            Interpreter i$ = this;
            synchronized (i$) {
                if (this.functors != null) {
                    if (AUTOCLOSEABLE != null) {
                        for (Object functor : this.functors.values()) {
                            this.closeIfSupported(functor);
                        }
                    }
                    this.functors.clear();
                    this.functors = null;
                }
            }
            if (this.context instanceof JexlContext.ThreadLocal) {
                this.jexl.putThreadLocal(local);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object resolveNamespace(String prefix, JexlNode node) {
        Object[] args;
        JexlMethod ctor;
        Object namespace;
        Interpreter interpreter = this;
        synchronized (interpreter) {
            if (this.functors != null && (namespace = this.functors.get(prefix)) != null) {
                return namespace;
            }
        }
        namespace = this.ns.resolveNamespace(prefix);
        if (namespace == null) {
            namespace = this.functions.get(prefix);
            if (prefix != null && namespace == null) {
                throw new JexlException(node, "no such function namespace " + prefix, null);
            }
        }
        Object functor = null;
        if (namespace instanceof JexlContext.NamespaceFunctor) {
            functor = ((JexlContext.NamespaceFunctor)namespace).createFunctor(this.context);
        } else if (namespace instanceof Class && (ctor = this.uberspect.getConstructor(namespace, args = new Object[]{this.context})) != null) {
            try {
                functor = ctor.invoke(namespace, args);
            }
            catch (Exception xinst) {
                throw new JexlException(node, "unable to instantiate namespace " + prefix, (Throwable)xinst);
            }
        }
        if (functor != null) {
            Interpreter interpreter2 = this;
            synchronized (interpreter2) {
                if (this.functors == null) {
                    this.functors = new HashMap<String, Object>();
                }
                this.functors.put(prefix, functor);
            }
            return functor;
        }
        return namespace;
    }

    @Override
    protected Object visit(ASTAddNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.ADD, left, right);
            return result != JexlEngine.TRY_FAILED ? result : this.arithmetic.add(left, right);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "+ error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTSubNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.SUBTRACT, left, right);
            return result != JexlEngine.TRY_FAILED ? result : this.arithmetic.subtract(left, right);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "- error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTMulNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.MULTIPLY, left, right);
            return result != JexlEngine.TRY_FAILED ? result : this.arithmetic.multiply(left, right);
        }
        catch (ArithmeticException xrt) {
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, "* error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTDivNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.DIVIDE, left, right);
            return result != JexlEngine.TRY_FAILED ? result : this.arithmetic.divide(left, right);
        }
        catch (ArithmeticException xrt) {
            if (!this.arithmetic.isStrict()) {
                return 0.0;
            }
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, "/ error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTModNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.MOD, left, right);
            return result != JexlEngine.TRY_FAILED ? result : this.arithmetic.mod(left, right);
        }
        catch (ArithmeticException xrt) {
            if (!this.arithmetic.isStrict()) {
                return 0.0;
            }
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, "% error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTBitwiseAndNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.AND, left, right);
            return result != JexlEngine.TRY_FAILED ? result : this.arithmetic.and(left, right);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "& error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTBitwiseOrNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.OR, left, right);
            return result != JexlEngine.TRY_FAILED ? result : this.arithmetic.or(left, right);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "| error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTBitwiseXorNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.XOR, left, right);
            return result != JexlEngine.TRY_FAILED ? result : this.arithmetic.xor(left, right);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "^ error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTEQNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.EQ, left, right);
            return result != JexlEngine.TRY_FAILED ? result : (this.arithmetic.equals(left, right) ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "== error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTNENode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.EQ, left, right);
            return result != JexlEngine.TRY_FAILED ? (this.arithmetic.toBoolean(result) ? Boolean.FALSE : Boolean.TRUE) : (this.arithmetic.equals(left, right) ? Boolean.FALSE : Boolean.TRUE);
        }
        catch (ArithmeticException xrt) {
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, "!= error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTGENode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.GTE, left, right);
            return result != JexlEngine.TRY_FAILED ? result : (this.arithmetic.greaterThanOrEqual(left, right) ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, ">= error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTGTNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.GT, left, right);
            return result != JexlEngine.TRY_FAILED ? result : (this.arithmetic.greaterThan(left, right) ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "> error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTLENode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.LTE, left, right);
            return result != JexlEngine.TRY_FAILED ? result : (this.arithmetic.lessThanOrEqual(left, right) ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "<= error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTLTNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.LT, left, right);
            return result != JexlEngine.TRY_FAILED ? result : (this.arithmetic.lessThan(left, right) ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "< error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTSWNode node, Object data) {
        Object right;
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        return this.operators.startsWith(node, "^=", left, right = node.jjtGetChild(1).jjtAccept(this, data)) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected Object visit(ASTNSWNode node, Object data) {
        Object right;
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        return this.operators.startsWith(node, "^!", left, right = node.jjtGetChild(1).jjtAccept(this, data)) ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    protected Object visit(ASTEWNode node, Object data) {
        Object right;
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        return this.operators.endsWith(node, "$=", left, right = node.jjtGetChild(1).jjtAccept(this, data)) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected Object visit(ASTNEWNode node, Object data) {
        Object right;
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        return this.operators.endsWith(node, "$!", left, right = node.jjtGetChild(1).jjtAccept(this, data)) ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    protected Object visit(ASTERNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        return this.operators.contains(node, "=~", right, left) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected Object visit(ASTNRNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        return this.operators.contains(node, "!~", right, left) ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    protected Object visit(ASTRangeNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.createRange(left, right);
        }
        catch (ArithmeticException xrt) {
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, ".. error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTUnaryMinusNode node, Object data) {
        JexlNode valNode = node.jjtGetChild(0);
        Object val = valNode.jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.NEGATE, val);
            if (result != JexlEngine.TRY_FAILED) {
                return result;
            }
            Object number = this.arithmetic.negate(val);
            if (valNode instanceof ASTNumberLiteral && number instanceof Number) {
                number = this.arithmetic.narrowNumber((Number)number, ((ASTNumberLiteral)valNode).getLiteralClass());
            }
            return number;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(valNode, "- error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTBitwiseComplNode node, Object data) {
        Object arg = node.jjtGetChild(0).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.COMPLEMENT, arg);
            return result != JexlEngine.TRY_FAILED ? result : this.arithmetic.complement(arg);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "~ error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTNotNode node, Object data) {
        Object val = node.jjtGetChild(0).jjtAccept(this, data);
        try {
            Object result = this.operators.tryOverload(node, JexlOperator.NOT, val);
            return result != JexlEngine.TRY_FAILED ? result : this.arithmetic.not(val);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "! error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTIfStatement node, Object data) {
        int n = 0;
        try {
            Object result = null;
            Object expression = node.jjtGetChild(0).jjtAccept(this, null);
            if (this.arithmetic.toBoolean(expression)) {
                n = 1;
                result = node.jjtGetChild(n).jjtAccept(this, null);
            } else if (node.jjtGetNumChildren() == 3) {
                n = 2;
                result = node.jjtGetChild(n).jjtAccept(this, null);
            }
            return result;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node.jjtGetChild(n), "if error", (Throwable)xrt);
        }
    }

    @Override
    protected Object visit(ASTBlock node, Object data) {
        int numChildren = node.jjtGetNumChildren();
        Object result = null;
        for (int i = 0; i < numChildren; ++i) {
            if (this.isCancelled()) {
                throw new JexlException.Cancel(node);
            }
            result = node.jjtGetChild(i).jjtAccept(this, data);
        }
        return result;
    }

    @Override
    protected Object visit(ASTReturnStatement node, Object data) {
        Object val = node.jjtGetChild(0).jjtAccept(this, data);
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
        throw new JexlException.Return((JexlNode)node, null, val);
    }

    @Override
    protected Object visit(ASTContinue node, Object data) {
        throw new JexlException.Continue(node);
    }

    @Override
    protected Object visit(ASTBreak node, Object data) {
        throw new JexlException.Break(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object visit(ASTForeachStatement node, Object data) {
        Object forEach;
        Object result;
        block9: {
            result = null;
            ASTReference loopReference = (ASTReference)node.jjtGetChild(0);
            ASTIdentifier loopVariable = (ASTIdentifier)loopReference.jjtGetChild(0);
            int symbol = loopVariable.getSymbol();
            Object iterableValue = node.jjtGetChild(1).jjtAccept(this, data);
            if (iterableValue == null) return result;
            if (node.jjtGetNumChildren() < 3) return result;
            JexlNode statement = node.jjtGetChild(2);
            forEach = null;
            try {
                Iterator<?> itemsIterator;
                forEach = this.operators.tryOverload(node, JexlOperator.FOR_EACH, iterableValue);
                Iterator<?> iterator = itemsIterator = forEach instanceof Iterator ? (Iterator<?>)forEach : this.uberspect.getIterator(iterableValue);
                if (itemsIterator == null) break block9;
                while (itemsIterator.hasNext()) {
                    if (this.isCancelled()) {
                        throw new JexlException.Cancel(node);
                    }
                    Object value = itemsIterator.next();
                    if (symbol < 0) {
                        this.context.set(loopVariable.getName(), value);
                    } else {
                        this.frame.set(symbol, value);
                    }
                    try {
                        result = statement.jjtAccept(this, data);
                    }
                    catch (JexlException.Break stmtBreak) {
                        break;
                    }
                    catch (JexlException.Continue stmtContinue) {
                    }
                }
            }
            catch (Throwable throwable) {
                this.closeIfSupported(forEach);
                throw throwable;
            }
        }
        this.closeIfSupported(forEach);
        return result;
    }

    @Override
    protected Object visit(ASTWhileStatement node, Object data) {
        Object result = null;
        JexlNode expressionNode = node.jjtGetChild(0);
        while (this.arithmetic.toBoolean(expressionNode.jjtAccept(this, data))) {
            if (this.isCancelled()) {
                throw new JexlException.Cancel(node);
            }
            if (node.jjtGetNumChildren() <= 1) continue;
            try {
                result = node.jjtGetChild(1).jjtAccept(this, data);
            }
            catch (JexlException.Break stmtBreak) {
                break;
            }
            catch (JexlException.Continue stmtContinue) {
            }
        }
        return result;
    }

    @Override
    protected Object visit(ASTAndNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        try {
            boolean leftValue = this.arithmetic.toBoolean(left);
            if (!leftValue) {
                return Boolean.FALSE;
            }
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node.jjtGetChild(0), "boolean coercion error", (Throwable)xrt);
        }
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            boolean rightValue = this.arithmetic.toBoolean(right);
            if (!rightValue) {
                return Boolean.FALSE;
            }
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node.jjtGetChild(1), "boolean coercion error", (Throwable)xrt);
        }
        return Boolean.TRUE;
    }

    @Override
    protected Object visit(ASTOrNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        try {
            boolean leftValue = this.arithmetic.toBoolean(left);
            if (leftValue) {
                return Boolean.TRUE;
            }
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node.jjtGetChild(0), "boolean coercion error", (Throwable)xrt);
        }
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            boolean rightValue = this.arithmetic.toBoolean(right);
            if (rightValue) {
                return Boolean.TRUE;
            }
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node.jjtGetChild(1), "boolean coercion error", (Throwable)xrt);
        }
        return Boolean.FALSE;
    }

    @Override
    protected Object visit(ASTNullLiteral node, Object data) {
        return null;
    }

    @Override
    protected Object visit(ASTTrueNode node, Object data) {
        return Boolean.TRUE;
    }

    @Override
    protected Object visit(ASTFalseNode node, Object data) {
        return Boolean.FALSE;
    }

    @Override
    protected Object visit(ASTNumberLiteral node, Object data) {
        if (data != null && node.isInteger()) {
            return this.getAttribute(data, node.getLiteral(), node);
        }
        return node.getLiteral();
    }

    @Override
    protected Object visit(ASTStringLiteral node, Object data) {
        if (data != null) {
            return this.getAttribute(data, node.getLiteral(), node);
        }
        return node.getLiteral();
    }

    @Override
    protected Object visit(ASTArrayLiteral node, Object data) {
        int childCount = node.jjtGetNumChildren();
        JexlArithmetic.ArrayBuilder ab = this.arithmetic.arrayBuilder(childCount);
        boolean extended = false;
        for (int i = 0; i < childCount; ++i) {
            if (this.isCancelled()) {
                throw new JexlException.Cancel(node);
            }
            JexlNode child = node.jjtGetChild(i);
            if (child instanceof ASTExtendedLiteral) {
                extended = true;
                continue;
            }
            Object entry = node.jjtGetChild(i).jjtAccept(this, data);
            ab.add(entry);
        }
        return ab.create(extended);
    }

    @Override
    protected Object visit(ASTExtendedLiteral node, Object data) {
        return node;
    }

    @Override
    protected Object visit(ASTSetLiteral node, Object data) {
        int childCount = node.jjtGetNumChildren();
        JexlArithmetic.SetBuilder mb = this.arithmetic.setBuilder(childCount);
        for (int i = 0; i < childCount; ++i) {
            if (this.isCancelled()) {
                throw new JexlException.Cancel(node);
            }
            Object entry = node.jjtGetChild(i).jjtAccept(this, data);
            mb.add(entry);
        }
        return mb.create();
    }

    @Override
    protected Object visit(ASTMapLiteral node, Object data) {
        int childCount = node.jjtGetNumChildren();
        JexlArithmetic.MapBuilder mb = this.arithmetic.mapBuilder(childCount);
        for (int i = 0; i < childCount; ++i) {
            if (this.isCancelled()) {
                throw new JexlException.Cancel(node);
            }
            Object[] entry = (Object[])node.jjtGetChild(i).jjtAccept(this, data);
            mb.put(entry[0], entry[1]);
        }
        return mb.create();
    }

    @Override
    protected Object visit(ASTMapEntry node, Object data) {
        Object key = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return new Object[]{key, value};
    }

    @Override
    protected Object visit(ASTTernaryNode node, Object data) {
        Object condition = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 3) {
            if (condition != null && this.arithmetic.toBoolean(condition)) {
                return node.jjtGetChild(1).jjtAccept(this, data);
            }
            return node.jjtGetChild(2).jjtAccept(this, data);
        }
        if (condition != null && this.arithmetic.toBoolean(condition)) {
            return condition;
        }
        return node.jjtGetChild(1).jjtAccept(this, data);
    }

    @Override
    protected Object visit(ASTSizeFunction node, Object data) {
        try {
            Object val = node.jjtGetChild(0).jjtAccept(this, data);
            return this.operators.size(node, val);
        }
        catch (JexlException xany) {
            return 0;
        }
    }

    @Override
    protected Object visit(ASTSizeMethod node, Object data) {
        Object val = node.jjtGetChild(0).jjtAccept(this, data);
        return this.operators.size(node, val);
    }

    @Override
    protected Object visit(ASTEmptyFunction node, Object data) {
        try {
            Object value = node.jjtGetChild(0).jjtAccept(this, data);
            return this.operators.empty(node, value);
        }
        catch (JexlException xany) {
            return true;
        }
    }

    @Override
    protected Object visit(ASTEmptyMethod node, Object data) {
        Object val = node.jjtGetChild(0).jjtAccept(this, data);
        return this.operators.empty(node, val);
    }

    @Override
    protected Object visit(ASTJexlScript node, Object data) {
        if (node instanceof ASTJexlLambda && !((ASTJexlLambda)node).isTopLevel()) {
            return new Closure(this, (ASTJexlLambda)node);
        }
        int numChildren = node.jjtGetNumChildren();
        Object result = null;
        for (int i = 0; i < numChildren; ++i) {
            JexlNode child = node.jjtGetChild(i);
            result = child.jjtAccept(this, data);
            if (!this.isCancelled()) continue;
            throw new JexlException.Cancel(child);
        }
        return result;
    }

    @Override
    protected Object visit(ASTVar node, Object data) {
        return this.visit((ASTIdentifier)node, data);
    }

    @Override
    protected Object visit(ASTReferenceExpression node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    @Override
    protected Object visit(ASTIdentifier node, Object data) {
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
        String name = node.getName();
        if (data == null) {
            int symbol = node.getSymbol();
            if (symbol >= 0) {
                return this.frame.get(symbol);
            }
            Object value = this.context.get(name);
            if (!(value != null || node.jjtGetParent() instanceof ASTReference || this.context.has(name) || this.isTernaryProtected(node))) {
                return this.unsolvableVariable(node, name, true);
            }
            return value;
        }
        return this.getAttribute(data, name, node);
    }

    @Override
    protected Object visit(ASTArrayAccess node, Object data) {
        Object object = data;
        int numChildren = node.jjtGetNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            JexlNode nindex = node.jjtGetChild(i);
            if (object == null) {
                return null;
            }
            Object index = nindex.jjtAccept(this, null);
            if (this.isCancelled()) {
                throw new JexlException.Cancel(node);
            }
            object = this.getAttribute(object, index, nindex);
        }
        return object;
    }

    protected boolean isTernaryProtected(JexlNode node) {
        for (JexlNode walk = node.jjtGetParent(); walk != null; walk = walk.jjtGetParent()) {
            if (walk instanceof ASTTernaryNode) {
                return true;
            }
            if (!(walk instanceof ASTReference) && !(walk instanceof ASTArrayAccess)) break;
        }
        return false;
    }

    protected boolean isLocalVariable(ASTReference node, int which) {
        return node.jjtGetNumChildren() > which && node.jjtGetChild(which) instanceof ASTIdentifier && ((ASTIdentifier)node.jjtGetChild(which)).getSymbol() >= 0;
    }

    @Override
    protected Object visit(ASTIdentifierAccess node, Object data) {
        return data != null ? this.getAttribute(data, node.getIdentifier(), node) : null;
    }

    @Override
    protected Object visit(ASTReference node, Object data) {
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
        int numChildren = node.jjtGetNumChildren();
        JexlNode parent = node.jjtGetParent();
        Object object = null;
        StringBuilder ant = null;
        boolean antish = !(parent instanceof ASTReference);
        boolean pty = true;
        int v = 1;
        for (int c = 0; c < numChildren; ++c) {
            JexlNode child;
            JexlNode objectNode = node.jjtGetChild(c);
            if (objectNode instanceof ASTMethodNode) {
                if (object == null) break;
                antish = false;
            }
            object = objectNode.jjtAccept(this, object);
            if (this.isCancelled()) {
                throw new JexlException.Cancel(node);
            }
            if (object != null) {
                antish = false;
                continue;
            }
            if (!antish) break;
            if (ant == null) {
                JexlNode first = node.jjtGetChild(0);
                if (first instanceof ASTIdentifier) {
                    if (((ASTIdentifier)first).getSymbol() >= 0) break;
                    ant = new StringBuilder(((ASTIdentifier)first).getName());
                } else {
                    pty = false;
                    break;
                }
            }
            while (v <= c && (child = node.jjtGetChild(v)) instanceof ASTIdentifierAccess) {
                ant.append('.');
                ant.append(((ASTIdentifierAccess)objectNode).getName());
                ++v;
            }
            object = this.context.get(ant.toString());
        }
        if (object == null && !this.isTernaryProtected(node)) {
            if (antish && ant != null) {
                boolean undefined = !this.context.has(ant.toString()) && !this.isLocalVariable(node, 0);
                return this.unsolvableVariable(node, ant.toString(), undefined);
            }
            if (!pty) {
                return this.unsolvableProperty(node, "<null>.<?>", null);
            }
        }
        return object;
    }

    @Override
    protected Object visit(ASTAssignment node, Object data) {
        return this.executeAssign(node, null, data);
    }

    @Override
    protected Object visit(ASTSetAddNode node, Object data) {
        return this.executeAssign(node, JexlOperator.SELF_ADD, data);
    }

    @Override
    protected Object visit(ASTSetSubNode node, Object data) {
        return this.executeAssign(node, JexlOperator.SELF_SUBTRACT, data);
    }

    @Override
    protected Object visit(ASTSetMultNode node, Object data) {
        return this.executeAssign(node, JexlOperator.SELF_MULTIPLY, data);
    }

    @Override
    protected Object visit(ASTSetDivNode node, Object data) {
        return this.executeAssign(node, JexlOperator.SELF_DIVIDE, data);
    }

    @Override
    protected Object visit(ASTSetModNode node, Object data) {
        return this.executeAssign(node, JexlOperator.SELF_MOD, data);
    }

    @Override
    protected Object visit(ASTSetAndNode node, Object data) {
        return this.executeAssign(node, JexlOperator.SELF_AND, data);
    }

    @Override
    protected Object visit(ASTSetOrNode node, Object data) {
        return this.executeAssign(node, JexlOperator.SELF_OR, data);
    }

    @Override
    protected Object visit(ASTSetXorNode node, Object data) {
        return this.executeAssign(node, JexlOperator.SELF_XOR, data);
    }

    protected Object executeAssign(JexlNode node, JexlOperator assignop, Object data) {
        Object self;
        int c;
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
        JexlNode left = node.jjtGetChild(0);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        Object object = null;
        int symbol = -1;
        boolean antish = true;
        int last = left.jjtGetNumChildren() - 1;
        if (left instanceof ASTIdentifier) {
            ASTIdentifier var = (ASTIdentifier)left;
            symbol = var.getSymbol();
            if (symbol >= 0) {
                if (last < 0) {
                    Object self2;
                    if (assignop != null && (right = this.operators.tryAssignOverload(node, assignop, self2 = this.frame.get(symbol), right)) == JexlOperator.ASSIGN) {
                        return self2;
                    }
                    this.frame.set(symbol, right);
                    if (right instanceof Closure) {
                        ((Closure)right).setHoisted(symbol, right);
                    }
                    return right;
                }
                object = this.frame.get(symbol);
                antish = false;
            } else {
                if (last < 0) {
                    Object self3;
                    if (assignop != null && (right = this.operators.tryAssignOverload(node, assignop, self3 = this.context.get(var.getName()), right)) == JexlOperator.ASSIGN) {
                        return self3;
                    }
                    try {
                        this.context.set(var.getName(), right);
                    }
                    catch (UnsupportedOperationException xsupport) {
                        throw new JexlException(node, "context is readonly", (Throwable)xsupport);
                    }
                    return right;
                }
                object = this.context.get(var.getName());
                if (object != null) {
                    antish = false;
                }
            }
        } else if (!(left instanceof ASTReference)) {
            throw new JexlException(left, "illegal assignment form 0");
        }
        JexlNode objectNode = null;
        StringBuilder ant = null;
        int v = 1;
        int n = c = symbol >= 0 ? 1 : 0;
        while (c < last) {
            objectNode = left.jjtGetChild(c);
            object = objectNode.jjtAccept(this, object);
            if (object != null) {
                antish = false;
            } else if (antish) {
                JexlNode child;
                if (ant == null) {
                    JexlNode first = left.jjtGetChild(0);
                    if (!(first instanceof ASTIdentifier) || ((ASTIdentifier)first).getSymbol() >= 0) break;
                    ant = new StringBuilder(((ASTIdentifier)first).getName());
                }
                while (v <= c && (child = left.jjtGetChild(v)) instanceof ASTIdentifierAccess) {
                    ant.append('.');
                    ant.append(((ASTIdentifierAccess)objectNode).getName());
                    ++v;
                }
                object = this.context.get(ant.toString());
            } else {
                throw new JexlException(objectNode, "illegal assignment form");
            }
            ++c;
        }
        Object property = null;
        JexlNode propertyNode = left.jjtGetChild(last);
        if (propertyNode instanceof ASTIdentifierAccess) {
            property = ((ASTIdentifierAccess)propertyNode).getIdentifier();
            if (ant != null && object == null) {
                Object self4;
                if (last > 0) {
                    ant.append('.');
                }
                ant.append(String.valueOf(property));
                if (assignop != null && (right = this.operators.tryAssignOverload(node, assignop, self4 = this.context.get(ant.toString()), right)) == JexlOperator.ASSIGN) {
                    return self4;
                }
                try {
                    this.context.set(ant.toString(), right);
                }
                catch (UnsupportedOperationException xsupport) {
                    throw new JexlException(node, "context is readonly", (Throwable)xsupport);
                }
                return right;
            }
        } else if (propertyNode instanceof ASTArrayAccess) {
            int numChildren = propertyNode.jjtGetNumChildren() - 1;
            for (int i = 0; i < numChildren; ++i) {
                JexlNode nindex = propertyNode.jjtGetChild(i);
                Object index = nindex.jjtAccept(this, null);
                object = this.getAttribute(object, index, nindex);
            }
            propertyNode = propertyNode.jjtGetChild(numChildren);
            property = propertyNode.jjtAccept(this, null);
        } else {
            throw new JexlException(objectNode, "illegal assignment form");
        }
        if (property == null) {
            return this.unsolvableProperty(propertyNode, "<?>.<null>", null);
        }
        if (object == null) {
            return this.unsolvableProperty(objectNode, "<null>.<?>", null);
        }
        if (assignop != null && (right = this.operators.tryAssignOverload(node, assignop, self = this.getAttribute(object, property, propertyNode), right)) == JexlOperator.ASSIGN) {
            return self;
        }
        this.setAttribute(object, property, right, propertyNode);
        return right;
    }

    protected Object[] visit(ASTArguments node, Object data) {
        int argc = node.jjtGetNumChildren();
        Object[] argv = new Object[argc];
        for (int i = 0; i < argc; ++i) {
            argv[i] = node.jjtGetChild(i).jjtAccept(this, data);
        }
        return argv;
    }

    @Override
    protected Object visit(ASTMethodNode node, Object data) {
        Object method;
        JexlNode methodNode = node.jjtGetChild(0);
        Object object = null;
        JexlNode objectNode = null;
        if (methodNode instanceof ASTIdentifierAccess) {
            method = methodNode;
            object = data;
            if (object == null) {
                return this.unsolvableMethod(objectNode, "<null>.<?>(...)");
            }
        } else {
            method = methodNode.jjtAccept(this, data);
        }
        Object result = method;
        for (int a = 1; a < node.jjtGetNumChildren(); ++a) {
            if (result == null) {
                return this.unsolvableMethod(methodNode, "<?>.<null>(...)");
            }
            ASTArguments argNode = (ASTArguments)node.jjtGetChild(a);
            object = result = this.call(node, object, result, argNode);
        }
        return result;
    }

    @Override
    protected Object visit(ASTFunctionNode node, Object data) {
        int argc = node.jjtGetNumChildren();
        if (argc == 2) {
            ASTIdentifier functionNode = (ASTIdentifier)node.jjtGetChild(0);
            ASTArguments argNode = (ASTArguments)node.jjtGetChild(1);
            return this.call(node, this.context, functionNode, argNode);
        }
        String prefix = ((ASTIdentifier)node.jjtGetChild(0)).getName();
        Object namespace = this.resolveNamespace(prefix, node);
        ASTIdentifier functionNode = (ASTIdentifier)node.jjtGetChild(1);
        ASTArguments argNode = (ASTArguments)node.jjtGetChild(2);
        return this.call(node, namespace, functionNode, argNode);
    }

    private Object[] functionArguments(Object target, boolean narrow, Object[] args) {
        if (target == null || target == this.context) {
            if (narrow) {
                this.arithmetic.narrowArguments(args);
            }
            return args;
        }
        Object[] nargv = new Object[args.length + 1];
        if (narrow) {
            nargv[0] = this.functionArgument(true, target);
            for (int a = 1; a <= args.length; ++a) {
                nargv[a] = this.functionArgument(true, args[a - 1]);
            }
        } else {
            nargv[0] = target;
            System.arraycopy(args, 0, nargv, 1, args.length);
        }
        return nargv;
    }

    private Object functionArgument(boolean narrow, Object arg) {
        return narrow && arg instanceof Number ? this.arithmetic.narrow((Number)arg) : arg;
    }

    protected Object call(JexlNode node, Object target, Object functor, ASTArguments argNode) {
        String methodName;
        int symbol;
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
        Object[] argv = this.visit(argNode, null);
        if (functor instanceof ASTIdentifier) {
            ASTIdentifier methodIdentifier = (ASTIdentifier)functor;
            symbol = methodIdentifier.getSymbol();
            methodName = methodIdentifier.getName();
            functor = null;
        } else if (functor instanceof ASTIdentifierAccess) {
            methodName = ((ASTIdentifierAccess)functor).getName();
            symbol = -1;
            functor = null;
        } else if (functor != null) {
            symbol = -2;
            methodName = null;
        } else {
            return this.unsolvableMethod(node, "?");
        }
        Object caller = target;
        try {
            boolean cacheable = this.cache;
            if (methodName != null) {
                Object eval;
                Object cached;
                if (target == this.context) {
                    boolean isavar = true;
                    if (symbol >= 0) {
                        functor = this.frame.get(symbol);
                    } else if (this.context.has(methodName)) {
                        functor = this.context.get(methodName);
                    } else {
                        isavar = false;
                    }
                    if (isavar) {
                        if (functor == null) {
                            return this.unsolvableMethod(node, methodName);
                        }
                        cacheable = false;
                    }
                }
                if (cacheable && (cached = node.jjtGetValue()) instanceof Funcall && JexlEngine.TRY_FAILED != (eval = ((Funcall)cached).tryInvoke(this, methodName, target, argv))) {
                    return eval;
                }
            }
            boolean narrow = false;
            JexlMethod vm = null;
            Funcall funcall = null;
            while (true) {
                if (functor == null) {
                    JexlPropertyGet get;
                    vm = this.uberspect.getMethod(target, methodName, argv);
                    if (vm != null) {
                        if (!cacheable || !vm.isCacheable()) break;
                        funcall = new Funcall(vm, narrow);
                        break;
                    }
                    if (target == this.context) {
                        Object namespace = this.resolveNamespace(null, node);
                        if (namespace == this.context) break;
                        if (namespace != null) {
                            target = namespace;
                            caller = null;
                            continue;
                        }
                    } else if (!narrow && (get = this.uberspect.getPropertyGet(target, methodName)) != null) {
                        functor = get.tryInvoke(target, methodName);
                    }
                }
                if (functor != null) {
                    if (functor instanceof JexlScript) {
                        return ((JexlScript)functor).execute(this.context, argv);
                    }
                    if (functor instanceof JexlMethod) {
                        return ((JexlMethod)functor).invoke(target, argv);
                    }
                    vm = this.uberspect.getMethod(functor, "call", argv);
                    if (vm == null) break;
                    return vm.invoke(functor, argv);
                }
                Object[] nargv = this.functionArguments(caller, narrow, argv);
                vm = this.uberspect.getMethod(this.context, methodName, nargv);
                if (vm != null) {
                    argv = nargv;
                    target = this.context;
                    if (!cacheable || !vm.isCacheable()) break;
                    funcall = new ContextFuncall(vm, narrow);
                    break;
                }
                vm = this.uberspect.getMethod(this.arithmetic, methodName, nargv);
                if (vm != null) {
                    argv = nargv;
                    target = this.arithmetic;
                    if (!cacheable || !vm.isCacheable()) break;
                    funcall = new ArithmeticFuncall(vm, narrow);
                    break;
                }
                if (!this.arithmetic.narrowArguments(argv)) break;
                narrow = true;
            }
            if (vm != null) {
                Object eval = vm.invoke(target, argv);
                if (funcall != null) {
                    node.jjtSetValue(funcall);
                }
                return eval;
            }
            return this.unsolvableMethod(node, methodName);
        }
        catch (JexlException xthru) {
            throw xthru;
        }
        catch (Exception xany) {
            throw this.invocationException(node, methodName, xany);
        }
    }

    @Override
    protected Object visit(ASTConstructorNode node, Object data) {
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
        Object cobject = node.jjtGetChild(0).jjtAccept(this, data);
        int argc = node.jjtGetNumChildren() - 1;
        Object[] argv = new Object[argc];
        for (int i = 0; i < argc; ++i) {
            argv[i] = node.jjtGetChild(i + 1).jjtAccept(this, data);
        }
        try {
            Object eval;
            JexlMethod mctor;
            Object cached;
            if (this.cache && (cached = node.jjtGetValue()) instanceof JexlMethod && !(mctor = (JexlMethod)cached).tryFailed(eval = mctor.tryInvoke(null, cobject, argv))) {
                return eval;
            }
            JexlMethod ctor = this.uberspect.getConstructor(cobject, argv);
            if (ctor == null) {
                if (this.arithmetic.narrowArguments(argv)) {
                    ctor = this.uberspect.getConstructor(cobject, argv);
                }
                if (ctor == null) {
                    String dbgStr = cobject != null ? cobject.toString() : null;
                    return this.unsolvableMethod(node, dbgStr);
                }
            }
            Object instance = ctor.invoke(cobject, argv);
            if (this.cache && ctor.isCacheable()) {
                node.jjtSetValue(ctor);
            }
            return instance;
        }
        catch (JexlException xthru) {
            throw xthru;
        }
        catch (Exception xany) {
            String dbgStr = cobject != null ? cobject.toString() : null;
            throw this.invocationException(node, dbgStr, xany);
        }
    }

    public Object getAttribute(Object object, Object attribute) {
        return this.getAttribute(object, attribute, null);
    }

    protected Object getAttribute(Object object, Object attribute, JexlNode node) {
        if (object == null) {
            throw new JexlException(node, "object is null");
        }
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
        JexlOperator operator = node != null && node.jjtGetParent() instanceof ASTArrayAccess ? JexlOperator.ARRAY_GET : JexlOperator.PROPERTY_GET;
        Object result = this.operators.tryOverload(node, operator, object, attribute);
        if (result != JexlEngine.TRY_FAILED) {
            return result;
        }
        Exception xcause = null;
        try {
            Object value;
            JexlPropertyGet vg;
            Object cached;
            if (node != null && this.cache && (cached = node.jjtGetValue()) instanceof JexlPropertyGet && !(vg = (JexlPropertyGet)cached).tryFailed(value = vg.tryInvoke(object, attribute))) {
                return value;
            }
            List<JexlUberspect.PropertyResolver> resolvers = this.uberspect.getResolvers(operator, object);
            vg = this.uberspect.getPropertyGet(resolvers, object, attribute);
            if (vg != null) {
                value = vg.invoke(object);
                if (node != null && this.cache && vg.isCacheable()) {
                    node.jjtSetValue(vg);
                }
                return value;
            }
        }
        catch (Exception xany) {
            xcause = xany;
        }
        if (node != null) {
            String attrStr = attribute != null ? attribute.toString() : null;
            return this.unsolvableProperty(node, attrStr, xcause);
        }
        String error = "unable to get object property, class: " + object.getClass().getName() + ", property: " + attribute;
        throw new UnsupportedOperationException(error, xcause);
    }

    public void setAttribute(Object object, Object attribute, Object value) {
        this.setAttribute(object, attribute, value, null);
    }

    protected void setAttribute(Object object, Object attribute, Object value, JexlNode node) {
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
        JexlOperator operator = node != null && node.jjtGetParent() instanceof ASTArrayAccess ? JexlOperator.ARRAY_SET : JexlOperator.PROPERTY_SET;
        Object result = this.operators.tryOverload(node, operator, object, attribute, value);
        if (result != JexlEngine.TRY_FAILED) {
            return;
        }
        Exception xcause = null;
        try {
            Object[] narrow;
            Object eval;
            JexlPropertySet setter;
            Object cached;
            if (node != null && this.cache && (cached = node.jjtGetValue()) instanceof JexlPropertySet && !(setter = (JexlPropertySet)cached).tryFailed(eval = setter.tryInvoke(object, attribute, value))) {
                return;
            }
            List<JexlUberspect.PropertyResolver> resolvers = this.uberspect.getResolvers(operator, object);
            JexlPropertySet vs = this.uberspect.getPropertySet(resolvers, object, attribute, value);
            if (vs == null && this.arithmetic.narrowArguments(narrow = new Object[]{value})) {
                vs = this.uberspect.getPropertySet(resolvers, object, attribute, narrow[0]);
            }
            if (vs != null) {
                vs.invoke(object, value);
                if (node != null && this.cache && vs.isCacheable()) {
                    node.jjtSetValue(vs);
                }
                return;
            }
        }
        catch (Exception xany) {
            xcause = xany;
        }
        if (node == null) {
            String error = "unable to set object property, class: " + object.getClass().getName() + ", property: " + attribute + ", argument: " + value.getClass().getSimpleName();
            throw new UnsupportedOperationException(error, xcause);
        }
        String attrStr = attribute != null ? attribute.toString() : null;
        this.unsolvableProperty(node, attrStr, xcause);
    }

    @Override
    protected Object visit(ASTJxltLiteral node, Object data) {
        TemplateEngine.TemplateExpression tp = (TemplateEngine.TemplateExpression)node.jjtGetValue();
        if (tp == null) {
            TemplateEngine jxlt = this.jexl.jxlt();
            tp = jxlt.parseExpression(node.jexlInfo(), node.getLiteral(), this.frame != null ? this.frame.getScope() : null);
            node.jjtSetValue(tp);
        }
        if (tp != null) {
            return tp.evaluate(this.frame, this.context);
        }
        return null;
    }

    @Override
    protected Object visit(ASTAnnotation node, Object data) {
        throw new UnsupportedOperationException(ASTAnnotation.class.getName() + ": Not supported.");
    }

    @Override
    protected Object visit(ASTAnnotatedStatement node, Object data) {
        return this.processAnnotation(node, 0, data);
    }

    protected Object processAnnotation(final ASTAnnotatedStatement stmt, final int index, final Object data) {
        int last = stmt.jjtGetNumChildren() - 1;
        if (index == last) {
            JexlNode block = stmt.jjtGetChild(last);
            JexlArithmetic jexla = this.arithmetic.options(this.context);
            if (jexla != this.arithmetic) {
                if (!this.arithmetic.getClass().equals(jexla.getClass())) {
                    this.logger.warn((Object)("expected arithmetic to be " + this.arithmetic.getClass().getSimpleName() + ", got " + jexla.getClass().getSimpleName()));
                }
                Interpreter ii = new Interpreter(this, jexla);
                Object r = block.jjtAccept(ii, data);
                if (ii.isCancelled()) {
                    this.cancel();
                }
                return r;
            }
            return block.jjtAccept(this, data);
        }
        final boolean[] processed = new boolean[]{false};
        Callable<Object> jstmt = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                processed[0] = true;
                return Interpreter.this.processAnnotation(stmt, index + 1, data);
            }
        };
        ASTAnnotation anode = (ASTAnnotation)stmt.jjtGetChild(index);
        String aname = anode.getName();
        Object[] argv = anode.jjtGetNumChildren() > 0 ? this.visit((ASTArguments)anode.jjtGetChild(0), null) : null;
        try {
            Object result = this.processAnnotation(aname, argv, jstmt);
            if (!processed[0]) {
                return this.annotationError(anode, aname, null);
            }
            return result;
        }
        catch (JexlException xjexl) {
            throw xjexl;
        }
        catch (Exception xany) {
            return this.annotationError(anode, aname, xany);
        }
    }

    protected Object processAnnotation(String annotation, Object[] args, Callable<Object> stmt) throws Exception {
        return this.context instanceof JexlContext.AnnotationProcessor ? ((JexlContext.AnnotationProcessor)((Object)this.context)).processAnnotation(annotation, args, stmt) : stmt.call();
    }

    private static class ContextFuncall
    extends Funcall {
        protected ContextFuncall(JexlMethod jme, boolean flag) {
            super(jme, flag);
        }

        @Override
        protected Object tryInvoke(Interpreter ii, String name, Object target, Object[] args) {
            return this.me.tryInvoke(name, ii.context, ii.functionArguments(target, this.narrow, args));
        }
    }

    private static class ArithmeticFuncall
    extends Funcall {
        protected ArithmeticFuncall(JexlMethod jme, boolean flag) {
            super(jme, flag);
        }

        @Override
        protected Object tryInvoke(Interpreter ii, String name, Object target, Object[] args) {
            return this.me.tryInvoke(name, ii.arithmetic, ii.functionArguments(target, this.narrow, args));
        }
    }

    private static class Funcall {
        protected final boolean narrow;
        protected final JexlMethod me;

        protected Funcall(JexlMethod jme, boolean flag) {
            this.me = jme;
            this.narrow = flag;
        }

        protected Object tryInvoke(Interpreter ii, String name, Object target, Object[] args) {
            return this.me.tryInvoke(name, target, ii.functionArguments(null, this.narrow, args));
        }
    }
}

