/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.impl.internal.ProtocolInternalUtils;
import org.apache.bookkeeper.clients.impl.internal.api.LocationClient;
import org.apache.bookkeeper.clients.utils.GrpcChannels;
import org.apache.bookkeeper.clients.utils.GrpcUtils;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.common.util.ListenableFutures;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.Retries;
import org.apache.bookkeeper.common.util.Revisioned;
import org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointRequest;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.StorageContainerServiceGrpc;
import org.apache.bookkeeper.stream.protocol.util.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationClientImpl
implements LocationClient {
    private static final Logger log = LoggerFactory.getLogger(LocationClientImpl.class);
    private final StorageClientSettings settings;
    private final OrderedScheduler scheduler;
    private final ManagedChannel channel;
    private final StorageContainerServiceGrpc.StorageContainerServiceFutureStub locationService;
    @VisibleForTesting
    static final Predicate<Throwable> LOCATE_STORAGE_CONTAINERS_RETRY_PREDICATE = cause -> LocationClientImpl.shouldRetryOnException(cause);

    public LocationClientImpl(StorageClientSettings settings, OrderedScheduler scheduler) {
        this.settings = settings;
        this.scheduler = scheduler;
        this.channel = GrpcChannels.createChannelBuilder(settings.serviceUri(), settings).build();
        this.locationService = GrpcUtils.configureGrpcStub(StorageContainerServiceGrpc.newFutureStub((Channel)this.channel), Optional.empty());
    }

    private Stream<Long> getDefaultBackoffs() {
        return Backoff.exponential((long)200L, (int)2, (long)1000L);
    }

    private static boolean shouldRetryOnException(Throwable cause) {
        log.error("Not able to locate storage container {}", cause);
        if (cause instanceof StatusRuntimeException || cause instanceof StatusException) {
            Status status = cause instanceof StatusException ? ((StatusException)cause).getStatus() : ((StatusRuntimeException)cause).getStatus();
            switch (status.getCode()) {
                case INVALID_ARGUMENT: 
                case ALREADY_EXISTS: 
                case PERMISSION_DENIED: 
                case UNAUTHENTICATED: {
                    return false;
                }
            }
            return true;
        }
        return !(cause instanceof RuntimeException);
    }

    @Override
    public CompletableFuture<List<OneStorageContainerEndpointResponse>> locateStorageContainers(List<Revisioned<Long>> storageContainerIds) {
        GetStorageContainerEndpointRequest request = ProtoUtils.createGetStorageContainerEndpointRequest(storageContainerIds);
        return Retries.run(this.getDefaultBackoffs(), LOCATE_STORAGE_CONTAINERS_RETRY_PREDICATE, () -> ListenableFutures.fromListenableFuture((ListenableFuture)this.locationService.getStorageContainerEndpoint(request), ProtocolInternalUtils.GetStorageContainerEndpointsFunction), (OrderedScheduler)this.scheduler, (Object)request);
    }

    @Override
    public void close() {
        this.channel.shutdown();
    }
}

