/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import org.apache.activemq.usage.Usage;

public abstract class PercentLimitUsage<T extends Usage>
extends Usage<T> {
    protected int percentLimit = 0;

    public PercentLimitUsage(T parent, String name, float portion) {
        super(parent, name, portion);
    }

    public void setPercentLimit(int percentLimit) {
        this.usageLock.writeLock().lock();
        try {
            this.percentLimit = percentLimit;
            this.updateLimitBasedOnPercent();
        }
        finally {
            this.usageLock.writeLock().unlock();
        }
    }

    public int getPercentLimit() {
        this.usageLock.readLock().lock();
        try {
            int n = this.percentLimit;
            return n;
        }
        finally {
            this.usageLock.readLock().unlock();
        }
    }

    protected abstract void updateLimitBasedOnPercent();
}

