/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.generation.DoNotSub;

public class IntIterator
implements Iterator<Integer> {
    private final int missingValue;
    @DoNotSub
    private int positionCounter;
    @DoNotSub
    private int stopCounter;
    private int[] values;

    public IntIterator(int missingValue, int[] values) {
        this.missingValue = missingValue;
        this.reset(values);
    }

    void reset() {
        this.reset(this.values);
    }

    void reset(int[] values) {
        int length;
        this.values = values;
        int i = length = values.length;
        if (values[length - 1] != this.missingValue) {
            int size = length;
            for (i = 0; i < size && values[i] != this.missingValue; ++i) {
            }
        }
        this.stopCounter = i;
        this.positionCounter = i + length;
    }

    @DoNotSub
    protected int position() {
        return this.positionCounter & this.values.length - 1;
    }

    @Override
    public boolean hasNext() {
        int[] values = this.values;
        int mask = values.length - 1;
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & mask;
            if (values[index] == this.missingValue) continue;
            return true;
        }
        return false;
    }

    protected void findNext() {
        int[] values = this.values;
        int mask = values.length - 1;
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & mask;
            if (values[index] == this.missingValue) continue;
            this.positionCounter = i;
            return;
        }
        throw new NoSuchElementException();
    }

    @Override
    public Integer next() {
        return this.nextValue();
    }

    public int nextValue() {
        this.findNext();
        return this.values[this.position()];
    }
}

