/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.util.HashMap;
import java.util.Map;
import nl.basjes.parse.useragent.analyze.NumberRangeList;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;

public final class NumberRangeVisitor
extends UserAgentTreeWalkerBaseVisitor<NumberRangeList> {
    private static final Integer DEFAULT_MIN = 1;
    private static final Integer DEFAULT_MAX = 10;
    private static final Map<String, Integer> MAX_RANGE = new HashMap<String, Integer>();
    static final NumberRangeVisitor NUMBER_RANGE_VISITOR;

    private NumberRangeVisitor() {
    }

    private static Integer getMaxRange(UserAgentTreeWalkerParser.NumberRangeContext ctx) {
        ParserRuleContext parent = ctx.getParent();
        String name = ((UserAgentTreeWalkerParser.StepDownContext)parent).name.getText();
        Integer maxRange = MAX_RANGE.get(name);
        if (maxRange == null) {
            return DEFAULT_MAX;
        }
        return maxRange;
    }

    public static NumberRangeList getList(UserAgentTreeWalkerParser.NumberRangeContext ctx) {
        return (NumberRangeList)NUMBER_RANGE_VISITOR.visit(ctx);
    }

    @Override
    public NumberRangeList visitNumberRangeStartToEnd(UserAgentTreeWalkerParser.NumberRangeStartToEndContext ctx) {
        return new NumberRangeList(Integer.parseInt(ctx.rangeStart.getText()), Integer.parseInt(ctx.rangeEnd.getText()));
    }

    @Override
    public NumberRangeList visitNumberRangeOpenStartToEnd(UserAgentTreeWalkerParser.NumberRangeOpenStartToEndContext ctx) {
        return new NumberRangeList(1, Integer.parseInt(ctx.rangeEnd.getText()));
    }

    @Override
    public NumberRangeList visitNumberRangeStartToOpenEnd(UserAgentTreeWalkerParser.NumberRangeStartToOpenEndContext ctx) {
        return new NumberRangeList(Integer.parseInt(ctx.rangeStart.getText()), NumberRangeVisitor.getMaxRange(ctx));
    }

    @Override
    public NumberRangeList visitNumberRangeSingleValue(UserAgentTreeWalkerParser.NumberRangeSingleValueContext ctx) {
        int value = Integer.parseInt(ctx.count.getText());
        return new NumberRangeList(value, value);
    }

    @Override
    public NumberRangeList visitNumberRangeAll(UserAgentTreeWalkerParser.NumberRangeAllContext ctx) {
        return new NumberRangeList(DEFAULT_MIN, NumberRangeVisitor.getMaxRange(ctx));
    }

    @Override
    public NumberRangeList visitNumberRangeEmpty(UserAgentTreeWalkerParser.NumberRangeEmptyContext ctx) {
        return new NumberRangeList(DEFAULT_MIN, NumberRangeVisitor.getMaxRange(ctx));
    }

    static {
        MAX_RANGE.put("agent", 1);
        MAX_RANGE.put("name", 1);
        MAX_RANGE.put("key", 1);
        MAX_RANGE.put("value", 2);
        MAX_RANGE.put("version", 4);
        MAX_RANGE.put("comments", 2);
        MAX_RANGE.put("entry", 20);
        MAX_RANGE.put("product", 10);
        MAX_RANGE.put("email", 2);
        MAX_RANGE.put("keyvalue", 3);
        MAX_RANGE.put("text", 8);
        MAX_RANGE.put("url", 2);
        MAX_RANGE.put("uuid", 2);
        NUMBER_RANGE_VISITOR = new NumberRangeVisitor();
    }
}

