/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.image.Opale;

public final class ComponentRoseNote
extends AbstractTextualComponent
implements Stencil {
    private final double paddingX;
    private final double paddingY;
    private final Fashion symbolContext;
    private final double roundCorner;
    private final HorizontalAlignment position;

    public ComponentRoseNote(Style style, Display strings, double paddingX, double paddingY, ISkinSimple spriteContainer, HorizontalAlignment textAlignment, HorizontalAlignment position, Colors colors) {
        super(style, style.wrapWidth(), textAlignment == HorizontalAlignment.CENTER ? 15 : 6, 15, 5, spriteContainer, strings, true);
        this.paddingX = paddingX;
        this.paddingY = paddingY;
        this.position = position;
        this.symbolContext = style.getSymbolContext(this.getIHtmlColorSet(), colors);
        this.roundCorner = style.value(PName.RoundCorner).asInt(false);
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double result = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX() + this.symbolContext.getDeltaShadow();
        return result;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY() + this.symbolContext.getDeltaShadow();
    }

    @Override
    public double getPaddingX() {
        return this.paddingX;
    }

    @Override
    public double getPaddingY() {
        return this.paddingY;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        int textHeight = (int)this.getTextHeight(stringBounder);
        int x2 = (int)this.getTextWidth(stringBounder);
        double diffX = area.getDimensionToUse().getWidth() - this.getPreferredWidth(stringBounder);
        if (diffX < 0.0) {
            throw new IllegalArgumentException();
        }
        if (area.getDimensionToUse().getWidth() > this.getPreferredWidth(stringBounder)) {
            x2 = (int)(area.getDimensionToUse().getWidth() - 2.0 * this.getPaddingX());
        }
        UPath polygon = Opale.getPolygonNormal(x2, textHeight, this.roundCorner);
        polygon.setDeltaShadow(this.symbolContext.getDeltaShadow());
        ug = this.symbolContext.apply(ug);
        ug.draw(polygon);
        ug.draw(Opale.getCorner(x2, this.roundCorner));
        UGraphic ug2 = UGraphicStencil.create(ug, this, UStroke.simple());
        ug2 = this.position == HorizontalAlignment.LEFT ? ug2.apply(new UTranslate(this.getMarginX1(), this.getMarginY())) : (this.position == HorizontalAlignment.RIGHT ? ug2.apply(new UTranslate(area.getDimensionToUse().getWidth() - this.getTextWidth(stringBounder), this.getMarginY())) : ug2.apply(new UTranslate((double)this.getMarginX1() + diffX / 2.0, this.getMarginY())));
        this.getTextBlock().drawU(ug2);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.getTextWidth(stringBounder);
    }
}

