/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;

public abstract class TimeHeader {
    private final TimeScale timeScale;
    protected final TimeHeaderParameters thParam;

    public TimeHeader(TimeHeaderParameters thParam, TimeScale timeScale) {
        this.thParam = thParam;
        this.timeScale = timeScale;
    }

    protected final boolean isBold2(Day wink) {
        return this.thParam.getVerticalSeparatorBefore().contains(wink);
    }

    protected final Day getMin() {
        return this.thParam.getMin();
    }

    protected final Day getMax() {
        return this.thParam.getMax();
    }

    protected final HColor closedBackgroundColor() {
        return this.thParam.getClosedStyle().value(PName.BackGroundColor).asColor(this.thParam.getColorSet());
    }

    protected final HColor closedFontColor() {
        return this.thParam.getClosedStyle().value(PName.FontColor).asColor(this.thParam.getColorSet());
    }

    protected final HColor openFontColor() {
        return this.thParam.getTimelineStyle().value(PName.FontColor).asColor(this.thParam.getColorSet());
    }

    protected final HColor getLineColor() {
        return this.thParam.getTimelineStyle().value(PName.LineColor).asColor(this.thParam.getColorSet());
    }

    public abstract double getTimeHeaderHeight(StringBounder var1);

    public abstract double getTimeFooterHeight(StringBounder var1);

    public abstract double getFullHeaderHeight(StringBounder var1);

    public abstract void drawTimeHeader(UGraphic var1, double var2);

    public abstract void drawTimeFooter(UGraphic var1);

    public final TimeScale getTimeScale() {
        return this.timeScale;
    }

    protected final void drawHline(UGraphic ug, double y) {
        double xmin = this.getTimeScale().getStartingPosition(this.thParam.getMin());
        double xmax = this.getTimeScale().getEndingPosition(this.thParam.getMax());
        ULine hline = ULine.hline(xmax - xmin);
        ug.apply(this.getLineColor()).apply(UTranslate.dy(y)).draw(hline);
    }

    protected final void drawVline(UGraphic ug, double x, double y1, double y2) {
        ULine vbar = ULine.vline(y2 - y1);
        ug.apply(new UTranslate(x, y1)).draw(vbar);
    }

    protected final FontConfiguration getFontConfiguration(UFont font, boolean bold, HColor color) {
        if (bold) {
            font = font.bold();
        }
        return FontConfiguration.create(font, color, color, null);
    }

    protected final TextBlock getTextBlock(SName param, String text, boolean bold, HColor color) {
        UFont font = this.thParam.getStyle(SName.timeline, param).getUFont();
        FontConfiguration fontConfiguration = this.getFontConfiguration(font, bold, color);
        return Display.getWithNewlines(text).create(fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    protected final void printCentered(UGraphic ug, TextBlock text, double start, double end) {
        double width = text.calculateDimension(ug.getStringBounder()).getWidth();
        double available = end - start;
        double diff = Math.max(0.0, available - width);
        text.drawU(ug.apply(UTranslate.dx(start + diff / 2.0)));
    }

    protected final void printCentered(UGraphic ug, boolean hideIfTooBig, double start, double end, TextBlock ... texts) {
        double available = end - start;
        for (int i = texts.length - 1; i >= 0; --i) {
            TextBlock text = texts[i];
            double width = text.calculateDimension(ug.getStringBounder()).getWidth();
            if ((i != 0 || hideIfTooBig) && !(width <= available)) continue;
            double diff = Math.max(0.0, available - width);
            text.drawU(ug.apply(UTranslate.dx(start + diff / 2.0)));
            return;
        }
    }

    protected final void drawRectangle(UGraphic ug, double height, double x1, double x2) {
        if (height == 0.0) {
            return;
        }
        ug = ug.apply(HColors.none());
        ug = ug.apply(new UTranslate(x1, this.getFullHeaderHeight(ug.getStringBounder())));
        ug.draw(URectangle.build(x2 - x1, height));
    }

    protected void printVerticalSeparators(UGraphic ug, double totalHeightWithoutFooter) {
        ug = this.thParam.forVerticalSeparator(ug);
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) <= 0) {
            if (this.isBold2(wink)) {
                this.drawVline(ug, this.getTimeScale().getStartingPosition(wink), this.getFullHeaderHeight(ug.getStringBounder()), totalHeightWithoutFooter);
            }
            wink = wink.increment();
        }
    }
}

