/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.WithSprite;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.project.GanttConstraint;
import net.sourceforge.plantuml.project.GanttStyle;
import net.sourceforge.plantuml.project.LabelPosition;
import net.sourceforge.plantuml.project.LabelStrategy;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.OpenClose;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.Moment;
import net.sourceforge.plantuml.project.core.MomentImpl;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskCode;
import net.sourceforge.plantuml.project.core.TaskGroup;
import net.sourceforge.plantuml.project.core.TaskImpl;
import net.sourceforge.plantuml.project.core.TaskInstant;
import net.sourceforge.plantuml.project.core.TaskSeparator;
import net.sourceforge.plantuml.project.draw.FingerPrint;
import net.sourceforge.plantuml.project.draw.ResourceDraw;
import net.sourceforge.plantuml.project.draw.ResourceDrawBasic;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.draw.TaskDrawDiamond;
import net.sourceforge.plantuml.project.draw.TaskDrawGroup;
import net.sourceforge.plantuml.project.draw.TaskDrawRegular;
import net.sourceforge.plantuml.project.draw.TaskDrawSeparator;
import net.sourceforge.plantuml.project.draw.TimeHeader;
import net.sourceforge.plantuml.project.draw.TimeHeaderDaily;
import net.sourceforge.plantuml.project.draw.TimeHeaderMonthly;
import net.sourceforge.plantuml.project.draw.TimeHeaderQuarterly;
import net.sourceforge.plantuml.project.draw.TimeHeaderSimple;
import net.sourceforge.plantuml.project.draw.TimeHeaderWeekly;
import net.sourceforge.plantuml.project.draw.TimeHeaderYearly;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.solver.ImpossibleSolvingException;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.project.time.WeekNumberStrategy;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealOrigin;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.text.BackSlash;

public class GanttDiagram
extends TitledDiagram
implements ToTaskDraw,
WithSprite,
GanttStyle {
    private final Map<Task, TaskDraw> draws = new LinkedHashMap<Task, TaskDraw>();
    private final Map<TaskCode, Task> tasks = new LinkedHashMap<TaskCode, Task>();
    private final Map<String, Task> byShortName = new HashMap<String, Task>();
    private final List<GanttConstraint> constraints = new ArrayList<GanttConstraint>();
    private final HColorSet colorSet = HColorSet.instance();
    private final OpenClose openClose = new OpenClose();
    private final Map<String, Resource> resources = new LinkedHashMap<String, Resource>();
    private final Map<Day, HColor> colorDaysToday = new HashMap<Day, HColor>();
    private final Map<Day, HColor> colorDaysInternal = new HashMap<Day, HColor>();
    private final Map<DayOfWeek, HColor> colorDaysOfWeek = new HashMap<DayOfWeek, HColor>();
    private final Map<Day, String> nameDays = new HashMap<Day, String>();
    private LabelStrategy labelStrategy = new LabelStrategy(LabelPosition.LEGACY, HorizontalAlignment.LEFT);
    private WeekNumberStrategy weekNumberStrategy = new WeekNumberStrategy(DayOfWeek.MONDAY, 4);
    private PrintScale printScale = PrintScale.DAILY;
    private double factorScale = 1.0;
    private Locale locale = Locale.ENGLISH;
    private Day today;
    private double totalHeightWithoutFooter;
    private Day min = Day.create(0L);
    private Day max;
    private Day printStart;
    private Day printEnd;
    private final RealOrigin origin = RealUtils.createOrigin();
    private int defaultCompletion = 100;
    private Task it;
    private Resource they;
    private final Map<String, OpenClose> openCloseForTask = new HashMap<String, OpenClose>();
    private TaskGroup currentGroup = null;
    private boolean showFootbox = true;
    private boolean withCalendarDate;
    private boolean hideResourceName;
    private boolean hideResourceFoobox;
    private final Set<Day> verticalSeparatorBefore = new HashSet<Day>();

    public CommandExecutionResult changeLanguage(String lang) {
        this.locale = new Locale(lang);
        return CommandExecutionResult.ok();
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Gantt)");
    }

    public void setWeekNumberStrategy(DayOfWeek firstDayOfWeek, int minimalDaysInFirstWeek) {
        this.weekNumberStrategy = new WeekNumberStrategy(firstDayOfWeek, minimalDaysInFirstWeek);
    }

    public GanttDiagram(UmlSource source) {
        super(source, UmlDiagramType.GANTT, null);
    }

    public final int getDpi(FileFormatOption fileFormatOption) {
        return 96;
    }

    @Override
    protected ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextMainBlock(fileFormatOption)).write(os);
    }

    public void setPrintScale(PrintScale printScale) {
        this.printScale = printScale;
    }

    public void setFactorScale(double factorScale) {
        this.factorScale = factorScale;
    }

    private double getFactorScale() {
        return this.printScale.getDefaultScale() * this.factorScale;
    }

    private boolean isHidden(Task task) {
        if (this.printStart == null || task instanceof TaskSeparator) {
            return false;
        }
        if (task.getEnd().compareTo(this.min) < 0) {
            return true;
        }
        return task.getStart().compareTo(this.max) > 0;
    }

    @Override
    public String checkFinalError() {
        try {
            this.initMinMax();
        }
        catch (ImpossibleSolvingException ex) {
            return ex.getMessage();
        }
        return null;
    }

    @Override
    protected TextBlock getTextMainBlock(FileFormatOption fileFormatOption) {
        StringBounder stringBounder = fileFormatOption.getDefaultStringBounder(this.getSkinParam());
        if (this.printStart == null) {
            this.initMinMax();
        } else {
            this.min = this.printStart;
            this.max = this.printEnd;
        }
        final TimeHeader timeHeader = this.getTimeHeader(stringBounder);
        this.initTaskAndResourceDraws(timeHeader.getTimeScale(), timeHeader.getFullHeaderHeight(stringBounder), stringBounder);
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                try {
                    Style timelineStyle;
                    HColor back;
                    UGraphic ugOrig = ug;
                    if (GanttDiagram.this.labelStrategy.titleInFirstColumn()) {
                        ug = ug.apply(UTranslate.dx(this.getTitlesColumnWidth(ug.getStringBounder())));
                    }
                    if (!(back = (timelineStyle = StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.timeline).getMergedStyle(GanttDiagram.this.getCurrentStyleBuilder())).value(PName.BackGroundColor).asColor(GanttDiagram.this.getIHtmlColorSet())).isTransparent()) {
                        URectangle rect1 = URectangle.build(this.calculateDimension(ug.getStringBounder()).getWidth(), timeHeader.getTimeHeaderHeight(ug.getStringBounder()));
                        ug.apply(back.bg()).draw(rect1);
                        if (GanttDiagram.this.showFootbox) {
                            URectangle rect2 = URectangle.build(this.calculateDimension(ug.getStringBounder()).getWidth(), timeHeader.getTimeFooterHeight(ug.getStringBounder()));
                            ug.apply(back.bg()).apply(UTranslate.dy(GanttDiagram.this.totalHeightWithoutFooter)).draw(rect2);
                        }
                    }
                    timeHeader.drawTimeHeader(ug, GanttDiagram.this.totalHeightWithoutFooter);
                    GanttDiagram.this.drawConstraints(ug, timeHeader.getTimeScale());
                    GanttDiagram.this.drawTasksRect(ug);
                    GanttDiagram.this.drawTasksTitle(ugOrig, this.getTitlesColumnWidth(ug.getStringBounder()), this.getBarsColumnWidth(timeHeader));
                    if (!GanttDiagram.this.hideResourceFoobox) {
                        GanttDiagram.this.drawResources(ug);
                    }
                    if (GanttDiagram.this.showFootbox) {
                        timeHeader.drawTimeFooter(ug.apply(UTranslate.dy(GanttDiagram.this.totalHeightWithoutFooter)));
                    }
                }
                catch (Throwable t) {
                    Logme.error(t);
                    GraphvizCrash crash = new GraphvizCrash(GanttDiagram.this.getSource().getPlainString(BackSlash.lineSeparator()), false, t);
                    crash.drawU(ug);
                }
            }

            private double getTitlesColumnWidth(StringBounder stringBounder) {
                if (GanttDiagram.this.labelStrategy.titleInside()) {
                    return 0.0;
                }
                double width = 0.0;
                for (Task task : GanttDiagram.this.tasks.values()) {
                    if (GanttDiagram.this.isHidden(task)) continue;
                    width = Math.max(width, ((TaskDraw)GanttDiagram.this.draws.get(task)).getTitleWidth(stringBounder));
                }
                return width;
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(this.getTitlesColumnWidth(stringBounder) + this.getBarsColumnWidth(timeHeader), GanttDiagram.this.getTotalHeight(stringBounder, timeHeader));
            }

            private double getBarsColumnWidth(TimeHeader timeHeader2) {
                double xmin = timeHeader2.getTimeScale().getStartingPosition(GanttDiagram.this.min);
                double xmax = timeHeader2.getTimeScale().getEndingPosition(GanttDiagram.this.max);
                return xmax - xmin;
            }
        };
    }

    private TimeHeader getTimeHeader(StringBounder stringBounder) {
        if (this.openClose.getStartingDay() == null) {
            return new TimeHeaderSimple(stringBounder, this.thParam(), this.printScale);
        }
        if (this.printScale == PrintScale.DAILY) {
            return new TimeHeaderDaily(stringBounder, this.thParam(), this.nameDays, this.printStart);
        }
        if (this.printScale == PrintScale.WEEKLY) {
            return new TimeHeaderWeekly(stringBounder, this.thParam(), this.weekNumberStrategy, this.withCalendarDate, this.printStart);
        }
        if (this.printScale == PrintScale.MONTHLY) {
            return new TimeHeaderMonthly(stringBounder, this.thParam(), this.printStart);
        }
        if (this.printScale == PrintScale.QUARTERLY) {
            return new TimeHeaderQuarterly(stringBounder, this.thParam(), this.printStart);
        }
        if (this.printScale == PrintScale.YEARLY) {
            return new TimeHeaderYearly(stringBounder, this.thParam(), this.printStart);
        }
        throw new IllegalStateException();
    }

    private TimeHeaderParameters thParam() {
        return new TimeHeaderParameters(this.colorDays(), this.getFactorScale(), this.min, this.max, this.getIHtmlColorSet(), this.locale, this.openClose, this.colorDaysOfWeek, this.verticalSeparatorBefore, this);
    }

    private Map<Day, HColor> colorDays() {
        this.colorDaysInternal.putAll(this.colorDaysToday);
        return Collections.unmodifiableMap(this.colorDaysInternal);
    }

    @Override
    public final Style getStyle(SName param) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, param).getMergedStyle(this.getCurrentStyleBuilder());
    }

    @Override
    public final Style getStyle(SName param1, SName param2) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, param1, param2).getMergedStyle(this.getCurrentStyleBuilder());
    }

    private double getTotalHeight(StringBounder stringBounder, TimeHeader timeHeader) {
        if (this.showFootbox) {
            return this.totalHeightWithoutFooter + timeHeader.getTimeFooterHeight(stringBounder);
        }
        return this.totalHeightWithoutFooter;
    }

    private void drawTasksRect(UGraphic ug) {
        for (Task task : this.tasks.values()) {
            if (this.isHidden(task)) continue;
            TaskDraw draw = this.draws.get(task);
            UTranslate move = UTranslate.dy(draw.getY(ug.getStringBounder()).getCurrentValue());
            draw.drawU(ug.apply(move));
        }
    }

    private void drawConstraints(UGraphic ug, TimeScale timeScale) {
        for (GanttConstraint constraint : this.constraints) {
            if (this.printStart != null && constraint.isHidden(this.min, this.max)) continue;
            constraint.getUDrawable(timeScale, this).drawU(ug);
        }
    }

    public StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.arrow);
    }

    private void drawTasksTitle(UGraphic ug, double colTitles, double colBars) {
        for (Task task : this.tasks.values()) {
            if (this.isHidden(task)) continue;
            TaskDraw draw = this.draws.get(task);
            UTranslate move = UTranslate.dy(draw.getY(ug.getStringBounder()).getCurrentValue());
            draw.drawTitle(ug.apply(move), this.labelStrategy, colTitles, colBars);
        }
    }

    private void drawResources(UGraphic ug) {
        for (Resource res : this.resources.values()) {
            ResourceDraw draw = res.getResourceDraw();
            UTranslate move = UTranslate.dy(draw.getY());
            draw.drawU(ug.apply(move));
        }
    }

    public void closeDayOfWeek(DayOfWeek day, String task) {
        this.openClose.close(day);
    }

    public void openDayOfWeek(DayOfWeek day, String task) {
        if (task.length() == 0) {
            this.openClose.open(day);
        } else {
            this.getOpenCloseForTask(task).open(day);
        }
    }

    public void closeDayAsDate(Day day, String task) {
        if (task.length() == 0) {
            this.openClose.close(day);
        } else {
            this.getOpenCloseForTask(task).close(day);
        }
    }

    public void openDayAsDate(Day day, String task) {
        if (task.length() == 0) {
            this.openClose.open(day);
        } else {
            this.getOpenCloseForTask(task).open(day);
        }
    }

    private OpenClose getOpenCloseForTask(String task) {
        OpenClose except = this.openCloseForTask.get(task);
        if (except == null) {
            except = new OpenClose();
            this.openCloseForTask.put(task, except);
        }
        return except;
    }

    private void initTaskAndResourceDraws(TimeScale timeScale, double headerHeight, StringBounder stringBounder) {
        Real y = this.origin.addFixed(headerHeight);
        for (Task task : this.tasks.values()) {
            TaskDraw draw;
            if (task instanceof TaskSeparator) {
                TaskSeparator taskSeparator = (TaskSeparator)task;
                draw = new TaskDrawSeparator(taskSeparator.getName(), timeScale, y, this.min, this.max, task.getStyleBuilder(), this.getSkinParam().getIHtmlColorSet());
            } else if (task instanceof TaskGroup) {
                TaskGroup taskGroup = (TaskGroup)task;
                draw = new TaskDrawGroup(timeScale, y, taskGroup.getCode().getSimpleDisplay(), this.getStart(taskGroup), this.getEnd(taskGroup), task, this, task.getStyleBuilder());
            } else {
                String disp;
                TaskImpl tmp = (TaskImpl)task;
                String string = disp = this.hideResourceName ? tmp.getCode().getSimpleDisplay() : tmp.getPrettyDisplay();
                if (tmp.isDiamond()) {
                    draw = new TaskDrawDiamond(timeScale, y, disp, this.getStart(tmp), task, this, task.getStyleBuilder());
                } else {
                    boolean oddStart = this.printStart != null && this.min.compareTo(this.getStart(tmp)) == 0;
                    boolean oddEnd = this.printStart != null && this.max.compareTo(this.getEnd(tmp)) == 0;
                    draw = new TaskDrawRegular(timeScale, y, disp, this.getStart(tmp), this.getEnd(tmp), oddStart, oddEnd, this.getSkinParam(), task, this, this.getConstraints(task), task.getStyleBuilder());
                }
                draw.setColorsAndCompletion(tmp.getColors(), tmp.getCompletion(), tmp.getUrl(), tmp.getNote());
            }
            if (task.getRow() == null) {
                y = y.addAtLeast(draw.getFullHeightTask(stringBounder));
            }
            this.draws.put(task, draw);
        }
        this.origin.compileNow();
        this.magicPush(stringBounder);
        double yy = this.lastY(stringBounder);
        if (yy == 0.0) {
            yy = headerHeight;
        } else if (!this.hideResourceFoobox) {
            for (Resource res : this.resources.values()) {
                ResourceDraw draw = this.buildResourceDraw(this, res, timeScale, yy, this.min, this.max);
                res.setTaskDraw(draw);
                yy += draw.getHeight(stringBounder);
            }
        }
        this.totalHeightWithoutFooter = yy;
    }

    private ResourceDraw buildResourceDraw(GanttDiagram gantt, Resource res, TimeScale timeScale, double y, Day min, Day max) {
        return new ResourceDrawBasic(gantt, res, timeScale, y, min, max);
    }

    private Collection<GanttConstraint> getConstraints(Task task) {
        ArrayList<GanttConstraint> result = new ArrayList<GanttConstraint>();
        for (GanttConstraint constraint : this.constraints) {
            if (!constraint.isOn(task)) continue;
            result.add(constraint);
        }
        return Collections.unmodifiableCollection(result);
    }

    private double lastY(StringBounder stringBounder) {
        double result = 0.0;
        for (TaskDraw td : this.draws.values()) {
            result = Math.max(result, td.getY(stringBounder).getCurrentValue() + td.getHeightMax(stringBounder));
        }
        return result;
    }

    private void magicPush(StringBounder stringBounder) {
        ArrayList<TaskDraw> notes = new ArrayList<TaskDraw>();
        for (TaskDraw td : this.draws.values()) {
            FingerPrint taskPrint = td.getFingerPrint(stringBounder);
            FingerPrint fingerPrintNote = td.getFingerPrintNote(stringBounder);
            if (td.getTrueRow() == null) {
                for (TaskDraw note : notes) {
                    FingerPrint otherNote = note.getFingerPrintNote(stringBounder);
                    double deltaY = otherNote.overlap(taskPrint);
                    if (!(deltaY > 0.0)) continue;
                    Real bottom = note.getY(stringBounder).addAtLeast(note.getHeightMax(stringBounder));
                    td.getY(stringBounder).ensureBiggerThan(bottom);
                    this.origin.compileNow();
                }
            }
            if (fingerPrintNote == null) continue;
            notes.add(td);
        }
    }

    private Day getStart(Task tmp) {
        if (this.printStart == null) {
            return tmp.getStart();
        }
        return Day.max(this.min, tmp.getStart());
    }

    private Day getEnd(Task tmp) {
        if (this.printStart == null) {
            return tmp.getEnd();
        }
        return Day.min(this.max, tmp.getEnd());
    }

    private void initMinMax() {
        if (this.tasks.size() == 0) {
            this.max = this.min.increment();
        } else {
            this.max = null;
            for (Task task : this.tasks.values()) {
                if (task instanceof TaskSeparator || task instanceof TaskGroup) continue;
                Day start = task.getStart();
                Day end = task.getEnd();
                if (this.max != null && this.max.compareTo(end) >= 0) continue;
                this.max = end;
            }
        }
        if (this.openClose.getStartingDay() != null) {
            for (Day d : this.colorDays().keySet()) {
                if (d.compareTo(this.max) <= 0) continue;
                this.max = d;
            }
            for (Day d : this.nameDays.keySet()) {
                if (d.compareTo(this.max) <= 0) continue;
                this.max = d;
            }
        }
    }

    public Day getThenDate() {
        Day result = this.getStartingDate();
        for (Day d : this.colorDays().keySet()) {
            if (d.compareTo(result) <= 0) continue;
            result = d;
        }
        for (Day d : this.nameDays.keySet()) {
            if (d.compareTo(result) <= 0) continue;
            result = d;
        }
        return result;
    }

    public Task getExistingTask(String id) {
        Task result = this.byShortName.get(Objects.requireNonNull(id));
        if (result != null) {
            return result;
        }
        TaskCode code = new TaskCode(id);
        return this.tasks.get(code);
    }

    public GanttConstraint forceTaskOrder(Task task1, Task task2) {
        TaskInstant end1 = new TaskInstant(task1, TaskAttribute.END);
        task2.setStart(end1.getInstantPrecise());
        GanttConstraint result = new GanttConstraint(this.getIHtmlColorSet(), this.getSkinParam().getCurrentStyleBuilder(), end1, new TaskInstant(task2, TaskAttribute.START));
        this.addContraint(result);
        return result;
    }

    public Task getOrCreateTask(String codeOrShortName, String shortName, boolean linkedToPrevious) {
        Task result;
        Objects.requireNonNull(codeOrShortName);
        Task task = result = shortName == null ? null : this.byShortName.get(shortName);
        if (result != null) {
            return result;
        }
        result = this.byShortName.get(codeOrShortName);
        if (result != null) {
            return result;
        }
        TaskCode code = new TaskCode(codeOrShortName);
        result = this.tasks.get(code);
        if (result == null) {
            Task previous = null;
            if (linkedToPrevious) {
                previous = this.getLastCreatedTask();
            }
            OpenClose except = this.openCloseForTask.get(codeOrShortName);
            result = new TaskImpl(this.getSkinParam().getCurrentStyleBuilder(), code, this.openClose.mutateMe(except), this.openClose.getStartingDay(), this.defaultCompletion);
            if (this.currentGroup != null) {
                this.currentGroup.addTask(result);
            }
            this.tasks.put(code, result);
            if (this.byShortName != null) {
                this.byShortName.put(shortName, result);
            }
            if (previous != null) {
                this.forceTaskOrder(previous, result);
            }
        }
        return result;
    }

    private Task getLastCreatedTask() {
        ArrayList<Task> all = new ArrayList<Task>(this.tasks.values());
        for (int i = all.size() - 1; i >= 0; --i) {
            if (!(all.get(i) instanceof TaskImpl)) continue;
            return (Task)all.get(i);
        }
        return null;
    }

    public void addSeparator(String comment) {
        TaskSeparator separator = new TaskSeparator(this.getSkinParam().getCurrentStyleBuilder(), comment, this.tasks.size());
        this.tasks.put(separator.getCode(), separator);
    }

    public CommandExecutionResult addGroup(String name) {
        TaskGroup group = new TaskGroup(this.currentGroup, this.getSkinParam().getCurrentStyleBuilder(), name);
        if (this.currentGroup != null) {
            this.currentGroup.addTask(group);
        }
        this.currentGroup = group;
        this.tasks.put(group.getCode(), group);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult endGroup() {
        if (this.currentGroup == null) {
            return CommandExecutionResult.error("No group to be closed");
        }
        this.currentGroup = this.currentGroup.getParent();
        return CommandExecutionResult.ok();
    }

    public void addContraint(GanttConstraint constraint) {
        this.constraints.add(constraint);
    }

    @Override
    public HColorSet getIHtmlColorSet() {
        return this.colorSet;
    }

    public void setProjectStartingDate(Day start) {
        this.openClose.setStartingDay(start);
        this.min = start;
    }

    public Day getStartingDate() {
        if (this.openClose.getStartingDay() == null) {
            return this.min;
        }
        return this.openClose.getStartingDay();
    }

    public Day getEndingDate() {
        this.initMinMax();
        return this.max;
    }

    public int daysInWeek() {
        return this.openClose.daysInWeek();
    }

    public boolean isOpen(Day day) {
        return this.openClose.getLoadAt(day) > 0;
    }

    public boolean affectResource(Task result, String description) {
        Pattern p = Pattern.compile("([^:]+)(:(\\d+))?");
        Matcher m = p.matcher(description);
        if (!m.find()) {
            throw new IllegalArgumentException();
        }
        Resource resource = this.getResource(m.group(1));
        int percentage = 100;
        if (m.group(3) != null) {
            percentage = Integer.parseInt(m.group(3));
        }
        if (percentage == 0) {
            return false;
        }
        result.addResource(resource, percentage);
        return true;
    }

    public Resource getResource(String resourceName) {
        Resource resource = this.resources.get(resourceName);
        if (resource == null) {
            resource = new Resource(resourceName);
        }
        this.resources.put(resourceName, resource);
        return resource;
    }

    public int getLoadForResource(Resource res, Day i) {
        int result = 0;
        for (Task task : this.tasks.values()) {
            if (task instanceof TaskSeparator) continue;
            TaskImpl task2 = (TaskImpl)task;
            result += task2.loadForResource(res, i);
        }
        return result;
    }

    public Moment getExistingMoment(String id) {
        Moment result = this.getExistingTask(id);
        if (result == null) {
            Day start = null;
            Day end = null;
            for (Map.Entry<Day, String> ent : this.nameDays.entrySet()) {
                if (!ent.getValue().equalsIgnoreCase(id)) continue;
                start = this.min(start, ent.getKey());
                end = this.max(end, ent.getKey());
            }
            if (start != null) {
                result = new MomentImpl(start, end);
            }
        }
        return result;
    }

    private Day min(Day d1, Day d2) {
        if (d1 == null) {
            return d2;
        }
        if (d1.compareTo(d2) > 0) {
            return d2;
        }
        return d1;
    }

    private Day max(Day d1, Day d2) {
        if (d1 == null) {
            return d2;
        }
        if (d1.compareTo(d2) < 0) {
            return d2;
        }
        return d1;
    }

    public void colorDay(Day day, HColor color) {
        this.colorDaysInternal.put(day, color);
    }

    public void colorDay(DayOfWeek day, HColor color) {
        this.colorDaysOfWeek.put(day, color);
    }

    public void nameDay(Day day, String name) {
        this.nameDays.put(day, name);
    }

    public Day getToday() {
        if (this.today == null) {
            this.today = Day.today();
        }
        return this.today;
    }

    public void setTodayColors(CenterBorderColor colors) {
        if (this.today == null) {
            this.today = Day.today();
        }
        this.colorDaysToday.put(this.today, colors.getCenter());
    }

    public CommandExecutionResult setToday(Day date) {
        this.today = date;
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult deleteTask(Task task) {
        task.setColors(new CenterBorderColor(HColors.WHITE, HColors.BLACK));
        return CommandExecutionResult.ok();
    }

    public void setPrintInterval(Day start, Day end) {
        this.printStart = start;
        this.printEnd = end;
    }

    @Override
    public TaskDraw getTaskDraw(Task task) {
        return this.draws.get(task);
    }

    public CommandExecutionResult addNote(Display note) {
        Task last = null;
        Iterator<Task> iterator = this.tasks.values().iterator();
        while (iterator.hasNext()) {
            Task current;
            last = current = iterator.next();
        }
        if (last == null) {
            return CommandExecutionResult.error("No task defined");
        }
        last.setNote(note);
        return CommandExecutionResult.ok();
    }

    @Override
    public LoadPlanable getDefaultPlan() {
        return this.openClose;
    }

    public void setShowFootbox(boolean footbox) {
        this.showFootbox = footbox;
    }

    @Override
    public ClockwiseTopRightBottomLeft getDefaultMargins() {
        return ClockwiseTopRightBottomLeft.none();
    }

    public void setLabelStrategy(LabelStrategy strategy) {
        this.labelStrategy = strategy;
    }

    public void setWithCalendarDate(boolean withCalendarDate) {
        this.withCalendarDate = withCalendarDate;
    }

    public CommandExecutionResult hideResourceName() {
        this.hideResourceName = true;
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult hideResourceFootbox() {
        this.hideResourceFoobox = true;
        return CommandExecutionResult.ok();
    }

    public void addVerticalSeparatorBefore(Day day) {
        this.verticalSeparatorBefore.add(day);
    }

    public void setTaskDefaultCompletion(int defaultCompletion) {
        this.defaultCompletion = defaultCompletion;
    }

    public List<TaskDrawRegular> getAllTasksForResource(Resource res) {
        ArrayList<TaskDrawRegular> result = new ArrayList<TaskDrawRegular>();
        for (Task task : this.tasks.values()) {
            if (!task.isAssignedTo(res)) continue;
            TaskDrawRegular draw = (TaskDrawRegular)this.draws.get(task);
            result.add(draw);
        }
        return Collections.unmodifiableList(result);
    }

    public void setIt(Task result) {
        this.it = result;
    }

    public Task getIt() {
        return this.it;
    }

    public final Resource getThey() {
        return this.they;
    }

    public final void setThey(Resource they) {
        this.they = they;
    }
}

