/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chronology;

import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;

public class TimeScaleChronology
implements TimeScale {
    private final double fullWidth;
    private long min;
    private long max;

    public TimeScaleChronology(double fullWidth) {
        this.fullWidth = fullWidth;
    }

    @Override
    public double getStartingPosition(Day instant) {
        long wink = instant.getMillis();
        if (wink < this.min) {
            throw new IllegalArgumentException();
        }
        if (wink > this.max) {
            throw new IllegalArgumentException();
        }
        return this.fullWidth * (double)(wink - this.min) / (double)(this.max - this.min);
    }

    @Override
    public double getEndingPosition(Day instant) {
        return this.getStartingPosition(instant);
    }

    @Override
    public double getWidth(Day instant) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBreaking(Day instant) {
        throw new UnsupportedOperationException();
    }

    public final void setMin(long min) {
        this.min = min;
    }

    public final void setMax(long max) {
        this.max = max;
    }
}

