/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.Category1Value;
import proguard.evaluation.value.Value;

public class InstructionOffsetValue
extends Category1Value {
    public static final InstructionOffsetValue EMPTY_VALUE = new InstructionOffsetValue();
    private int[] values;

    private InstructionOffsetValue() {
    }

    public InstructionOffsetValue(int value) {
        this.values = new int[]{value};
    }

    public InstructionOffsetValue(int[] values) {
        this.values = values;
    }

    public int instructionOffsetCount() {
        return this.values == null ? 0 : this.values.length;
    }

    public int instructionOffset(int index) {
        return this.values[index];
    }

    public boolean contains(int value) {
        if (this.values != null) {
            for (int index = 0; index < this.values.length; ++index) {
                if (this.values[index] != value) continue;
                return true;
            }
        }
        return false;
    }

    public int minimumValue() {
        int minimumValue = Integer.MAX_VALUE;
        if (this.values != null) {
            for (int index = 0; index < this.values.length; ++index) {
                int value = this.values[index];
                if (minimumValue <= value) continue;
                minimumValue = value;
            }
        }
        return minimumValue;
    }

    public int maximumValue() {
        int maximumValue = Integer.MIN_VALUE;
        if (this.values != null) {
            for (int index = 0; index < this.values.length; ++index) {
                int value = this.values[index];
                if (maximumValue >= value) continue;
                maximumValue = value;
            }
        }
        return maximumValue;
    }

    public final Value generalize(InstructionOffsetValue other) {
        int[] thisValues = this.values;
        if (thisValues == null) {
            return other;
        }
        int[] otherValues = other.values;
        if (otherValues == null) {
            return this;
        }
        int newLength = thisValues.length;
        for (int index = 0; index < otherValues.length; ++index) {
            if (this.contains(otherValues[index])) continue;
            ++newLength;
        }
        if (newLength == otherValues.length) {
            return other;
        }
        if (newLength == this.values.length && otherValues.length == 1 && thisValues[thisValues.length - 1] == otherValues[0]) {
            return this;
        }
        int newIndex = 0;
        int[] newValues = new int[newLength];
        if (newLength == thisValues.length + otherValues.length) {
            System.arraycopy(thisValues, 0, newValues, 0, thisValues.length);
            newIndex = thisValues.length;
        } else {
            for (int index = 0; index < thisValues.length; ++index) {
                if (other.contains(thisValues[index])) continue;
                newValues[newIndex++] = thisValues[index];
            }
        }
        System.arraycopy(otherValues, 0, newValues, newIndex, otherValues.length);
        return new InstructionOffsetValue(newValues);
    }

    public final InstructionOffsetValue instructionOffsetValue() {
        return this;
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean isParticular() {
        return true;
    }

    public final Value generalize(Value other) {
        return this.generalize(other.instructionOffsetValue());
    }

    public final int computationalType() {
        return 6;
    }

    public final String internalType() {
        return String.valueOf('I');
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        InstructionOffsetValue other = (InstructionOffsetValue)object;
        if (this.values == other.values) {
            return true;
        }
        if (this.values == null || other.values == null || this.values.length != other.values.length) {
            return false;
        }
        for (int index = 0; index < other.values.length; ++index) {
            if (this.contains(other.values[index])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.getClass().hashCode();
        if (this.values != null) {
            for (int index = 0; index < this.values.length; ++index) {
                hashCode ^= this.values[index];
            }
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.values != null) {
            for (int index = 0; index < this.values.length; ++index) {
                if (index > 0) {
                    buffer.append(',');
                }
                buffer.append(this.values[index]);
            }
        }
        return buffer.append(':').toString();
    }
}

