/*
 * Decompiled with CFR 0.152.
 */
package name.jervyshi.nacos.infra;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosVersionGetter {
    public static final String NACOS_LATEST_URL = "https://api.github.com/repos/alibaba/nacos/releases/latest";
    private static final Logger logger = LoggerFactory.getLogger(NacosVersionGetter.class);

    public static String getLatestVersion() {
        try {
            String line;
            StringBuilder result = new StringBuilder();
            URL url = new URL(NACOS_LATEST_URL);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.addRequestProperty("User-Agent", "nacos embedded version getter");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            rd.close();
            JSONObject jsonObject = JSON.parseObject((String)result.toString());
            return String.valueOf(jsonObject.get((Object)"tag_name"));
        }
        catch (Exception e) {
            logger.error("get nacos lastest version failed", (Throwable)e);
            return null;
        }
    }
}

