/*
 * Decompiled with CFR 0.152.
 */
package name.jervyshi.nacos;

import name.jervyshi.nacos.NacosPorts;
import name.jervyshi.nacos.infra.NacosWaiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosProcess
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(NacosProcess.class);
    private String host;
    private NacosPorts nacosPorts;
    private Process process;

    NacosProcess(String host, NacosPorts nacosPorts, Process process) {
        this.host = host;
        this.nacosPorts = nacosPorts;
        this.process = process;
    }

    @Override
    public void close() throws Exception {
        logger.info("Stopping nacos server");
        this.process.destroy();
        if (new NacosWaiter(this.host, this.nacosPorts.getServerPort()).avoidUntilNacosServerStopped()) {
            logger.info("Stopped nacos server");
        } else {
            logger.warn("Can not stop nacos server");
        }
    }

    public int getServerPort() {
        return this.nacosPorts.getServerPort();
    }

    public String getHost() {
        return this.host;
    }
}

