/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.activemq;

import java.io.Closeable;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.transport.TransportListener;
import zipkin2.CheckResult;

final class ActiveMQConn
implements TransportListener,
Closeable {
    static final CheckResult CLOSED = CheckResult.failed((Throwable)new IllegalStateException("Collector intentionally closed"));
    static final CheckResult INTERRUPTION = CheckResult.failed((Throwable)new IOException("Recoverable error on ActiveMQ connection"));
    final ActiveMQConnection connection;
    final QueueSession session;
    final QueueSender sender;
    volatile CheckResult checkResult = CheckResult.OK;

    ActiveMQConn(ActiveMQConnection connection, QueueSession session, QueueSender sender) {
        this.connection = connection;
        this.session = session;
        this.sender = sender;
        connection.addTransportListener((TransportListener)this);
    }

    public void onCommand(Object o) {
    }

    public void onException(IOException error) {
        this.checkResult = CheckResult.failed((Throwable)error);
    }

    public void transportInterupted() {
        this.checkResult = INTERRUPTION;
    }

    public void transportResumed() {
        this.checkResult = CheckResult.OK;
    }

    @Override
    public void close() {
        if (this.checkResult == CLOSED) {
            return;
        }
        this.checkResult = CLOSED;
        this.connection.removeTransportListener((TransportListener)this);
        try {
            this.sender.close();
            this.session.close();
            this.connection.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

