/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.Span;
import brave.Tracer;
import brave.internal.Nullable;
import brave.kafka.clients.KafkaProducerRequest;
import brave.kafka.clients.KafkaTracing;
import brave.kafka.clients.TracingCallback;
import brave.messaging.MessagingRequest;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;

final class TracingProducer<K, V>
implements Producer<K, V> {
    final Producer<K, V> delegate;
    final KafkaTracing kafkaTracing;
    final CurrentTraceContext currentTraceContext;
    final Tracer tracer;
    final TraceContext.Extractor<KafkaProducerRequest> extractor;
    final SamplerFunction<MessagingRequest> sampler;
    final TraceContext.Injector<KafkaProducerRequest> injector;
    @Nullable
    final String remoteServiceName;

    TracingProducer(Producer<K, V> delegate, KafkaTracing kafkaTracing) {
        this.delegate = delegate;
        this.kafkaTracing = kafkaTracing;
        this.currentTraceContext = kafkaTracing.messagingTracing.tracing().currentTraceContext();
        this.tracer = kafkaTracing.messagingTracing.tracing().tracer();
        this.extractor = kafkaTracing.producerExtractor;
        this.sampler = kafkaTracing.producerSampler;
        this.injector = kafkaTracing.producerInjector;
        this.remoteServiceName = kafkaTracing.remoteServiceName;
    }

    public void initTransactions() {
        this.delegate.initTransactions();
    }

    public void beginTransaction() {
        this.delegate.beginTransaction();
    }

    public void commitTransaction() {
        this.delegate.commitTransaction();
    }

    public void abortTransaction() {
        this.delegate.abortTransaction();
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.send(record, null);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record, @Nullable Callback callback) {
        Span span;
        KafkaProducerRequest request = new KafkaProducerRequest(record);
        TraceContext maybeParent = this.currentTraceContext.get();
        if (maybeParent == null) {
            TraceContextOrSamplingFlags extracted = this.kafkaTracing.extractAndClearHeaders(this.extractor, request, record.headers());
            span = this.kafkaTracing.nextMessagingSpan(this.sampler, (MessagingRequest)request, extracted);
        } else {
            span = this.tracer.newChild(maybeParent);
        }
        if (!span.isNoop()) {
            span.kind(Span.Kind.PRODUCER).name("send");
            if (this.remoteServiceName != null) {
                span.remoteServiceName(this.remoteServiceName);
            }
            if (record.key() instanceof String && !"".equals(record.key())) {
                span.tag("kafka.key", record.key().toString());
            }
            span.tag("kafka.topic", record.topic());
            span.start();
        }
        this.injector.inject(span.context(), (Object)request);
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        Throwable error = null;
        try {
            Future future = this.delegate.send(record, TracingCallback.create(callback, span, this.currentTraceContext));
            return future;
        }
        catch (Error | RuntimeException e) {
            error = e;
            throw e;
        }
        finally {
            if (error != null) {
                span.error(error).finish();
            }
            ws.close();
        }
    }

    public void flush() {
        this.delegate.flush();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.delegate.partitionsFor(topic);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    public void close() {
        this.delegate.close();
    }

    public void close(long timeout, TimeUnit unit) {
        this.delegate.close(timeout, unit);
    }

    public void close(Duration duration) {
        this.delegate.close(duration);
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) {
        this.delegate.sendOffsetsToTransaction(offsets, consumerGroupId);
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        this.delegate.sendOffsetsToTransaction(offsets, groupMetadata);
    }
}

