/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.ephemeral.distro.v2;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.EventPublisherFactory;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.core.distributed.distro.DistroProtocol;
import com.alibaba.nacos.core.distributed.distro.component.DistroDataProcessor;
import com.alibaba.nacos.core.distributed.distro.component.DistroDataStorage;
import com.alibaba.nacos.core.distributed.distro.entity.DistroData;
import com.alibaba.nacos.core.distributed.distro.entity.DistroKey;
import com.alibaba.nacos.naming.cluster.transport.Serializer;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.v2.DistroClientVerifyInfo;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.ClientSyncData;
import com.alibaba.nacos.naming.core.v2.client.ClientSyncDatumSnapshot;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.event.client.ClientEvent;
import com.alibaba.nacos.naming.core.v2.event.client.ClientOperationEvent;
import com.alibaba.nacos.naming.core.v2.event.publisher.NamingEventPublisherFactory;
import com.alibaba.nacos.naming.core.v2.pojo.BatchInstanceData;
import com.alibaba.nacos.naming.core.v2.pojo.BatchInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.upgrade.UpgradeJudgement;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class DistroClientDataProcessor
extends SmartSubscriber
implements DistroDataStorage,
DistroDataProcessor {
    public static final String TYPE = "Nacos:Naming:v2:ClientData";
    private final ClientManager clientManager;
    private final DistroProtocol distroProtocol;
    private final UpgradeJudgement upgradeJudgement;
    private volatile boolean isFinishInitial;

    public DistroClientDataProcessor(ClientManager clientManager, DistroProtocol distroProtocol, UpgradeJudgement upgradeJudgement) {
        this.clientManager = clientManager;
        this.distroProtocol = distroProtocol;
        this.upgradeJudgement = upgradeJudgement;
        NotifyCenter.registerSubscriber((Subscriber)this, (EventPublisherFactory)NamingEventPublisherFactory.getInstance());
    }

    public void finishInitial() {
        this.isFinishInitial = true;
    }

    public boolean isFinishInitial() {
        return this.isFinishInitial;
    }

    public List<Class<? extends Event>> subscribeTypes() {
        LinkedList<Class<? extends Event>> result = new LinkedList<Class<? extends Event>>();
        result.add(ClientEvent.ClientChangedEvent.class);
        result.add(ClientEvent.ClientDisconnectEvent.class);
        result.add(ClientEvent.ClientVerifyFailedEvent.class);
        return result;
    }

    public void onEvent(Event event) {
        if (EnvUtil.getStandaloneMode()) {
            return;
        }
        if (!this.upgradeJudgement.isUseGrpcFeatures()) {
            return;
        }
        if (event instanceof ClientEvent.ClientVerifyFailedEvent) {
            this.syncToVerifyFailedServer((ClientEvent.ClientVerifyFailedEvent)event);
        } else {
            this.syncToAllServer((ClientEvent)event);
        }
    }

    private void syncToVerifyFailedServer(ClientEvent.ClientVerifyFailedEvent event) {
        Client client = this.clientManager.getClient(event.getClientId());
        if (null == client || !client.isEphemeral() || !this.clientManager.isResponsibleClient(client)) {
            return;
        }
        DistroKey distroKey = new DistroKey(client.getClientId(), TYPE);
        this.distroProtocol.syncToTarget(distroKey, DataOperation.ADD, event.getTargetServer(), 0L);
    }

    private void syncToAllServer(ClientEvent event) {
        Client client = event.getClient();
        if (null == client || !client.isEphemeral() || !this.clientManager.isResponsibleClient(client)) {
            return;
        }
        if (event instanceof ClientEvent.ClientDisconnectEvent) {
            DistroKey distroKey = new DistroKey(client.getClientId(), TYPE);
            this.distroProtocol.sync(distroKey, DataOperation.DELETE);
        } else if (event instanceof ClientEvent.ClientChangedEvent) {
            DistroKey distroKey = new DistroKey(client.getClientId(), TYPE);
            this.distroProtocol.sync(distroKey, DataOperation.CHANGE);
        }
    }

    public String processType() {
        return TYPE;
    }

    public boolean processData(DistroData distroData) {
        switch (distroData.getType()) {
            case ADD: 
            case CHANGE: {
                ClientSyncData clientSyncData = ((Serializer)ApplicationUtils.getBean(Serializer.class)).deserialize(distroData.getContent(), ClientSyncData.class);
                this.handlerClientSyncData(clientSyncData);
                return true;
            }
            case DELETE: {
                String deleteClientId = distroData.getDistroKey().getResourceKey();
                Loggers.DISTRO.info("[Client-Delete] Received distro client sync data {}", (Object)deleteClientId);
                this.clientManager.clientDisconnected(deleteClientId);
                return true;
            }
        }
        return false;
    }

    private void handlerClientSyncData(ClientSyncData clientSyncData) {
        Loggers.DISTRO.info("[Client-Add] Received distro client sync data {}", (Object)clientSyncData.getClientId());
        this.clientManager.syncClientConnected(clientSyncData.getClientId(), clientSyncData.getAttributes());
        Client client = this.clientManager.getClient(clientSyncData.getClientId());
        this.upgradeClient(client, clientSyncData);
    }

    private void upgradeClient(Client client, ClientSyncData clientSyncData) {
        HashSet<Service> syncedService = new HashSet<Service>();
        DistroClientDataProcessor.processBatchInstanceDistroData(syncedService, client, clientSyncData);
        List<String> namespaces = clientSyncData.getNamespaces();
        List<String> groupNames = clientSyncData.getGroupNames();
        List<String> serviceNames = clientSyncData.getServiceNames();
        List<InstancePublishInfo> instances = clientSyncData.getInstancePublishInfos();
        for (int i = 0; i < namespaces.size(); ++i) {
            Service service = Service.newService(namespaces.get(i), groupNames.get(i), serviceNames.get(i));
            Service singleton = ServiceManager.getInstance().getSingleton(service);
            syncedService.add(singleton);
            InstancePublishInfo instancePublishInfo = instances.get(i);
            if (instancePublishInfo.equals(client.getInstancePublishInfo(singleton))) continue;
            client.addServiceInstance(singleton, instancePublishInfo);
            NotifyCenter.publishEvent((Event)new ClientOperationEvent.ClientRegisterServiceEvent(singleton, client.getClientId()));
        }
        for (Service each : client.getAllPublishedService()) {
            if (syncedService.contains(each)) continue;
            client.removeServiceInstance(each);
            NotifyCenter.publishEvent((Event)new ClientOperationEvent.ClientDeregisterServiceEvent(each, client.getClientId()));
        }
    }

    private static void processBatchInstanceDistroData(Set<Service> syncedService, Client client, ClientSyncData clientSyncData) {
        BatchInstanceData batchInstanceData = clientSyncData.getBatchInstanceData();
        if (batchInstanceData == null || CollectionUtils.isEmpty(batchInstanceData.getNamespaces())) {
            Loggers.DISTRO.info("[processBatchInstanceDistroData] BatchInstanceData is null , clientId is :{}", (Object)client.getClientId());
            return;
        }
        List<String> namespaces = batchInstanceData.getNamespaces();
        List<String> groupNames = batchInstanceData.getGroupNames();
        List<String> serviceNames = batchInstanceData.getServiceNames();
        List<BatchInstancePublishInfo> batchInstancePublishInfos = batchInstanceData.getBatchInstancePublishInfos();
        for (int i = 0; i < namespaces.size(); ++i) {
            Service service = Service.newService(namespaces.get(i), groupNames.get(i), serviceNames.get(i));
            Service singleton = ServiceManager.getInstance().getSingleton(service);
            syncedService.add(singleton);
            BatchInstancePublishInfo batchInstancePublishInfo = batchInstancePublishInfos.get(i);
            BatchInstancePublishInfo targetInstanceInfo = (BatchInstancePublishInfo)client.getInstancePublishInfo(singleton);
            boolean result = false;
            if (targetInstanceInfo != null) {
                result = batchInstancePublishInfo.equals(targetInstanceInfo);
            }
            if (result) continue;
            client.addServiceInstance(service, batchInstancePublishInfo);
            NotifyCenter.publishEvent((Event)new ClientOperationEvent.ClientRegisterServiceEvent(singleton, client.getClientId()));
        }
    }

    public boolean processVerifyData(DistroData distroData, String sourceAddress) {
        DistroClientVerifyInfo verifyData = ((Serializer)ApplicationUtils.getBean(Serializer.class)).deserialize(distroData.getContent(), DistroClientVerifyInfo.class);
        if (this.clientManager.verifyClient(verifyData.getClientId())) {
            return true;
        }
        Loggers.DISTRO.info("client {} is invalid, get new client from {}", (Object)verifyData.getClientId(), (Object)sourceAddress);
        return false;
    }

    public boolean processSnapshot(DistroData distroData) {
        ClientSyncDatumSnapshot snapshot = ((Serializer)ApplicationUtils.getBean(Serializer.class)).deserialize(distroData.getContent(), ClientSyncDatumSnapshot.class);
        for (ClientSyncData each : snapshot.getClientSyncDataList()) {
            this.handlerClientSyncData(each);
        }
        return true;
    }

    public DistroData getDistroData(DistroKey distroKey) {
        Client client = this.clientManager.getClient(distroKey.getResourceKey());
        if (null == client) {
            return null;
        }
        byte[] data = ((Serializer)ApplicationUtils.getBean(Serializer.class)).serialize(client.generateSyncData());
        return new DistroData(distroKey, data);
    }

    public DistroData getDatumSnapshot() {
        LinkedList<ClientSyncData> datum = new LinkedList<ClientSyncData>();
        for (String each : this.clientManager.allClientId()) {
            Client client = this.clientManager.getClient(each);
            if (null == client || !client.isEphemeral()) continue;
            datum.add(client.generateSyncData());
        }
        ClientSyncDatumSnapshot snapshot = new ClientSyncDatumSnapshot();
        snapshot.setClientSyncDataList(datum);
        byte[] data = ((Serializer)ApplicationUtils.getBean(Serializer.class)).serialize(snapshot);
        return new DistroData(new DistroKey(DataOperation.SNAPSHOT.name(), TYPE), data);
    }

    public List<DistroData> getVerifyData() {
        LinkedList<DistroData> result = new LinkedList<DistroData>();
        for (String each : this.clientManager.allClientId()) {
            Client client = this.clientManager.getClient(each);
            if (null == client || !client.isEphemeral() || !this.clientManager.isResponsibleClient(client)) continue;
            DistroClientVerifyInfo verifyData = new DistroClientVerifyInfo(client.getClientId(), 0L);
            DistroKey distroKey = new DistroKey(client.getClientId(), TYPE);
            DistroData data = new DistroData(distroKey, ((Serializer)ApplicationUtils.getBean(Serializer.class)).serialize(verifyData));
            data.setType(DataOperation.VERIFY);
            result.add(data);
        }
        return result;
    }
}

