/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.notify;

import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.config.server.service.notify.NotifyTask;
import com.alibaba.nacos.config.server.service.notify.NotifyTaskProcessor;
import com.alibaba.nacos.config.server.utils.LogUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class NotifySingleService {
    private static final Logger LOGGER = LogUtil.FATAL_LOG;

    static class NotifySingleTask
    extends NotifyTask
    implements Runnable {
        private static final NotifyTaskProcessorWrapper PROCESSOR = new NotifyTaskProcessorWrapper();
        private final Executor executor;
        private final String target;
        private boolean isSuccess = false;

        public NotifySingleTask(String dataId, String group, String tenant, long lastModified, String target, Executor executor) {
            super(dataId, group, tenant, lastModified);
            this.target = target;
            this.executor = executor;
        }

        @Override
        public void run() {
            try {
                this.isSuccess = PROCESSOR.process((NacosTask)this);
            }
            catch (Exception e) {
                this.isSuccess = false;
                LogUtil.NOTIFY_LOG.error("[notify-exception] target:{} dataid:{} group:{} ts:{}", new Object[]{this.target, this.getDataId(), this.getGroup(), this.getLastModified()});
                LogUtil.NOTIFY_LOG.debug("[notify-exception] target:{} dataid:{} group:{} ts:{}", new Object[]{this.target, this.getDataId(), this.getGroup(), this.getLastModified(), e});
            }
            if (!this.isSuccess) {
                LogUtil.NOTIFY_LOG.error("[notify-retry] target:{} dataid:{} group:{} ts:{}", new Object[]{this.target, this.getDataId(), this.getGroup(), this.getLastModified()});
                try {
                    ((ScheduledThreadPoolExecutor)this.executor).schedule(this, 500L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    LOGGER.warn("[notify-thread-pool] cluster remove node {}, current thread was tear down.", (Object)this.target, (Object)e);
                }
            }
        }
    }

    static class NotifyTaskProcessorWrapper
    extends NotifyTaskProcessor {
        public NotifyTaskProcessorWrapper() {
            super(null);
        }

        @Override
        public boolean process(NacosTask task) {
            NotifySingleTask notifyTask = (NotifySingleTask)task;
            return this.notifyToDump(notifyTask.getDataId(), notifyTask.getGroup(), notifyTask.getTenant(), notifyTask.getLastModified(), notifyTask.target);
        }
    }
}

