/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.spring.initializr.generator.version.VersionParser;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.DependencyGroup;
import io.spring.initializr.metadata.ServiceCapability;
import io.spring.initializr.metadata.ServiceCapabilityType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DependenciesCapability
extends ServiceCapability<List<DependencyGroup>> {
    final List<DependencyGroup> content = new ArrayList<DependencyGroup>();
    @JsonIgnore
    private final Map<String, Dependency> indexedDependencies = new LinkedHashMap<String, Dependency>();

    public DependenciesCapability() {
        super("dependencies", ServiceCapabilityType.HIERARCHICAL_MULTI_SELECT, "Project dependencies", "dependency identifiers (comma-separated)");
    }

    @Override
    public List<DependencyGroup> getContent() {
        return this.content;
    }

    public Dependency get(String id) {
        return this.indexedDependencies.get(id);
    }

    public Collection<Dependency> getAll() {
        return Collections.unmodifiableCollection(this.indexedDependencies.values().stream().distinct().collect(Collectors.toList()));
    }

    public void validate() {
        this.index();
    }

    public void updateCompatibilityRange(VersionParser versionParser) {
        this.indexedDependencies.values().forEach(it -> it.updateCompatibilityRange(versionParser));
    }

    @Override
    public void merge(List<DependencyGroup> otherContent) {
        otherContent.forEach(group -> {
            if (this.content.stream().noneMatch(it -> group.getName() != null && group.getName().equals(it.getName()))) {
                this.content.add((DependencyGroup)group);
            }
        });
        this.index();
    }

    private void index() {
        this.indexedDependencies.clear();
        this.content.forEach(group -> group.content.forEach(dependency -> {
            if (dependency.getCompatibilityRange() == null && group.getCompatibilityRange() != null) {
                dependency.setCompatibilityRange(group.getCompatibilityRange());
            }
            if (dependency.getBom() == null && group.getBom() != null) {
                dependency.setBom(group.getBom());
            }
            if (dependency.getRepository() == null && group.getRepository() != null) {
                dependency.setRepository(group.getRepository());
            }
            dependency.resolve();
            this.indexDependency(dependency.getId(), (Dependency)dependency);
            for (String alias : dependency.getAliases()) {
                this.indexDependency(alias, (Dependency)dependency);
            }
        }));
    }

    private void indexDependency(String id, Dependency dependency) {
        Dependency existing = this.indexedDependencies.get(id);
        if (existing != null) {
            throw new IllegalArgumentException("Could not register " + dependency + " another dependency has also the '" + id + "' id " + existing);
        }
        this.indexedDependencies.put(id, dependency);
    }
}

