/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.io.template;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.spring.initializr.generator.io.template.TemplateRenderer;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import org.springframework.cache.Cache;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class MustacheTemplateRenderer
implements TemplateRenderer {
    private final Mustache.Compiler mustache;
    private final Function<String, String> keyGenerator;
    private final Cache templateCache;

    public MustacheTemplateRenderer(String resourcePrefix, Cache templateCache) {
        Object prefix = resourcePrefix.endsWith("/") ? resourcePrefix : resourcePrefix + "/";
        this.mustache = Mustache.compiler().withLoader(MustacheTemplateRenderer.mustacheTemplateLoader((String)prefix)).escapeHTML(false);
        this.keyGenerator = arg_0 -> MustacheTemplateRenderer.lambda$new$0((String)prefix, arg_0);
        this.templateCache = templateCache;
    }

    public MustacheTemplateRenderer(String resourcePrefix) {
        this(resourcePrefix, null);
    }

    private static Mustache.TemplateLoader mustacheTemplateLoader(String prefix) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        return arg_0 -> MustacheTemplateRenderer.lambda$mustacheTemplateLoader$1(prefix, (ResourceLoader)resourceLoader, arg_0);
    }

    @Override
    public String render(String templateName, Map<String, ?> model) {
        Template template = this.getTemplate(templateName);
        return template.execute(model);
    }

    private Template getTemplate(String name) {
        try {
            if (this.templateCache != null) {
                try {
                    return (Template)this.templateCache.get((Object)this.keyGenerator.apply(name), () -> this.loadTemplate(name));
                }
                catch (Cache.ValueRetrievalException ex) {
                    throw ex.getCause();
                }
            }
            return this.loadTemplate(name);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Cannot load template " + name, ex);
        }
    }

    private Template loadTemplate(String name) throws Exception {
        Reader template = this.mustache.loader.getTemplate(name);
        return this.mustache.compile(template);
    }

    private static /* synthetic */ Reader lambda$mustacheTemplateLoader$1(String prefix, ResourceLoader resourceLoader, String name) throws Exception {
        String location = prefix + name + ".mustache";
        return new InputStreamReader(resourceLoader.getResource(location).getInputStream(), StandardCharsets.UTF_8);
    }

    private static /* synthetic */ String lambda$new$0(String prefix, String name) {
        return String.format("%s%s", prefix, name);
    }
}

