/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.container.docker.compose;

import io.spring.initializr.generator.container.docker.compose.ComposeService;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ComposeServiceContainer {
    private final Map<String, ComposeService.Builder> services = new LinkedHashMap<String, ComposeService.Builder>();

    public boolean isEmpty() {
        return this.services.isEmpty();
    }

    public boolean has(String name) {
        return this.services.containsKey(name);
    }

    public Stream<ComposeService> values() {
        return this.services.values().stream().map(ComposeService.Builder::build);
    }

    public void add(String name, Consumer<ComposeService.Builder> service) {
        service.accept(this.services.computeIfAbsent(name, ComposeService.Builder::new));
    }

    public boolean remove(String name) {
        return this.services.remove(name) != null;
    }
}

