/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.condition;

import io.spring.initializr.generator.condition.ConditionalOnPlatformVersion;
import io.spring.initializr.generator.condition.ProjectGenerationCondition;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.generator.version.VersionParser;
import java.util.Arrays;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnPlatformVersionCondition
extends ProjectGenerationCondition {
    OnPlatformVersionCondition() {
    }

    @Override
    protected boolean matches(ProjectDescription description, ConditionContext context, AnnotatedTypeMetadata metadata) {
        Version platformVersion = description.getPlatformVersion();
        if (platformVersion == null) {
            return false;
        }
        return Arrays.stream((String[])metadata.getAnnotationAttributes(ConditionalOnPlatformVersion.class.getName()).get("value")).anyMatch(range -> VersionParser.DEFAULT.parseRange((String)range).match(platformVersion));
    }
}

