/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.seata.common.DefaultValues;
import io.seata.core.rpc.TransportServerType;
import io.seata.core.rpc.netty.NettyBaseConfig;
import io.seata.core.rpc.netty.NettyPoolKey;

public class NettyClientConfig
extends NettyBaseConfig {
    private int connectTimeoutMillis = 10000;
    private int clientSocketSndBufSize = 153600;
    private int clientSocketRcvBufSize = 153600;
    private int clientWorkerThreads = WORKER_THREAD_SIZE;
    private final Class<? extends Channel> clientChannelClazz = CLIENT_CHANNEL_CLAZZ;
    private int perHostMaxConn = 2;
    private static final int PER_HOST_MIN_CONN = 2;
    private int pendingConnSize = Integer.MAX_VALUE;
    private static final long RPC_RM_REQUEST_TIMEOUT = CONFIG.getLong("transport.rpcRmRequestTimeout", DefaultValues.DEFAULT_RPC_RM_REQUEST_TIMEOUT);
    private static final long RPC_TM_REQUEST_TIMEOUT = CONFIG.getLong("transport.rpcTmRequestTimeout", DefaultValues.DEFAULT_RPC_TM_REQUEST_TIMEOUT);
    private static String vgroup;
    private static String clientAppName;
    private static int clientType;
    private static int maxInactiveChannelCheck;
    private static final int MAX_NOT_WRITEABLE_RETRY = 2000;
    private static final int MAX_CHECK_ALIVE_RETRY = 300;
    private static final int CHECK_ALIVE_INTERVAL = 10;
    private static final String SOCKET_ADDRESS_START_CHAR = "/";
    private static final long MAX_ACQUIRE_CONN_MILLS = 60000L;
    private static final String RPC_DISPATCH_THREAD_PREFIX = "rpcDispatch";
    private static final int DEFAULT_MAX_POOL_ACTIVE = 1;
    private static final int DEFAULT_MIN_POOL_IDLE = 0;
    private static final boolean DEFAULT_POOL_TEST_BORROW = true;
    private static final boolean DEFAULT_POOL_TEST_RETURN = true;
    private static final boolean DEFAULT_POOL_LIFO = true;
    private static final boolean ENABLE_CLIENT_BATCH_SEND_REQUEST;

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public int getClientSocketSndBufSize() {
        return this.clientSocketSndBufSize;
    }

    public void setClientSocketSndBufSize(int clientSocketSndBufSize) {
        this.clientSocketSndBufSize = clientSocketSndBufSize;
    }

    public int getClientSocketRcvBufSize() {
        return this.clientSocketRcvBufSize;
    }

    public void setClientSocketRcvBufSize(int clientSocketRcvBufSize) {
        this.clientSocketRcvBufSize = clientSocketRcvBufSize;
    }

    public int getChannelMaxWriteIdleSeconds() {
        return MAX_WRITE_IDLE_SECONDS;
    }

    public int getChannelMaxReadIdleSeconds() {
        return MAX_READ_IDLE_SECONDS;
    }

    public int getChannelMaxAllIdleSeconds() {
        return 0;
    }

    public int getClientWorkerThreads() {
        return this.clientWorkerThreads;
    }

    public void setClientWorkerThreads(int clientWorkerThreads) {
        this.clientWorkerThreads = clientWorkerThreads;
    }

    public Class<? extends Channel> getClientChannelClazz() {
        return this.clientChannelClazz;
    }

    public boolean enableNative() {
        return TRANSPORT_SERVER_TYPE == TransportServerType.NATIVE;
    }

    public int getPerHostMaxConn() {
        return this.perHostMaxConn;
    }

    public void setPerHostMaxConn(int perHostMaxConn) {
        this.perHostMaxConn = perHostMaxConn > 2 ? perHostMaxConn : 2;
    }

    public int getPendingConnSize() {
        return this.pendingConnSize;
    }

    public void setPendingConnSize(int pendingConnSize) {
        this.pendingConnSize = pendingConnSize;
    }

    public static long getRpcRmRequestTimeout() {
        return RPC_RM_REQUEST_TIMEOUT;
    }

    public static long getRpcTmRequestTimeout() {
        return RPC_TM_REQUEST_TIMEOUT;
    }

    public static String getVgroup() {
        return vgroup;
    }

    public static void setVgroup(String vgroup) {
        NettyClientConfig.vgroup = vgroup;
    }

    public static String getClientAppName() {
        return clientAppName;
    }

    public static void setClientAppName(String clientAppName) {
        NettyClientConfig.clientAppName = clientAppName;
    }

    public static int getClientType() {
        return clientType;
    }

    public static void setClientType(int clientType) {
        NettyClientConfig.clientType = clientType;
    }

    public static int getMaxInactiveChannelCheck() {
        return maxInactiveChannelCheck;
    }

    public static int getMaxNotWriteableRetry() {
        return 2000;
    }

    public static int getPerHostMinConn() {
        return 2;
    }

    public static int getMaxCheckAliveRetry() {
        return 300;
    }

    public static int getCheckAliveInterval() {
        return 10;
    }

    public static String getSocketAddressStartChar() {
        return SOCKET_ADDRESS_START_CHAR;
    }

    public int getClientSelectorThreadSize() {
        return CONFIG.getInt("transport.threadFactory.clientSelectorThreadSize", 1);
    }

    public long getMaxAcquireConnMills() {
        return 60000L;
    }

    public String getClientSelectorThreadPrefix() {
        return CONFIG.getConfig("transport.threadFactory.clientSelectorThreadPrefix", "NettyClientSelector");
    }

    public String getClientWorkerThreadPrefix() {
        return CONFIG.getConfig("transport.threadFactory.clientWorkerThreadPrefix", "NettyClientWorkerThread");
    }

    public String getRpcDispatchThreadPrefix() {
        return RPC_DISPATCH_THREAD_PREFIX;
    }

    public int getMaxPoolActive() {
        return 1;
    }

    public int getMinPoolIdle() {
        return 0;
    }

    public boolean isPoolTestBorrow() {
        return true;
    }

    public boolean isPoolTestReturn() {
        return true;
    }

    public boolean isPoolLifo() {
        return true;
    }

    public String getTmDispatchThreadPrefix() {
        return "rpcDispatch_" + NettyPoolKey.TransactionRole.TMROLE.name();
    }

    public String getRmDispatchThreadPrefix() {
        return "rpcDispatch_" + NettyPoolKey.TransactionRole.RMROLE.name();
    }

    @Deprecated
    public static boolean isEnableClientBatchSendRequest() {
        return ENABLE_CLIENT_BATCH_SEND_REQUEST;
    }

    static {
        maxInactiveChannelCheck = 10;
        ENABLE_CLIENT_BATCH_SEND_REQUEST = CONFIG.getBoolean("transport.enableClientBatchSendRequest", true);
    }
}

