/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.log4j.contextdata.v2_17;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.instrumentation.log4j.contextdata.v2_17.internal.ContextDataKeys;
import io.opentelemetry.javaagent.bootstrap.internal.ConfiguredResourceAttributesHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.util.ContextDataProvider;

public class OpenTelemetryContextDataProvider
implements ContextDataProvider {
    private static final boolean BAGGAGE_ENABLED = ConfigPropertiesUtil.getBoolean((String)"otel.instrumentation.log4j-context-data.add-baggage", (boolean)false);
    private static final boolean configuredResourceAttributeAccessible = OpenTelemetryContextDataProvider.isConfiguredResourceAttributeAccessible();
    private static final Map<String, String> staticContextData = OpenTelemetryContextDataProvider.getStaticContextData();

    private static Map<String, String> getStaticContextData() {
        if (configuredResourceAttributeAccessible) {
            return ConfiguredResourceAttributesHolder.getResourceAttributes();
        }
        return Collections.emptyMap();
    }

    private static boolean isConfiguredResourceAttributeAccessible() {
        try {
            Class.forName("io.opentelemetry.javaagent.bootstrap.internal.ConfiguredResourceAttributesHolder");
            return true;
        }
        catch (ClassNotFoundException ok) {
            return false;
        }
    }

    public Map<String, String> supplyContextData() {
        Context context = Context.current();
        Span currentSpan = Span.fromContext((Context)context);
        if (!currentSpan.getSpanContext().isValid()) {
            return staticContextData;
        }
        HashMap<String, String> contextData = new HashMap<String, String>(staticContextData);
        SpanContext spanContext = currentSpan.getSpanContext();
        contextData.put(ContextDataKeys.TRACE_ID_KEY, spanContext.getTraceId());
        contextData.put(ContextDataKeys.SPAN_ID_KEY, spanContext.getSpanId());
        contextData.put(ContextDataKeys.TRACE_FLAGS_KEY, spanContext.getTraceFlags().asHex());
        if (BAGGAGE_ENABLED) {
            Baggage baggage = Baggage.fromContext((Context)context);
            for (Map.Entry entry : baggage.asMap().entrySet()) {
                contextData.put("baggage." + (String)entry.getKey(), ((BaggageEntry)entry.getValue()).getValue());
            }
        }
        return contextData;
    }
}

