/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.vector.service;

import com.alibaba.fastjson2.JSON;
import io.github.lnyocly.ai4j.config.PineconeConfig;
import io.github.lnyocly.ai4j.exception.CommonException;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.vector.VertorDataEntity;
import io.github.lnyocly.ai4j.vector.pinecone.PineconeDelete;
import io.github.lnyocly.ai4j.vector.pinecone.PineconeInsert;
import io.github.lnyocly.ai4j.vector.pinecone.PineconeInsertResponse;
import io.github.lnyocly.ai4j.vector.pinecone.PineconeQuery;
import io.github.lnyocly.ai4j.vector.pinecone.PineconeQueryResponse;
import io.github.lnyocly.ai4j.vector.pinecone.PineconeVectors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PineconeService {
    private static final Logger log = LoggerFactory.getLogger(PineconeService.class);
    private final PineconeConfig pineconeConfig;
    private final OkHttpClient okHttpClient;

    public PineconeService(Configuration configuration) {
        this.pineconeConfig = configuration.getPineconeConfig();
        this.okHttpClient = configuration.getOkHttpClient();
    }

    public Integer insert(PineconeInsert pineconeInsertReq) {
        Integer n;
        block9: {
            Request request = new Request.Builder().url(this.pineconeConfig.getUrl() + this.pineconeConfig.getUpsert()).post(RequestBody.create((String)JSON.toJSONString((Object)pineconeInsertReq), (MediaType)MediaType.parse((String)"application/json"))).header("accept", "application/json").header("content-type", "application/json").header("Api-Key", this.pineconeConfig.getKey()).build();
            Response response = this.okHttpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    log.error("Error inserting into Pinecone vector store: {}", (Object)response.message());
                    throw new CommonException("Error inserting into Pinecone: " + response.message());
                }
                n = ((PineconeInsertResponse)JSON.parseObject((String)response.body().string(), PineconeInsertResponse.class)).getUpsertedCount();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("OkHttpClient exception! {}", (Object)e.getMessage(), (Object)e);
                    throw new CommonException("Failed to insert into Pinecone due to network error." + e.getMessage());
                }
            }
            response.close();
        }
        return n;
    }

    public Integer insert(VertorDataEntity vertorDataEntity, String namespace) {
        int count = vertorDataEntity.getContent().size();
        ArrayList<PineconeVectors> pineconeVectors = new ArrayList<PineconeVectors>();
        List<String> ids = this.generateIDs(count);
        List<Map<String, String>> metadatas = this.generateContent(vertorDataEntity.getContent());
        for (int i = 0; i < count; ++i) {
            pineconeVectors.add(new PineconeVectors(ids.get(i), vertorDataEntity.getVector().get(i), metadatas.get(i)));
        }
        PineconeInsert pineconeInsert = new PineconeInsert(pineconeVectors, namespace);
        return this.insert(pineconeInsert);
    }

    public PineconeQueryResponse query(PineconeQuery pineconeQueryReq) {
        PineconeQueryResponse pineconeQueryResponse;
        block9: {
            Request request = new Request.Builder().url(this.pineconeConfig.getUrl() + this.pineconeConfig.getQuery()).post(RequestBody.create((String)JSON.toJSONString((Object)pineconeQueryReq), (MediaType)MediaType.parse((String)"application/json"))).header("accept", "application/json").header("content-type", "application/json").header("Api-Key", this.pineconeConfig.getKey()).build();
            Response response = this.okHttpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    log.error("Error querying Pinecone vector store: {}", (Object)response.message());
                    throw new CommonException("Error querying Pinecone: " + response.message());
                }
                String body = response.body().string();
                pineconeQueryResponse = (PineconeQueryResponse)JSON.parseObject((String)body, PineconeQueryResponse.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("OkHttpClient exception! {}", (Object)e.getMessage(), (Object)e);
                    throw new CommonException("Failed to query Pinecone due to network error." + e.getMessage());
                }
            }
            response.close();
        }
        return pineconeQueryResponse;
    }

    public String query(PineconeQuery pineconeQuery, String delimiter) {
        PineconeQueryResponse queryResponse = this.query(pineconeQuery);
        if (delimiter == null) {
            delimiter = "";
        }
        return queryResponse.getMatches().stream().map(match -> match.getMetadata().get("content")).collect(Collectors.joining(delimiter));
    }

    public Boolean delete(PineconeDelete pineconeDeleteReq) {
        Boolean bl;
        block9: {
            Request request = new Request.Builder().url(this.pineconeConfig.getUrl() + this.pineconeConfig.getDelete()).post(RequestBody.create((String)JSON.toJSONString((Object)pineconeDeleteReq), (MediaType)MediaType.parse((String)"application/json"))).header("accept", "application/json").header("content-type", "application/json").header("Api-Key", this.pineconeConfig.getKey()).build();
            Response response = this.okHttpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    log.error("Error deleting from Pinecone vector store: {}", (Object)response.message());
                    throw new CommonException("Error deleting from Pinecone: " + response.message());
                }
                bl = true;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("OkHttpClient exception! {}", (Object)e.getMessage(), (Object)e);
                    throw new CommonException("Failed to delete from Pinecone due to network error." + e.getMessage());
                }
            }
            response.close();
        }
        return bl;
    }

    public List<String> generateIDs(int count) {
        ArrayList<String> ids = new ArrayList<String>();
        for (long i = 0L; i < (long)count; ++i) {
            ids.add("id_" + i);
        }
        return ids;
    }

    public List<Map<String, String>> generateContent(List<String> contents) {
        ArrayList<Map<String, String>> finalcontents = new ArrayList<Map<String, String>>();
        for (int i = 0; i < contents.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("content", contents.get(i));
            finalcontents.add(map);
        }
        return finalcontents;
    }
}

