/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.service.factor;

import io.github.lnyocly.ai4j.platform.deepseek.chat.DeepSeekChatService;
import io.github.lnyocly.ai4j.platform.hunyuan.chat.HunyuanChatService;
import io.github.lnyocly.ai4j.platform.lingyi.chat.LingyiChatService;
import io.github.lnyocly.ai4j.platform.moonshot.chat.MoonshotChatService;
import io.github.lnyocly.ai4j.platform.ollama.chat.OllamaAiChatService;
import io.github.lnyocly.ai4j.platform.openai.chat.OpenAiChatService;
import io.github.lnyocly.ai4j.platform.openai.embedding.OpenAiEmbeddingService;
import io.github.lnyocly.ai4j.platform.zhipu.chat.ZhipuChatService;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.IChatService;
import io.github.lnyocly.ai4j.service.IEmbeddingService;
import io.github.lnyocly.ai4j.service.PlatformType;
import io.github.lnyocly.ai4j.vector.service.PineconeService;

public class AiService {
    private final Configuration configuration;

    public AiService(Configuration configuration) {
        this.configuration = configuration;
    }

    public IChatService getChatService(PlatformType platform) {
        return this.createChatService(platform);
    }

    private IChatService createChatService(PlatformType platform) {
        switch (platform) {
            case OPENAI: {
                return new OpenAiChatService(this.configuration);
            }
            case ZHIPU: {
                return new ZhipuChatService(this.configuration);
            }
            case DEEPSEEK: {
                return new DeepSeekChatService(this.configuration);
            }
            case MOONSHOT: {
                return new MoonshotChatService(this.configuration);
            }
            case HUNYUAN: {
                return new HunyuanChatService(this.configuration);
            }
            case LINGYI: {
                return new LingyiChatService(this.configuration);
            }
            case OLLAMA: {
                return new OllamaAiChatService(this.configuration);
            }
        }
        throw new IllegalArgumentException("Unknown platform: " + (Object)((Object)platform));
    }

    public IEmbeddingService getEmbeddingService(PlatformType platform) {
        return this.createEmbeddingService(platform);
    }

    private IEmbeddingService createEmbeddingService(PlatformType platform) {
        switch (platform) {
            case OPENAI: {
                return new OpenAiEmbeddingService(this.configuration);
            }
        }
        throw new IllegalArgumentException("Unknown platform: " + (Object)((Object)platform));
    }

    public PineconeService getPineconeService() {
        return new PineconeService(this.configuration);
    }
}

