/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.openai.chat.entity;

import com.alibaba.fastjson2.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.lnyocly.ai4j.platform.openai.chat.enums.ChatMessageType;
import io.github.lnyocly.ai4j.platform.openai.tool.ToolCall;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChatMessage {
    private String content;
    private String role;
    private String name;
    private String refusal;
    @JsonProperty(value="tool_call_id")
    private String toolCallId;
    @JsonProperty(value="tool_calls")
    private List<ToolCall> toolCalls;

    public ChatMessage(String userMessage) {
        this.role = ChatMessageType.USER.getRole();
        this.content = userMessage;
    }

    public ChatMessage(ChatMessageType role, String message) {
        this.role = role.getRole();
        this.content = message;
    }

    public ChatMessage(String role, String message) {
        this.role = role;
        this.content = message;
    }

    public static ChatMessage withSystem(String content) {
        return new ChatMessage(ChatMessageType.SYSTEM, content);
    }

    public static ChatMessage withUser(String content) {
        return new ChatMessage(ChatMessageType.USER, content);
    }

    public static ChatMessage withUser(String content, String ... images) {
        return ChatMessage.builder().role(ChatMessageType.USER.getRole()).content(MultiModal.withMultiModal(content, images)).build();
    }

    public static ChatMessage withAssistant(String content) {
        return new ChatMessage(ChatMessageType.ASSISTANT, content);
    }

    public static ChatMessage withAssistant(List<ToolCall> toolCalls) {
        return ChatMessage.builder().role(ChatMessageType.ASSISTANT.getRole()).toolCalls(toolCalls).build();
    }

    public static ChatMessage withTool(String content, String toolCallId) {
        return ChatMessage.builder().role(ChatMessageType.TOOL.getRole()).content(content).toolCallId(toolCallId).build();
    }

    public static ChatMessageBuilder builder() {
        return new ChatMessageBuilder();
    }

    public String getContent() {
        return this.content;
    }

    public String getRole() {
        return this.role;
    }

    public String getName() {
        return this.name;
    }

    public String getRefusal() {
        return this.refusal;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRefusal(String refusal) {
        this.refusal = refusal;
    }

    @JsonProperty(value="tool_call_id")
    public void setToolCallId(String toolCallId) {
        this.toolCallId = toolCallId;
    }

    @JsonProperty(value="tool_calls")
    public void setToolCalls(List<ToolCall> toolCalls) {
        this.toolCalls = toolCalls;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$refusal = this.getRefusal();
        String other$refusal = other.getRefusal();
        if (this$refusal == null ? other$refusal != null : !this$refusal.equals(other$refusal)) {
            return false;
        }
        String this$toolCallId = this.getToolCallId();
        String other$toolCallId = other.getToolCallId();
        if (this$toolCallId == null ? other$toolCallId != null : !this$toolCallId.equals(other$toolCallId)) {
            return false;
        }
        List<ToolCall> this$toolCalls = this.getToolCalls();
        List<ToolCall> other$toolCalls = other.getToolCalls();
        return !(this$toolCalls == null ? other$toolCalls != null : !((Object)this$toolCalls).equals(other$toolCalls));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $refusal = this.getRefusal();
        result = result * 59 + ($refusal == null ? 43 : $refusal.hashCode());
        String $toolCallId = this.getToolCallId();
        result = result * 59 + ($toolCallId == null ? 43 : $toolCallId.hashCode());
        List<ToolCall> $toolCalls = this.getToolCalls();
        result = result * 59 + ($toolCalls == null ? 43 : ((Object)$toolCalls).hashCode());
        return result;
    }

    public String toString() {
        return "ChatMessage(content=" + this.getContent() + ", role=" + this.getRole() + ", name=" + this.getName() + ", refusal=" + this.getRefusal() + ", toolCallId=" + this.getToolCallId() + ", toolCalls=" + this.getToolCalls() + ")";
    }

    private ChatMessage() {
    }

    private ChatMessage(String content, String role, String name, String refusal, String toolCallId, List<ToolCall> toolCalls) {
        this.content = content;
        this.role = role;
        this.name = name;
        this.refusal = refusal;
        this.toolCallId = toolCallId;
        this.toolCalls = toolCalls;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class MultiModal {
        private String type = Type.access$100(Type.TEXT);
        private String text;
        @JsonProperty(value="image_url")
        private ImageUrl imageUrl;

        public static List<MultiModal> withMultiModal(String text, String ... imageUrl) {
            ArrayList<MultiModal> messages = new ArrayList<MultiModal>();
            messages.add(new MultiModal(Type.TEXT.getType(), text, null));
            for (String url : imageUrl) {
                messages.add(new MultiModal(Type.IMAGE_URL.getType(), null, new ImageUrl(url)));
            }
            return messages;
        }

        public static MultiModalBuilder builder() {
            return new MultiModalBuilder();
        }

        public String getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        public ImageUrl getImageUrl() {
            return this.imageUrl;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty(value="image_url")
        public void setImageUrl(ImageUrl imageUrl) {
            this.imageUrl = imageUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiModal)) {
                return false;
            }
            MultiModal other = (MultiModal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            ImageUrl this$imageUrl = this.getImageUrl();
            ImageUrl other$imageUrl = other.getImageUrl();
            return !(this$imageUrl == null ? other$imageUrl != null : !((Object)this$imageUrl).equals(other$imageUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MultiModal;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            ImageUrl $imageUrl = this.getImageUrl();
            result = result * 59 + ($imageUrl == null ? 43 : ((Object)$imageUrl).hashCode());
            return result;
        }

        public String toString() {
            return "ChatMessage.MultiModal(type=" + this.getType() + ", text=" + this.getText() + ", imageUrl=" + this.getImageUrl() + ")";
        }

        public MultiModal() {
        }

        public MultiModal(String type, String text, ImageUrl imageUrl) {
            this.type = type;
            this.text = text;
            this.imageUrl = imageUrl;
        }

        public static class MultiModalBuilder {
            private String type;
            private String text;
            private ImageUrl imageUrl;

            MultiModalBuilder() {
            }

            public MultiModalBuilder type(String type) {
                this.type = type;
                return this;
            }

            public MultiModalBuilder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="image_url")
            public MultiModalBuilder imageUrl(ImageUrl imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public MultiModal build() {
                return new MultiModal(this.type, this.text, this.imageUrl);
            }

            public String toString() {
                return "ChatMessage.MultiModal.MultiModalBuilder(type=" + this.type + ", text=" + this.text + ", imageUrl=" + this.imageUrl + ")";
            }
        }

        public static enum Type {
            TEXT("text", "\u6587\u672c\u7c7b\u578b"),
            IMAGE_URL("image_url", "\u56fe\u7247\u7c7b\u578b\uff0c\u53ef\u4ee5\u4e3aurl\u6216\u8005base64");

            private final String type;
            private final String info;

            public String getType() {
                return this.type;
            }

            public String getInfo() {
                return this.info;
            }

            private Type(String type, String info) {
                this.type = type;
                this.info = info;
            }

            static /* synthetic */ String access$100(Type x0) {
                return x0.type;
            }
        }

        public static class ImageUrl {
            private String url;

            public String getUrl() {
                return this.url;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ImageUrl)) {
                    return false;
                }
                ImageUrl other = (ImageUrl)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ImageUrl;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }

            public String toString() {
                return "ChatMessage.MultiModal.ImageUrl(url=" + this.getUrl() + ")";
            }

            public ImageUrl() {
            }

            public ImageUrl(String url) {
                this.url = url;
            }
        }
    }

    public static class ChatMessageBuilder {
        private String role;
        private String name;
        private String refusal;
        private String toolCallId;
        private List<ToolCall> toolCalls;
        private String content;

        public ChatMessageBuilder content(List<MultiModal> content) {
            this.content = JSON.toJSONString(content);
            return this;
        }

        public ChatMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        ChatMessageBuilder() {
        }

        public ChatMessageBuilder role(String role) {
            this.role = role;
            return this;
        }

        public ChatMessageBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChatMessageBuilder refusal(String refusal) {
            this.refusal = refusal;
            return this;
        }

        @JsonProperty(value="tool_call_id")
        public ChatMessageBuilder toolCallId(String toolCallId) {
            this.toolCallId = toolCallId;
            return this;
        }

        @JsonProperty(value="tool_calls")
        public ChatMessageBuilder toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        public ChatMessage build() {
            return new ChatMessage(this.content, this.role, this.name, this.refusal, this.toolCallId, this.toolCalls);
        }

        public String toString() {
            return "ChatMessage.ChatMessageBuilder(content=" + this.content + ", role=" + this.role + ", name=" + this.name + ", refusal=" + this.refusal + ", toolCallId=" + this.toolCallId + ", toolCalls=" + this.toolCalls + ")";
        }
    }
}

