/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.openai.chat.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatMessage;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.StreamOptions;
import io.github.lnyocly.ai4j.platform.openai.tool.Tool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChatCompletion {
    @NonNull
    private String model;
    @NonNull
    private List<ChatMessage> messages;
    private Boolean stream;
    @JsonProperty(value="stream_options")
    private StreamOptions streamOptions;
    @JsonProperty(value="frequency_penalty")
    private Float frequencyPenalty;
    private Float temperature;
    @JsonProperty(value="top_p")
    private Float topP;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    private List<Tool> tools;
    @JsonIgnore
    private List<String> functions;
    @JsonProperty(value="tool_choice")
    private String toolChoice;
    @JsonProperty(value="parallel_tool_calls")
    private Boolean parallelToolCalls;
    @JsonProperty(value="response_format")
    private Object responseFormat;
    private String user;
    private Integer n;
    private List<String> stop;
    @JsonProperty(value="presence_penalty")
    private Float presencePenalty;
    @JsonProperty(value="logit_bias")
    private Map logitBias;
    private Boolean logprobs;
    @JsonProperty(value="top_logprobs")
    private Integer topLogprobs;

    private static Boolean $default$stream() {
        return false;
    }

    private static StreamOptions $default$streamOptions() {
        return new StreamOptions();
    }

    private static Float $default$frequencyPenalty() {
        return Float.valueOf(0.0f);
    }

    private static Float $default$temperature() {
        return Float.valueOf(1.0f);
    }

    private static Float $default$topP() {
        return Float.valueOf(1.0f);
    }

    private static Boolean $default$parallelToolCalls() {
        return true;
    }

    private static Integer $default$n() {
        return 1;
    }

    private static Float $default$presencePenalty() {
        return Float.valueOf(0.0f);
    }

    private static Boolean $default$logprobs() {
        return false;
    }

    public static ChatCompletionBuilder builder() {
        return new ChatCompletionBuilder();
    }

    public ChatCompletionBuilder toBuilder() {
        ChatCompletionBuilder builder = new ChatCompletionBuilder().model(this.model).stream(this.stream).streamOptions(this.streamOptions).frequencyPenalty(this.frequencyPenalty).temperature(this.temperature).topP(this.topP).maxTokens(this.maxTokens).tools(this.tools).functions(this.functions).toolChoice(this.toolChoice).parallelToolCalls(this.parallelToolCalls).responseFormat(this.responseFormat).user(this.user).n(this.n).stop(this.stop).presencePenalty(this.presencePenalty).logitBias(this.logitBias).logprobs(this.logprobs).topLogprobs(this.topLogprobs);
        if (this.messages != null) {
            builder.messages(this.messages);
        }
        return builder;
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public StreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public Float getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public List<String> getFunctions() {
        return this.functions;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public Object getResponseFormat() {
        return this.responseFormat;
    }

    public String getUser() {
        return this.user;
    }

    public Integer getN() {
        return this.n;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Float getPresencePenalty() {
        return this.presencePenalty;
    }

    public Map getLogitBias() {
        return this.logitBias;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setMessages(@NonNull List<ChatMessage> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.messages = messages;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    @JsonProperty(value="stream_options")
    public void setStreamOptions(StreamOptions streamOptions) {
        this.streamOptions = streamOptions;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(Float frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Float topP) {
        this.topP = topP;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    @JsonIgnore
    public void setFunctions(List<String> functions) {
        this.functions = functions;
    }

    @JsonProperty(value="tool_choice")
    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }

    @JsonProperty(value="parallel_tool_calls")
    public void setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
    }

    @JsonProperty(value="response_format")
    public void setResponseFormat(Object responseFormat) {
        this.responseFormat = responseFormat;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(Float presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="logit_bias")
    public void setLogitBias(Map logitBias) {
        this.logitBias = logitBias;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    @JsonProperty(value="top_logprobs")
    public void setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletion)) {
            return false;
        }
        ChatCompletion other = (ChatCompletion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Float this$frequencyPenalty = this.getFrequencyPenalty();
        Float other$frequencyPenalty = other.getFrequencyPenalty();
        if (this$frequencyPenalty == null ? other$frequencyPenalty != null : !((Object)this$frequencyPenalty).equals(other$frequencyPenalty)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Float this$topP = this.getTopP();
        Float other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Boolean this$parallelToolCalls = this.getParallelToolCalls();
        Boolean other$parallelToolCalls = other.getParallelToolCalls();
        if (this$parallelToolCalls == null ? other$parallelToolCalls != null : !((Object)this$parallelToolCalls).equals(other$parallelToolCalls)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Float this$presencePenalty = this.getPresencePenalty();
        Float other$presencePenalty = other.getPresencePenalty();
        if (this$presencePenalty == null ? other$presencePenalty != null : !((Object)this$presencePenalty).equals(other$presencePenalty)) {
            return false;
        }
        Boolean this$logprobs = this.getLogprobs();
        Boolean other$logprobs = other.getLogprobs();
        if (this$logprobs == null ? other$logprobs != null : !((Object)this$logprobs).equals(other$logprobs)) {
            return false;
        }
        Integer this$topLogprobs = this.getTopLogprobs();
        Integer other$topLogprobs = other.getTopLogprobs();
        if (this$topLogprobs == null ? other$topLogprobs != null : !((Object)this$topLogprobs).equals(other$topLogprobs)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<ChatMessage> this$messages = this.getMessages();
        List<ChatMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        StreamOptions this$streamOptions = this.getStreamOptions();
        StreamOptions other$streamOptions = other.getStreamOptions();
        if (this$streamOptions == null ? other$streamOptions != null : !((Object)this$streamOptions).equals(other$streamOptions)) {
            return false;
        }
        List<Tool> this$tools = this.getTools();
        List<Tool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        List<String> this$functions = this.getFunctions();
        List<String> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        String this$toolChoice = this.getToolChoice();
        String other$toolChoice = other.getToolChoice();
        if (this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice)) {
            return false;
        }
        Object this$responseFormat = this.getResponseFormat();
        Object other$responseFormat = other.getResponseFormat();
        if (this$responseFormat == null ? other$responseFormat != null : !this$responseFormat.equals(other$responseFormat)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map this$logitBias = this.getLogitBias();
        Map other$logitBias = other.getLogitBias();
        return !(this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Float $frequencyPenalty = this.getFrequencyPenalty();
        result = result * 59 + ($frequencyPenalty == null ? 43 : ((Object)$frequencyPenalty).hashCode());
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Float $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Boolean $parallelToolCalls = this.getParallelToolCalls();
        result = result * 59 + ($parallelToolCalls == null ? 43 : ((Object)$parallelToolCalls).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Float $presencePenalty = this.getPresencePenalty();
        result = result * 59 + ($presencePenalty == null ? 43 : ((Object)$presencePenalty).hashCode());
        Boolean $logprobs = this.getLogprobs();
        result = result * 59 + ($logprobs == null ? 43 : ((Object)$logprobs).hashCode());
        Integer $topLogprobs = this.getTopLogprobs();
        result = result * 59 + ($topLogprobs == null ? 43 : ((Object)$topLogprobs).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<ChatMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        StreamOptions $streamOptions = this.getStreamOptions();
        result = result * 59 + ($streamOptions == null ? 43 : ((Object)$streamOptions).hashCode());
        List<Tool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        List<String> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        String $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        Object $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : $responseFormat.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        return result;
    }

    public String toString() {
        return "ChatCompletion(model=" + this.getModel() + ", messages=" + this.getMessages() + ", stream=" + this.getStream() + ", streamOptions=" + this.getStreamOptions() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", maxTokens=" + this.getMaxTokens() + ", tools=" + this.getTools() + ", functions=" + this.getFunctions() + ", toolChoice=" + this.getToolChoice() + ", parallelToolCalls=" + this.getParallelToolCalls() + ", responseFormat=" + this.getResponseFormat() + ", user=" + this.getUser() + ", n=" + this.getN() + ", stop=" + this.getStop() + ", presencePenalty=" + this.getPresencePenalty() + ", logitBias=" + this.getLogitBias() + ", logprobs=" + this.getLogprobs() + ", topLogprobs=" + this.getTopLogprobs() + ")";
    }

    private ChatCompletion() {
        this.stream = ChatCompletion.$default$stream();
        this.streamOptions = ChatCompletion.$default$streamOptions();
        this.frequencyPenalty = ChatCompletion.$default$frequencyPenalty();
        this.temperature = ChatCompletion.$default$temperature();
        this.topP = ChatCompletion.$default$topP();
        this.parallelToolCalls = ChatCompletion.$default$parallelToolCalls();
        this.n = ChatCompletion.$default$n();
        this.presencePenalty = ChatCompletion.$default$presencePenalty();
        this.logprobs = ChatCompletion.$default$logprobs();
    }

    private ChatCompletion(@NonNull String model, @NonNull List<ChatMessage> messages, Boolean stream, StreamOptions streamOptions, Float frequencyPenalty, Float temperature, Float topP, Integer maxTokens, List<Tool> tools, List<String> functions, String toolChoice, Boolean parallelToolCalls, Object responseFormat, String user, Integer n, List<String> stop, Float presencePenalty, Map logitBias, Boolean logprobs, Integer topLogprobs) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.model = model;
        this.messages = messages;
        this.stream = stream;
        this.streamOptions = streamOptions;
        this.frequencyPenalty = frequencyPenalty;
        this.temperature = temperature;
        this.topP = topP;
        this.maxTokens = maxTokens;
        this.tools = tools;
        this.functions = functions;
        this.toolChoice = toolChoice;
        this.parallelToolCalls = parallelToolCalls;
        this.responseFormat = responseFormat;
        this.user = user;
        this.n = n;
        this.stop = stop;
        this.presencePenalty = presencePenalty;
        this.logitBias = logitBias;
        this.logprobs = logprobs;
        this.topLogprobs = topLogprobs;
    }

    public static class ChatCompletionBuilder {
        private String model;
        private ArrayList<ChatMessage> messages;
        private boolean stream$set;
        private Boolean stream$value;
        private boolean streamOptions$set;
        private StreamOptions streamOptions$value;
        private boolean frequencyPenalty$set;
        private Float frequencyPenalty$value;
        private boolean temperature$set;
        private Float temperature$value;
        private boolean topP$set;
        private Float topP$value;
        private Integer maxTokens;
        private List<Tool> tools;
        private String toolChoice;
        private boolean parallelToolCalls$set;
        private Boolean parallelToolCalls$value;
        private Object responseFormat;
        private String user;
        private boolean n$set;
        private Integer n$value;
        private List<String> stop;
        private boolean presencePenalty$set;
        private Float presencePenalty$value;
        private Map logitBias;
        private boolean logprobs$set;
        private Boolean logprobs$value;
        private Integer topLogprobs;
        private List<String> functions;

        public ChatCompletionBuilder functions(String ... functions) {
            if (this.functions == null) {
                this.functions = new ArrayList<String>();
            }
            this.functions.addAll(Arrays.asList(functions));
            return this;
        }

        public ChatCompletionBuilder functions(List<String> functions) {
            if (this.functions == null) {
                this.functions = new ArrayList<String>();
            }
            this.functions.addAll(functions);
            return this;
        }

        ChatCompletionBuilder() {
        }

        public ChatCompletionBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public ChatCompletionBuilder message(ChatMessage message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return this;
        }

        public ChatCompletionBuilder messages(Collection<? extends ChatMessage> messages) {
            if (messages == null) {
                throw new NullPointerException("messages cannot be null");
            }
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return this;
        }

        public ChatCompletionBuilder clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return this;
        }

        public ChatCompletionBuilder stream(Boolean stream) {
            this.stream$value = stream;
            this.stream$set = true;
            return this;
        }

        @JsonProperty(value="stream_options")
        public ChatCompletionBuilder streamOptions(StreamOptions streamOptions) {
            this.streamOptions$value = streamOptions;
            this.streamOptions$set = true;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public ChatCompletionBuilder frequencyPenalty(Float frequencyPenalty) {
            this.frequencyPenalty$value = frequencyPenalty;
            this.frequencyPenalty$set = true;
            return this;
        }

        public ChatCompletionBuilder temperature(Float temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        @JsonProperty(value="top_p")
        public ChatCompletionBuilder topP(Float topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public ChatCompletionBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public ChatCompletionBuilder tools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        @JsonProperty(value="tool_choice")
        public ChatCompletionBuilder toolChoice(String toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        @JsonProperty(value="parallel_tool_calls")
        public ChatCompletionBuilder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls$value = parallelToolCalls;
            this.parallelToolCalls$set = true;
            return this;
        }

        @JsonProperty(value="response_format")
        public ChatCompletionBuilder responseFormat(Object responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public ChatCompletionBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ChatCompletionBuilder n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return this;
        }

        public ChatCompletionBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public ChatCompletionBuilder presencePenalty(Float presencePenalty) {
            this.presencePenalty$value = presencePenalty;
            this.presencePenalty$set = true;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public ChatCompletionBuilder logitBias(Map logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public ChatCompletionBuilder logprobs(Boolean logprobs) {
            this.logprobs$value = logprobs;
            this.logprobs$set = true;
            return this;
        }

        @JsonProperty(value="top_logprobs")
        public ChatCompletionBuilder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        public ChatCompletion build() {
            List<Object> messages;
            switch (this.messages == null ? 0 : this.messages.size()) {
                case 0: {
                    messages = Collections.emptyList();
                    break;
                }
                case 1: {
                    messages = Collections.singletonList(this.messages.get(0));
                    break;
                }
                default: {
                    messages = Collections.unmodifiableList(new ArrayList<ChatMessage>(this.messages));
                }
            }
            Boolean stream$value = this.stream$value;
            if (!this.stream$set) {
                stream$value = ChatCompletion.$default$stream();
            }
            StreamOptions streamOptions$value = this.streamOptions$value;
            if (!this.streamOptions$set) {
                streamOptions$value = ChatCompletion.$default$streamOptions();
            }
            Float frequencyPenalty$value = this.frequencyPenalty$value;
            if (!this.frequencyPenalty$set) {
                frequencyPenalty$value = ChatCompletion.$default$frequencyPenalty();
            }
            Float temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = ChatCompletion.$default$temperature();
            }
            Float topP$value = this.topP$value;
            if (!this.topP$set) {
                topP$value = ChatCompletion.$default$topP();
            }
            Boolean parallelToolCalls$value = this.parallelToolCalls$value;
            if (!this.parallelToolCalls$set) {
                parallelToolCalls$value = ChatCompletion.$default$parallelToolCalls();
            }
            Integer n$value = this.n$value;
            if (!this.n$set) {
                n$value = ChatCompletion.$default$n();
            }
            Float presencePenalty$value = this.presencePenalty$value;
            if (!this.presencePenalty$set) {
                presencePenalty$value = ChatCompletion.$default$presencePenalty();
            }
            Boolean logprobs$value = this.logprobs$value;
            if (!this.logprobs$set) {
                logprobs$value = ChatCompletion.$default$logprobs();
            }
            return new ChatCompletion(this.model, messages, stream$value, streamOptions$value, frequencyPenalty$value, temperature$value, topP$value, this.maxTokens, this.tools, this.functions, this.toolChoice, parallelToolCalls$value, this.responseFormat, this.user, n$value, this.stop, presencePenalty$value, this.logitBias, logprobs$value, this.topLogprobs);
        }

        public String toString() {
            return "ChatCompletion.ChatCompletionBuilder(model=" + this.model + ", messages=" + this.messages + ", stream$value=" + this.stream$value + ", streamOptions$value=" + this.streamOptions$value + ", frequencyPenalty$value=" + this.frequencyPenalty$value + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", maxTokens=" + this.maxTokens + ", tools=" + this.tools + ", functions=" + this.functions + ", toolChoice=" + this.toolChoice + ", parallelToolCalls$value=" + this.parallelToolCalls$value + ", responseFormat=" + this.responseFormat + ", user=" + this.user + ", n$value=" + this.n$value + ", stop=" + this.stop + ", presencePenalty$value=" + this.presencePenalty$value + ", logitBias=" + this.logitBias + ", logprobs$value=" + this.logprobs$value + ", topLogprobs=" + this.topLogprobs + ")";
        }
    }
}

