/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.tools.utils;

import ink.rayin.tools.support.StrFormatter;
import ink.rayin.tools.support.StrSpliter;
import ink.rayin.tools.utils.Func;
import ink.rayin.tools.utils.ObjectUtil;
import ink.rayin.tools.utils.RandomType;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StringUtil
extends StringUtils {
    public static final int INDEX_NOT_FOUND = -1;
    private static final String S_INT = "0123456789";
    private static final String S_STR = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String S_ALL = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public static boolean isBlank(CharSequence cs) {
        return !StringUtil.hasText((CharSequence)cs);
    }

    public static boolean isNotBlank(CharSequence cs) {
        return StringUtil.hasText((CharSequence)cs);
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ObjectUtil.isEmpty((Object[])css)) {
            return true;
        }
        return Stream.of(css).anyMatch(StringUtil::isBlank);
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        if (ObjectUtil.isEmpty((Object[])css)) {
            return false;
        }
        return Stream.of(css).allMatch(StringUtil::isNotBlank);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtil.isBlank(cs)) {
            return false;
        }
        int i = cs.length();
        while (--i >= 0) {
            char chr = cs.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static String join(Collection<?> coll) {
        return StringUtil.collectionToCommaDelimitedString(coll);
    }

    public static String join(Collection<?> coll, String delim) {
        return StringUtil.collectionToDelimitedString(coll, (String)delim);
    }

    public static String join(Object[] arr) {
        return StringUtil.arrayToCommaDelimitedString((Object[])arr);
    }

    public static String join(Object[] arr, String delim) {
        return StringUtil.arrayToDelimitedString((Object[])arr, (String)delim);
    }

    public static String randomUUID() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return new UUID(random.nextLong(), random.nextLong()).toString().replace("-", "");
    }

    public static String cleanChars(String txt) {
        return txt.replaceAll("[ \u3000`\u00b7\u2022\ufffd\u0001\\f\\t\\v\\s]", "");
    }

    public static String random(int count) {
        return StringUtil.random(count, RandomType.ALL);
    }

    public static String random(int count, RandomType randomType) {
        if (count == 0) {
            return "";
        }
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)("Requested random string length " + count + " is less than 0."));
        ThreadLocalRandom random = ThreadLocalRandom.current();
        char[] buffer = new char[count];
        for (int i = 0; i < count; ++i) {
            buffer[i] = RandomType.INT == randomType ? S_INT.charAt(random.nextInt(S_INT.length())) : (RandomType.STRING == randomType ? S_STR.charAt(random.nextInt(S_STR.length())) : S_ALL.charAt(random.nextInt(S_ALL.length())));
        }
        return new String(buffer);
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return null;
        }
        if (Func.isEmpty(params) || StringUtil.isBlank(template)) {
            return template.toString();
        }
        return StrFormatter.format(template.toString(), params);
    }

    public static String indexedFormat(CharSequence pattern, Object ... arguments) {
        return MessageFormat.format(pattern.toString(), arguments);
    }

    public static String format(CharSequence template, Map<?, ?> map) {
        if (null == template) {
            return null;
        }
        if (null == map || map.isEmpty()) {
            return template.toString();
        }
        String template2 = template.toString();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            template2 = template2.replace("{" + entry.getKey() + "}", Func.toStr(entry.getValue()));
        }
        return template2;
    }

    public static List<String> split(CharSequence str, char separator, int limit) {
        return StringUtil.split(str, separator, limit, false, false);
    }

    public static List<String> splitTrim(CharSequence str, char separator) {
        return StringUtil.splitTrim(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator) {
        return StringUtil.splitTrim(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, char separator, int limit) {
        return StringUtil.split(str, separator, limit, true, true);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator, int limit) {
        return StringUtil.split(str, separator, limit, true, true);
    }

    public static List<String> split(CharSequence str, char separator, boolean isTrim, boolean ignoreEmpty) {
        return StringUtil.split(str, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str) {
            return new ArrayList<String>(0);
        }
        return StrSpliter.split(str.toString(), separator, limit, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str) {
            return new ArrayList<String>(0);
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StrSpliter.split(str.toString(), separatorStr, limit, isTrim, ignoreEmpty);
    }

    public static String[] split(CharSequence str, CharSequence separator) {
        if (str == null) {
            return new String[0];
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StrSpliter.splitToArray(str.toString(), separatorStr, 0, false, false);
    }

    public static String[] split(CharSequence str, int len) {
        if (null == str) {
            return new String[0];
        }
        return StrSpliter.splitByLength(str.toString(), len);
    }

    public static boolean contains(CharSequence str, char searchChar) {
        return StringUtil.indexOf(str, searchChar) > -1;
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtil.getContainsStr(str, testStrs);
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (StringUtil.isEmpty((Object)str) || Func.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!str.toString().contains(checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toString().toLowerCase().contains(testStr.toString().toLowerCase());
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtil.getContainsStrIgnoreCase(str, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (StringUtil.isEmpty((Object)str) || Func.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence testStr : testStrs) {
            if (!StringUtil.containsIgnoreCase(str, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static String sub(CharSequence str, int fromIndex, int toIndex) {
        if (StringUtil.isEmpty((Object)str)) {
            return "";
        }
        int len = str.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return "";
        }
        return str.toString().substring(fromIndex, toIndex);
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StringUtil.isEmpty((Object)string) || separator == null) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return "";
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StringUtil.isEmpty((Object)string)) {
            return null == string ? null : string.toString();
        }
        if (separator == null) {
            return "";
        }
        String str = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        int end;
        if (str == null || before == null || after == null) {
            return null;
        }
        String str2 = str.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = str2.indexOf(before2);
        if (start != -1 && (end = str2.indexOf(after2, start + before2.length())) != -1) {
            return str2.substring(start + before2.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence str, CharSequence beforeAndAfter) {
        return StringUtil.subBetween(str, beforeAndAfter, beforeAndAfter);
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        if (StringUtil.isEmpty((Object)str) || StringUtil.isEmpty((Object)prefix)) {
            return "";
        }
        String str2 = str.toString();
        if (str2.startsWith(prefix.toString())) {
            return StringUtil.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removePrefixIgnoreCase(CharSequence str, CharSequence prefix) {
        if (StringUtil.isEmpty((Object)str) || StringUtil.isEmpty((Object)prefix)) {
            return "";
        }
        String str2 = str.toString();
        if (str2.toLowerCase().startsWith(prefix.toString().toLowerCase())) {
            return StringUtil.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (StringUtil.isEmpty((Object)str) || StringUtil.isEmpty((Object)suffix)) {
            return "";
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return StringUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String removeSufAndLowerFirst(CharSequence str, CharSequence suffix) {
        return StringUtil.lowerFirst(StringUtil.removeSuffix(str, suffix));
    }

    public static String removeSuffixIgnoreCase(CharSequence str, CharSequence suffix) {
        if (StringUtil.isEmpty((Object)str) || StringUtil.isEmpty((Object)suffix)) {
            return "";
        }
        String str2 = str.toString();
        if (str2.toLowerCase().endsWith(suffix.toString().toLowerCase())) {
            return StringUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String lowerFirst(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String upperFirst(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static String subPre(CharSequence string, int toIndex) {
        return StringUtil.sub(string, 0, toIndex);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (StringUtil.isEmpty((Object)string)) {
            return null;
        }
        return StringUtil.sub(string, fromIndex, string.length());
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return StringUtil.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return StringUtil.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence str, char searchChar, int start, int end) {
        int len = str.length();
        if (start < 0 || start > len) {
            start = 0;
        }
        if (end > len || end < 0) {
            end = len;
        }
        for (int i = start; i < end; ++i) {
            if (str.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtil.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringUtil.indexOf(str, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().indexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i < endLimit; ++i) {
            if (!StringUtil.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtil.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringUtil.lastIndexOf(str, searchStr, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        fromIndex = Math.min(fromIndex, str.length());
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().lastIndexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i > 0; --i) {
            if (!StringUtil.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int ordinalIndexOf(String str, String searchStr, int ordinal) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = str.indexOf(searchStr, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return StringUtil.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return StringUtil.equals(str1, str2, true);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.equals(str2);
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StringBuilder builder(CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static StringBuilder appendBuilder(StringBuilder sb, CharSequence ... strs) {
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static StringReader getReader(CharSequence str) {
        if (null == str) {
            return null;
        }
        return new StringReader(str.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (Func.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (StringUtil.isEmpty((Object)content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String underlineToHump(String para) {
        String[] a;
        StringBuilder result = new StringBuilder();
        for (String s : a = para.split("_")) {
            if (result.length() == 0) {
                result.append(s.toLowerCase());
                continue;
            }
            result.append(s.substring(0, 1).toUpperCase());
            result.append(s.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String humpToUnderline(String para) {
        para = StringUtil.lowerFirst(para);
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 0; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }

    public static String lineToHump(String para) {
        String[] a;
        StringBuilder result = new StringBuilder();
        for (String s : a = para.split("-")) {
            if (result.length() == 0) {
                result.append(s.toLowerCase());
                continue;
            }
            result.append(s.substring(0, 1).toUpperCase());
            result.append(s.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String humpToLine(String para) {
        para = StringUtil.lowerFirst(para);
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 0; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "-");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }
}

