/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.tools.utils;

import ink.rayin.tools.utils.Exceptions;
import ink.rayin.tools.utils.IoUtil;
import ink.rayin.tools.utils.SpringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

public class ResourceUtil
extends ResourceUtils {
    public static final String HTTP_REGEX = "^https?:.+$";
    public static final String FTP_URL_PREFIX = "ftp:";

    public static Resource getResource(String resourceLocation) throws IOException {
        Assert.notNull((Object)resourceLocation, (String)"Resource location must not be null");
        if (resourceLocation.startsWith("classpath:")) {
            return new ClassPathResource(resourceLocation);
        }
        if (resourceLocation.startsWith(FTP_URL_PREFIX)) {
            return new UrlResource(resourceLocation);
        }
        if (resourceLocation.matches(HTTP_REGEX)) {
            return new UrlResource(resourceLocation);
        }
        if (resourceLocation.startsWith("classpath*:")) {
            return SpringUtil.getContext().getResource(resourceLocation);
        }
        if (!resourceLocation.startsWith(System.getProperty("file.separator")) && resourceLocation.indexOf(":") < 0) {
            return new ClassPathResource(resourceLocation);
        }
        return new FileSystemResource(resourceLocation);
    }

    public static InputStream getResourceAsStream(String resourceLocation) throws IOException {
        return ResourceUtil.getResource(resourceLocation).getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getResourceAsString(String resourceLocation, Charset encoding) throws IOException {
        try (InputStream in = ResourceUtil.getResource(resourceLocation).getInputStream();){
            String string = IoUtil.toString(in, encoding);
            return string;
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static ByteArrayOutputStream getResourceAsByte(String resourceLocation) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = ResourceUtil.getResourceAsStream(resourceLocation);
        out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
        return out;
    }

    public static String getResourceAbsolutePathByClassPath(String classpath) throws IOException {
        return ResourceUtil.getResource(classpath).getFile().getAbsolutePath();
    }
}

